/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.ActionArgumentsFactory;
import me.mrgeneralq.bloodmoon.defaults.DefaultMob;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMobService;
import me.mrgeneralq.bloodmoon.models.Bloodmoon;
import me.mrgeneralq.bloodmoon.models.LifeCycle;
import me.mrgeneralq.bloodmoon.statics.Statics;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class OnEntityDeath
implements Listener {
    private final IBloodmoonService bloodmoonService;
    private final IMobService mobService;
    private final IConfigService configService;

    public OnEntityDeath(IBloodmoonService iBloodmoonService, IMobService iMobService, IConfigService iConfigService) {
        this.bloodmoonService = iBloodmoonService;
        this.mobService = iMobService;
        this.configService = iConfigService;
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent entityDeathEvent) {
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        List list = livingEntity.getMetadata("mobID");
        if (list.size() >= 1) {
            Object object;
            String string = ((MetadataValue)list.get(0)).asString();
            if (this.processRespawn(entityDeathEvent.getEntity())) {
                return;
            }
            Bloodmoon bloodmoon2 = this.bloodmoonService.getBloodmoon(entityDeathEvent.getEntity().getWorld());
            if (bloodmoon2 == null) {
                return;
            }
            DefaultMob defaultMob = this.mobService.getMob(livingEntity);
            if (defaultMob == null) {
                return;
            }
            LifeCycle lifeCycle = this.mobService.getLifeCycle(livingEntity.getUniqueId());
            if (lifeCycle != null) {
                object = new ActionArgumentsFactory((Bloodmoon)this.bloodmoonService.getAllBloodmoons().stream().filter(bloodmoon -> bloodmoon.getWorld() == entityDeathEvent.getEntity().getWorld()).collect(Collectors.toList()).get(0), null, (Entity)livingEntity);
                lifeCycle.executeDeath((ActionArgumentsFactory)object, (Entity)livingEntity.getKiller(), livingEntity.getWorld());
            }
            bloodmoon2.despawnMob((Entity)livingEntity);
            object = this.mobService.getDrops(string);
            try {
                EntityEquipment entityEquipment = livingEntity.getEquipment();
                if (entityEquipment != null) {
                    entityEquipment.setChestplateDropChance(0.0f);
                    entityEquipment.setHelmetDropChance(0.0f);
                    entityEquipment.setBootsDropChance(0.0f);
                    entityEquipment.setLeggingsDropChance(0.0f);
                    entityEquipment.setItemInMainHandDropChance(0.0f);
                    entityEquipment.setItemInOffHandDropChance(0.0f);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (((HashMap)object).size() != 0) {
                entityDeathEvent.getDrops().clear();
            }
            for (Map.Entry entry : ((HashMap)object).entrySet()) {
                double d = new Random().nextDouble() * 100.0;
                if (!((Double)entry.getValue() >= d)) continue;
                entityDeathEvent.getDrops().add((ItemStack)entry.getKey());
            }
        }
    }

    private boolean processRespawn(LivingEntity livingEntity) {
        List list = livingEntity.getMetadata("doRespawn");
        if (list.size() == 0) {
            return false;
        }
        MetadataValue metadataValue = (MetadataValue)list.get(0);
        if (!(metadataValue instanceof FixedMetadataValue)) {
            return false;
        }
        FixedMetadataValue fixedMetadataValue = (FixedMetadataValue)metadataValue;
        if (fixedMetadataValue.asBoolean()) {
            DefaultMob defaultMob = this.mobService.getMob(livingEntity);
            defaultMob.setHealth(defaultMob.getHealth() / 2.0);
            LivingEntity livingEntity2 = this.mobService.spawnMob(livingEntity.getLocation(), defaultMob);
            livingEntity2.setMetadata("doRespawn", (MetadataValue)new FixedMetadataValue(this.mobService.getPlugin(), (Object)false));
            Statics.createRespawnEffect(livingEntity.getLocation());
            if (this.bloodmoonService.bloodmoonIsRunning(livingEntity2.getWorld())) {
                this.bloodmoonService.registerMob(livingEntity2, livingEntity2.getWorld());
            }
        }
        return fixedMetadataValue.asBoolean();
    }
}

