/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonScheduleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class OnPlayerBedEnter
implements Listener {
    private final IBloodmoonService bloodmoonService;
    private final IConfigService configService;
    private final IMessageService messageService;
    private final IBloodmoonScheduleService scheduleService;

    public OnPlayerBedEnter(IBloodmoonService iBloodmoonService, IConfigService iConfigService, IMessageService iMessageService, IBloodmoonScheduleService iBloodmoonScheduleService) {
        this.bloodmoonService = iBloodmoonService;
        this.configService = iConfigService;
        this.messageService = iMessageService;
        this.scheduleService = iBloodmoonScheduleService;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent playerInteractEvent) {
        Player player;
        block9: {
            if (playerInteractEvent.getPlayer().getWorld().getTime() < 12500L || !this.bloodmoonService.bloodmoonIsRunning(playerInteractEvent.getPlayer().getWorld()) && !this.scheduleService.isScheduled(playerInteractEvent.getPlayer().getWorld())) {
                return;
            }
            player = playerInteractEvent.getPlayer();
            World world = player.getWorld();
            if (!this.configService.isSleepingDisabled()) {
                return;
            }
            if (!this.scheduleService.isScheduled(world)) {
                return;
            }
            if (!this.bloodmoonService.bloodmoonIsRunning(world)) {
                return;
            }
            if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
                return;
            }
            if (player.hasPermission("bloodmoon.bypass.sleep")) {
                return;
            }
            try {
                if (playerInteractEvent.getClickedBlock().getType() != Material.valueOf((String)"BLACK_BED") && playerInteractEvent.getClickedBlock().getType() != Material.valueOf((String)"BLUE_BED") && playerInteractEvent.getClickedBlock().getType() != Material.valueOf((String)"BROWN_BED") && playerInteractEvent.getClickedBlock().getType() != Material.valueOf((String)"CYAN_BED") && playerInteractEvent.getClickedBlock().getType() != Material.valueOf((String)"GRAY_BED") && playerInteractEvent.getClickedBlock().getType() != Material.valueOf((String)"GREEN_BED") && playerInteractEvent.getClickedBlock().getType() != Material.valueOf((String)"LIGHT_BLUE_BED") && playerInteractEvent.getClickedBlock().getType() != Material.valueOf((String)"LIGHT_GRAY_BED") && playerInteractEvent.getClickedBlock().getType() != Material.valueOf((String)"LIME_BED") && playerInteractEvent.getClickedBlock().getType() != Material.valueOf((String)"LIGHT_GRAY_BED") && playerInteractEvent.getClickedBlock().getType() != Material.valueOf((String)"MAGENTA_BED") && playerInteractEvent.getClickedBlock().getType() != Material.valueOf((String)"ORANGE_BED") && playerInteractEvent.getClickedBlock().getType() != Material.valueOf((String)"PINK_BED") && playerInteractEvent.getClickedBlock().getType() != Material.valueOf((String)"PURPLE_BED") && playerInteractEvent.getClickedBlock().getType() != Material.valueOf((String)"WHITE_BED") && playerInteractEvent.getClickedBlock().getType() != Material.valueOf((String)"RED_BED")) {
                    return;
                }
            }
            catch (Exception exception) {
                if (playerInteractEvent.getClickedBlock().getType() == Material.valueOf((String)"BED")) break block9;
                return;
            }
        }
        playerInteractEvent.setCancelled(true);
        player.sendMessage(this.messageService.getMessage(Message.sleep, true));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerBedEnter(PlayerBedEnterEvent playerBedEnterEvent) {
        if (!this.bloodmoonService.bloodmoonIsRunning(playerBedEnterEvent.getPlayer().getWorld())) {
            return;
        }
        if (!this.configService.isSleepingDisabled()) {
            return;
        }
        playerBedEnterEvent.setCancelled(true);
        Player player = playerBedEnterEvent.getPlayer();
        player.sendMessage(this.messageService.getMessage(Message.sleep, true));
    }
}

