/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IResourcePackService;
import me.mrgeneralq.bloodmoon.models.Bloodmoon;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;

public class OnWorldChange
implements Listener {
    private final IBloodmoonService bloodmoonService;
    private final IResourcePackService resourcePackService;
    private final IConfigService configService;

    public OnWorldChange(IBloodmoonService iBloodmoonService, IResourcePackService iResourcePackService, IConfigService iConfigService) {
        this.bloodmoonService = iBloodmoonService;
        this.resourcePackService = iResourcePackService;
        this.configService = iConfigService;
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Player player = playerChangedWorldEvent.getPlayer();
        Bloodmoon bloodmoon = this.bloodmoonService.getBloodmoon(playerChangedWorldEvent.getFrom());
        bloodmoon.getBossbar().removePlayer(player);
        Bloodmoon bloodmoon2 = this.bloodmoonService.getBloodmoon(player.getWorld());
        bloodmoon2.getBossbar().addPlayer(player);
        if (this.bloodmoonService.bloodmoonIsRunning(player.getWorld()) && this.bloodmoonService.bloodmoonIsRunning(playerChangedWorldEvent.getFrom())) {
            return;
        }
        if (!this.bloodmoonService.bloodmoonIsRunning(player.getWorld()) && !this.bloodmoonService.bloodmoonIsRunning(playerChangedWorldEvent.getFrom())) {
            return;
        }
        if (this.configService.isSetResourcePack()) {
            this.resourcePackService.setResourcePackEnabled(player, this.bloodmoonService.bloodmoonIsRunning(player.getWorld()));
        }
    }
}

