/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.factories;

import java.util.HashMap;
import me.mrgeneralq.bloodmoon.BloodmoonCore;
import me.mrgeneralq.bloodmoon.actions.sign.ButcherSignAction;
import me.mrgeneralq.bloodmoon.actions.sign.CancelSignAction;
import me.mrgeneralq.bloodmoon.actions.sign.ItemSignAction;
import me.mrgeneralq.bloodmoon.actions.sign.NextSignAction;
import me.mrgeneralq.bloodmoon.actions.sign.StartSignAction;
import me.mrgeneralq.bloodmoon.actions.sign.StopSignAction;
import me.mrgeneralq.bloodmoon.interfaces.actions.ISignAction;

public class SignActionFactory {
    private BloodmoonCore bloodmoonCore;
    private HashMap<String, ISignAction> actionList = new HashMap();
    private static SignActionFactory instance;

    private SignActionFactory() {
    }

    public void build(BloodmoonCore bloodmoonCore) {
        this.bloodmoonCore = bloodmoonCore;
        this.actionList.put("start", new StartSignAction());
        this.actionList.put("stop", new StopSignAction());
        this.actionList.put("next", new NextSignAction());
        this.actionList.put("cancel", new CancelSignAction());
        this.actionList.put("butcher", new ButcherSignAction());
        this.actionList.put("item", new ItemSignAction());
    }

    public static SignActionFactory getFactory() {
        if (instance == null) {
            instance = new SignActionFactory();
        }
        return instance;
    }

    public ISignAction getAction(String string) {
        return this.actionList.get(string);
    }

    public boolean actionExists(String string) {
        return this.actionList.containsKey(string);
    }
}

