/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.models;

import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.HashMap;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import me.mrgeneralq.bloodmoon.enums.BloodmoonEndCause;
import me.mrgeneralq.bloodmoon.enums.BloodmoonState;
import me.mrgeneralq.bloodmoon.events.BloodmoonStartEvent;
import me.mrgeneralq.bloodmoon.events.BloodmoonStopEvent;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IResourcePackService;
import me.mrgeneralq.bloodmoon.statics.Bootstrapper;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Bloodmoon {
    private BloodmoonState bloodmoonState;
    private final UUID world;
    private final HashMap<UUID, LivingEntity> registeredMobs;
    private Difficulty difficulty;
    private Difficulty oldDifficulty;
    private int monsterLimit;
    private final BossBar bossbar;
    private IConfigService configService;
    private IResourcePackService resourcePackService;

    public Bloodmoon(World world, BossBar bossBar) {
        this.bossbar = bossBar;
        this.world = world.getUID();
        this.registeredMobs = new HashMap();
        this.configService = Bootstrapper.getBootstrapper().getConfigService();
        this.resourcePackService = Bootstrapper.getBootstrapper().getResourcePackService();
    }

    public void setState(BloodmoonState bloodmoonState) {
        this.bloodmoonState = bloodmoonState;
    }

    public void start() {
        World world = Bukkit.getWorld((UUID)this.world);
        this.monsterLimit = world.getMonsterSpawnLimit();
        world.setMonsterSpawnLimit(this.configService.getMonsterLimit());
        this.setState(BloodmoonState.RUNNING);
        Bukkit.getPluginManager().callEvent((Event)new BloodmoonStartEvent(this));
    }

    public void cancel() {
        this.setState(BloodmoonState.IDLE);
    }

    public void stop() {
        World world = Bukkit.getWorld((UUID)this.world);
        world.setMonsterSpawnLimit(this.monsterLimit);
        this.setState(BloodmoonState.STOPPED);
        Bukkit.getPluginManager().callEvent((Event)new BloodmoonStopEvent(this, BloodmoonEndCause.DEFAULT));
        this.registeredMobs.clear();
    }

    public void stop(BloodmoonEndCause bloodmoonEndCause) {
        this.setState(BloodmoonState.STOPPED);
        Bukkit.getPluginManager().callEvent((Event)new BloodmoonStopEvent(this, bloodmoonEndCause));
    }

    @Deprecated
    public void setResourcePack(String string) {
        for (Player player : this.getWorld().getPlayers()) {
            if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI") && Bukkit.getPluginManager().isPluginEnabled("ForceResourcepack")) {
                String string2 = PlaceholderAPI.setPlaceholders((Player)player, (String)"%frp_storedpack%");
                Bukkit.dispatchCommand((CommandSender)player, (String)String.format("/usepack %s", string2));
                continue;
            }
            player.setResourcePack(string);
        }
    }

    public void setResourcePackEnabled(boolean bl) {
        World world = Bukkit.getWorld((UUID)this.world);
        this.resourcePackService.setResourcePackEnabled(world, bl);
    }

    public World getWorld() {
        return Bukkit.getWorld((UUID)this.world);
    }

    public BloodmoonState getState() {
        return this.bloodmoonState;
    }

    public HashMap<UUID, LivingEntity> getRegisteredMobs() {
        return this.registeredMobs;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void resetDifficulty() {
        World world = Bukkit.getWorld((UUID)this.world);
        world.setDifficulty(this.getOldDifficulty());
    }

    public void setDifficulty(Difficulty difficulty) {
        World world = Bukkit.getWorld((UUID)this.world);
        this.setOldDifficulty(world.getDifficulty());
        this.difficulty = difficulty;
        world.setDifficulty(difficulty);
    }

    public void removeMobs(boolean bl, Sound sound, boolean bl2, Particle particle) {
        World world = Bukkit.getWorld((UUID)this.world);
        for (LivingEntity livingEntity : this.getRegisteredMobs().values()) {
            if (!livingEntity.isValid()) continue;
            if (bl2) {
                livingEntity.getWorld().spawnParticle(particle, livingEntity.getLocation(), 100);
            }
            if (bl) {
                world.playSound(livingEntity.getLocation(), sound, 1.0f, 1.0f);
            }
            if (Bukkit.getPluginManager().isPluginEnabled("MythicMobs")) {
                MythicProvider.get().getMobManager().getActiveMobs().forEach(ActiveMob::unregister);
            }
            livingEntity.remove();
        }
        this.registeredMobs.clear();
    }

    public void removeMob(Entity entity, boolean bl, Sound sound, boolean bl2, Particle particle) {
        World world = Bukkit.getWorld((UUID)this.world);
        if (bl2) {
            entity.getWorld().spawnParticle(particle, entity.getLocation(), 100);
        }
        if (bl) {
            world.playSound(entity.getLocation(), sound, 1.0f, 1.0f);
        }
        entity.remove();
        this.registeredMobs.remove(entity.getUniqueId());
    }

    public void despawnMob(Entity entity) {
        boolean bl = this.configService.isPlayDespawnParticle();
        Particle particle = null;
        if (bl) {
            particle = this.configService.getDespawnParticle();
        }
        this.removeMob(entity, false, null, bl, particle);
    }

    public Difficulty getOldDifficulty() {
        return this.oldDifficulty;
    }

    public void setOldDifficulty(Difficulty difficulty) {
        this.oldDifficulty = difficulty;
    }

    public BloodmoonState getBloodmoonState() {
        return this.bloodmoonState;
    }

    public void setBloodmoonState(BloodmoonState bloodmoonState) {
        this.bloodmoonState = bloodmoonState;
    }

    public int getMonsterLimit() {
        return this.monsterLimit;
    }

    public void setMonsterLimit(int n) {
        this.monsterLimit = n;
    }

    public BossBar getBossbar() {
        return this.bossbar;
    }

    public IConfigService getConfigService() {
        return this.configService;
    }

    public void setConfigService(IConfigService iConfigService) {
        this.configService = iConfigService;
    }

    public IResourcePackService getResourcePackService() {
        return this.resourcePackService;
    }

    public void setResourcePackService(IResourcePackService iResourcePackService) {
        this.resourcePackService = iResourcePackService;
    }
}

