/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.models;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.ActionArgumentsFactory;
import me.mrgeneralq.bloodmoon.enums.LifeCycleState;
import me.mrgeneralq.bloodmoon.models.DeathAction;
import me.mrgeneralq.bloodmoon.models.LifeCyclePhase;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class LifeCycle {
    private String lifeCycleID;
    private final List<LifeCyclePhase> phases;
    private List<DeathAction> deathActions;
    private LifeCycleState lifeCycleState = LifeCycleState.DEFAULT;
    private LivingEntity entity;

    public LifeCycle(String string, LivingEntity livingEntity) {
        this.lifeCycleID = string;
        this.entity = livingEntity;
        this.phases = new ArrayList<LifeCyclePhase>();
        this.deathActions = new ArrayList<DeathAction>();
    }

    public void addPhase(LifeCyclePhase lifeCyclePhase) {
        this.phases.add(lifeCyclePhase);
    }

    public void startCycle() {
        this.lifeCycleState = LifeCycleState.RUNNING;
    }

    public void stopCycle() {
        this.lifeCycleState = LifeCycleState.STOPPED;
    }

    public void addPhase(List<LifeCyclePhase> list) {
        this.phases.addAll(list);
    }

    public void addDeathActions(List<DeathAction> list) {
        this.deathActions.addAll(list);
    }

    public void removePhase(String string) {
        this.phases.remove(string);
    }

    public List<LifeCyclePhase> getCurrentPhase(double d, double d2) {
        return this.phases.stream().filter(lifeCyclePhase -> lifeCyclePhase.isActivePhase(d, d2)).collect(Collectors.toList());
    }

    public void update(ActionArgumentsFactory actionArgumentsFactory, double d, double d2, Entity entity, World world) {
        this.getCurrentPhase(d, d2).forEach(lifeCyclePhase -> lifeCyclePhase.execute(actionArgumentsFactory, entity, world));
    }

    public void executeDeath(ActionArgumentsFactory actionArgumentsFactory, Entity entity, World world) {
        this.deathActions.forEach(deathAction -> deathAction.execute(actionArgumentsFactory, entity, world));
    }
}

