/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.repositories;

import java.util.Map;
import java.util.Set;
import me.mrgeneralq.bloodmoon.interfaces.repositories.IScheduleRepository;
import me.mrgeneralq.bloodmoon.models.BloodmoonSchedule;
import me.mrgeneralq.bloodmoon.statics.ConfigManager;
import me.mrgeneralq.bloodmoon.statics.YamlManager;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class BloodmoonScheduleRepository
implements IScheduleRepository {
    private final Plugin plugin;
    private YamlConfiguration config;
    private final ConfigManager configManager;
    private YamlManager yaml;

    public BloodmoonScheduleRepository(Plugin plugin) {
        this.plugin = plugin;
        this.configManager = ConfigManager.getManager();
        this.config = this.configManager.getConfig("schedules");
        this.yaml = YamlManager.getYaml();
    }

    @Override
    public void addOrUpdate(BloodmoonSchedule bloodmoonSchedule) {
        this.config.set(this.getSchedulePath(bloodmoonSchedule.getWorld().getName()), bloodmoonSchedule.serialize());
        this.configManager.saveConfig(this.config, "schedules");
    }

    @Override
    public BloodmoonSchedule get(String string) {
        if (!this.yaml.exists(this.config, this.getSchedulePath(string))) {
            return null;
        }
        try {
            BloodmoonSchedule bloodmoonSchedule;
            ConfigurationSection configurationSection = this.config.getConfigurationSection(this.getSchedulePath(string));
            if (configurationSection == null) {
                Map map = (Map)this.config.get(this.getSchedulePath(string));
                bloodmoonSchedule = new BloodmoonSchedule(map);
            } else {
                Map map = configurationSection.getValues(false);
                bloodmoonSchedule = new BloodmoonSchedule(map);
            }
            World world = Bukkit.getWorld((String)string);
            bloodmoonSchedule.setWorld(world);
            return bloodmoonSchedule;
        }
        catch (Exception exception) {
            Bukkit.getLogger().warning("[bloodmoon] schedules.yml is invalid");
            return null;
        }
    }

    @Override
    public BloodmoonSchedule get(World world) {
        return this.get(world.getName());
    }

    @Override
    public void remove(World world) {
        this.config.set(String.format("schedules.%s", world.getName()), null);
        this.configManager.saveConfig(this.config, "schedules");
    }

    @Override
    public Set<String> getSectionList() {
        return this.config.getConfigurationSection("schedules").getKeys(false);
    }

    private String getSchedulePath(String string) {
        return String.format("schedules.%s", string);
    }

    @Override
    public void reloadConfig() {
        this.config = this.configManager.reloadConfig("schedules");
    }
}

