/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.repositories;

import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Scanner;
import me.mrgeneralq.bloodmoon.interfaces.repositories.IUpdateRepository;

public class UpdateRepository
implements IUpdateRepository {
    private final String resourceId;
    private String cachedUpdateVersion;
    private Date lastChecked;
    private static final int CACHE_TIMER_IN_MS = 0x6DDD00;

    public UpdateRepository(String string) {
        this.resourceId = string;
    }

    @Override
    public String getLatestVersion() {
        if (this.lastChecked != null && !this.cacheTimeOver()) {
            return this.cachedUpdateVersion;
        }
        this.lastChecked = new Date();
        try {
            this.cachedUpdateVersion = this.requestSpigotVersion();
        }
        catch (Exception exception) {
            this.cachedUpdateVersion = "0";
        }
        return this.cachedUpdateVersion;
    }

    public String requestSpigotVersion() {
        try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openStream();
             Scanner scanner = new Scanner(inputStream);){
            if (scanner.hasNext()) {
                String string = scanner.next();
                return string;
            }
        }
        return null;
    }

    private boolean cacheTimeOver() {
        double d = new Date().getTime() - this.lastChecked.getTime();
        return d > 7200000.0;
    }
}

