/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.runnables;

import java.util.Random;
import java.util.stream.Collectors;
import me.mrgeneralq.bloodmoon.enums.BloodmoonScheduleCause;
import me.mrgeneralq.bloodmoon.enums.DataModification;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonScheduleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMobService;
import me.mrgeneralq.bloodmoon.models.Bloodmoon;
import me.mrgeneralq.bloodmoon.models.BloodmoonSchedule;
import me.mrgeneralq.bloodmoon.statics.Statics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class HeartBeat
extends BukkitRunnable {
    private final IBloodmoonService bloodmoonService;
    private final IConfigService configService;
    private final IBloodmoonScheduleService bloodmoonScheduleService;
    private final IMessageService messageService;
    private final IMobService mobService;

    public HeartBeat(IBloodmoonService iBloodmoonService, IConfigService iConfigService, IBloodmoonScheduleService iBloodmoonScheduleService, IMessageService iMessageService, IMobService iMobService) {
        this.bloodmoonService = iBloodmoonService;
        this.configService = iConfigService;
        this.bloodmoonScheduleService = iBloodmoonScheduleService;
        this.messageService = iMessageService;
        this.mobService = iMobService;
    }

    public void run() {
        for (World world : Bukkit.getWorlds().stream().filter(this.configService::worldIsEnabled).collect(Collectors.toList())) {
            if (!this.configService.worldIsEnabled(world)) continue;
            this.checkBloodmoonSchedule(world);
            this.checkBloodmoonStart(world);
            this.checkBloodmoonStop(world);
            this.checkSpawns(world);
            this.checkProgressBar(world);
        }
    }

    void checkSpawns(World world) {
        if (!this.bloodmoonService.bloodmoonIsRunning(world)) {
            return;
        }
        int n = this.configService.getMinRange();
        int n2 = this.configService.getMaxRange();
        int n3 = this.configService.getMobsPerChunk();
        boolean bl = this.configService.getSpawningEnabled();
        Random random = new Random();
        if (!bl) {
            return;
        }
        for (Player player : world.getPlayers()) {
            for (int i = -1; i <= 1; i += 2) {
                for (int j = -1; j <= 1; j += 2) {
                    int n4 = random.nextInt(n2 - n) + n;
                    int n5 = random.nextInt(360);
                    double d = player.getLocation().getX() + (double)n4 * Math.cos(n5);
                    double d2 = player.getLocation().getZ() + (double)n4 * Math.sin(n5);
                    Location location = new Location(world, d, 0.0, d2);
                    location.setY((double)(world.getHighestBlockYAt(location) + 1));
                    if (location.getChunk().getEntities().length >= n3) continue;
                    EntityType[] entityTypeArray = new EntityType[]{Statics.getEntityType("ZOMBIE"), Statics.getEntityType("SKELETON"), Statics.getEntityType("CREEPER"), Statics.getEntityType("ENDERMAN"), Statics.getEntityType("SPIDER"), Statics.getEntityType("WITCH")};
                    LivingEntity livingEntity = (LivingEntity)world.spawnEntity(location, entityTypeArray[random.nextInt(entityTypeArray.length)]);
                    this.bloodmoonService.replaceMob(livingEntity, true);
                }
            }
        }
    }

    void checkBloodmoonSchedule(World world) {
        BloodmoonSchedule bloodmoonSchedule = this.bloodmoonScheduleService.getSchedule(world);
        Bloodmoon bloodmoon = this.bloodmoonService.getBloodmoon(world);
        if (world.getTime() < 6000L || world.getTime() > 6020L) {
            return;
        }
        if (!this.bloodmoonScheduleService.isScheduled(world)) {
            return;
        }
        bloodmoonSchedule.progress();
        if (bloodmoonSchedule.isToday()) {
            this.bloodmoonScheduleService.callScheduleEvent(bloodmoon, BloodmoonScheduleCause.AUTOMATIC);
            if (bloodmoonSchedule.isBroadcasting()) {
                this.messageService.broadcast(world, this.messageService.getMessageHelper(bloodmoonSchedule.getTonightMessage()).setSchedule(bloodmoonSchedule).getMessage());
            }
            return;
        }
        String string = bloodmoonSchedule.getDaysLeftMessage();
        if (bloodmoonSchedule.isBroadcasting()) {
            this.messageService.broadcast(world, this.messageService.getMessageHelper(string).setSchedule(bloodmoonSchedule).getMessage());
        }
    }

    void checkBloodmoonStart(World world) {
        if (!this.bloodmoonScheduleService.isScheduled(world)) {
            return;
        }
        BloodmoonSchedule bloodmoonSchedule = this.bloodmoonScheduleService.getSchedule(world);
        if (!this.bloodmoonService.isNight(world) || !bloodmoonSchedule.isToday()) {
            return;
        }
        Double d = new Random().nextDouble() * 100.0;
        if (d <= bloodmoonSchedule.getChance()) {
            this.bloodmoonService.startBloodmoon(world);
        }
        if (bloodmoonSchedule.isRepeating()) {
            bloodmoonSchedule.repeat();
            return;
        }
        this.bloodmoonScheduleService.removeSchedule(world, DataModification.MEMORY);
    }

    void checkBloodmoonStop(World world) {
        if (!this.bloodmoonService.bloodmoonIsRunning(world)) {
            return;
        }
        if (this.bloodmoonService.isNight(world)) {
            return;
        }
        for (Player player : world.getPlayers()) {
            if (!player.hasPermission("bloodmoon.compass")) continue;
            Statics.resetCompass(player);
        }
        this.bloodmoonService.stopBloodmoon(world);
    }

    void checkProgressBar(World world) {
        if (!this.bloodmoonService.isNight(world)) {
            return;
        }
        if (!this.bloodmoonService.bloodmoonIsRunning(world)) {
            return;
        }
        double d = Math.min(1.0 - 9.523809523809524E-5 * (double)(world.getTime() - 13000L), 1.0);
        if (!this.configService.isBossbarEnabled()) {
            return;
        }
        Bloodmoon bloodmoon = this.bloodmoonService.getBloodmoon(world);
        BossBar bossBar = bloodmoon.getBossbar();
        bossBar.setProgress(d);
        bossBar.setTitle(this.configService.getBossbarTitle());
        for (Player player : world.getPlayers()) {
            Random random;
            double d2;
            if (this.configService.darkerNightsEnabled() && (d2 = (random = new Random()).nextDouble() * 100.0) <= this.configService.darkerNightsPercentage()) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)"BLINDNESS"), this.configService.darkerNightsDuration() * 20, 1));
            }
            if (!this.configService.compassEnabled() || !player.hasPermission("bloodmoon.compass") || (random = this.mobService.getNearbyBoss(player)) == null) continue;
            player.setCompassTarget(random.getLocation());
        }
    }
}

