/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.services;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.mrgeneralq.bloodmoon.BloodmoonCore;
import me.mrgeneralq.bloodmoon.commands.subcommands.ActionSubCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.ButcherSubCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.CancelSubCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.ItemSubCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.LifeCycleSubCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.MobSubCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.NextSubCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.ReloadSubCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.SaySubCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.ScheduleSubCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.StartSubCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.StopSubCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.VersionSubCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.action.ActionList;
import me.mrgeneralq.bloodmoon.commands.subcommands.action.AddActionEvent;
import me.mrgeneralq.bloodmoon.commands.subcommands.action.AddCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.action.CreateAction;
import me.mrgeneralq.bloodmoon.commands.subcommands.action.ListActionCommands;
import me.mrgeneralq.bloodmoon.commands.subcommands.action.ListActionEvents;
import me.mrgeneralq.bloodmoon.commands.subcommands.action.RemoveAction;
import me.mrgeneralq.bloodmoon.commands.subcommands.action.RemoveActionCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.action.RemoveActionEvent;
import me.mrgeneralq.bloodmoon.commands.subcommands.item.GetItem;
import me.mrgeneralq.bloodmoon.commands.subcommands.item.GiveItem;
import me.mrgeneralq.bloodmoon.commands.subcommands.item.ItemList;
import me.mrgeneralq.bloodmoon.commands.subcommands.item.PrintItem;
import me.mrgeneralq.bloodmoon.commands.subcommands.item.RemoveItem;
import me.mrgeneralq.bloodmoon.commands.subcommands.item.SetItem;
import me.mrgeneralq.bloodmoon.commands.subcommands.lifecycle.AddLifeCycleAction;
import me.mrgeneralq.bloodmoon.commands.subcommands.lifecycle.CreateLifeCycle;
import me.mrgeneralq.bloodmoon.commands.subcommands.lifecycle.LifecycleList;
import me.mrgeneralq.bloodmoon.commands.subcommands.lifecycle.ListCycleAction;
import me.mrgeneralq.bloodmoon.commands.subcommands.lifecycle.RemoveLifeCycle;
import me.mrgeneralq.bloodmoon.commands.subcommands.lifecycle.RemoveLifeCycleAction;
import me.mrgeneralq.bloodmoon.commands.subcommands.mob.AddDrop;
import me.mrgeneralq.bloodmoon.commands.subcommands.mob.CreateMob;
import me.mrgeneralq.bloodmoon.commands.subcommands.mob.MobList;
import me.mrgeneralq.bloodmoon.commands.subcommands.mob.RemoveMob;
import me.mrgeneralq.bloodmoon.commands.subcommands.mob.SetPropertyMob;
import me.mrgeneralq.bloodmoon.commands.subcommands.mob.SpawnBoss;
import me.mrgeneralq.bloodmoon.commands.subcommands.mob.SpawnMob;
import me.mrgeneralq.bloodmoon.commands.subcommands.schedule.ScheduleCreateCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.schedule.ScheduleInfoCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.schedule.ScheduleListCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.schedule.ScheduleRemoveCommand;
import me.mrgeneralq.bloodmoon.commands.subcommands.schedule.ScheduleSetPropertyCommand;
import me.mrgeneralq.bloodmoon.defaults.DefaultMob;
import me.mrgeneralq.bloodmoon.enums.BloodmoonState;
import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.ITabCompleteParent;
import me.mrgeneralq.bloodmoon.interfaces.commandproperties.IMobCommandProperty;
import me.mrgeneralq.bloodmoon.interfaces.commandproperties.IScheduleCommandProperty;
import me.mrgeneralq.bloodmoon.interfaces.repositories.IBloodmoonRepository;
import me.mrgeneralq.bloodmoon.interfaces.repositories.IMobRepository;
import me.mrgeneralq.bloodmoon.interfaces.services.IActionService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonScheduleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IItemService;
import me.mrgeneralq.bloodmoon.interfaces.services.ILifeCycleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMobService;
import me.mrgeneralq.bloodmoon.interfaces.services.IUpdateService;
import me.mrgeneralq.bloodmoon.models.Bloodmoon;
import me.mrgeneralq.bloodmoon.properties.mob.AngryProperty;
import me.mrgeneralq.bloodmoon.properties.mob.BabyProperty;
import me.mrgeneralq.bloodmoon.properties.mob.BossProperty;
import me.mrgeneralq.bloodmoon.properties.mob.DamageProperty;
import me.mrgeneralq.bloodmoon.properties.mob.ExplosionRadiusProperty;
import me.mrgeneralq.bloodmoon.properties.mob.GlowingProperty;
import me.mrgeneralq.bloodmoon.properties.mob.HealthProperty;
import me.mrgeneralq.bloodmoon.properties.mob.LifeCycleProperty;
import me.mrgeneralq.bloodmoon.properties.mob.MythicProperty;
import me.mrgeneralq.bloodmoon.properties.mob.NameProperty;
import me.mrgeneralq.bloodmoon.properties.mob.PoweredProperty;
import me.mrgeneralq.bloodmoon.properties.mob.SizeProperty;
import me.mrgeneralq.bloodmoon.properties.mob.SpawnChanceProperty;
import me.mrgeneralq.bloodmoon.properties.mob.SpeedProperty;
import me.mrgeneralq.bloodmoon.properties.mob.SurfaceSpawnProperty;
import me.mrgeneralq.bloodmoon.properties.mob.armor.BootsProperty;
import me.mrgeneralq.bloodmoon.properties.mob.armor.ChestplateProperty;
import me.mrgeneralq.bloodmoon.properties.mob.armor.HandProperty;
import me.mrgeneralq.bloodmoon.properties.mob.armor.HelmetProperty;
import me.mrgeneralq.bloodmoon.properties.mob.armor.LeggingsProperty;
import me.mrgeneralq.bloodmoon.properties.schedule.BroadcastScheduleProperty;
import me.mrgeneralq.bloodmoon.properties.schedule.ChanceScheduleProperty;
import me.mrgeneralq.bloodmoon.properties.schedule.DaysLeftMessageScheduleProperty;
import me.mrgeneralq.bloodmoon.properties.schedule.DaysScheduleProperty;
import me.mrgeneralq.bloodmoon.properties.schedule.RandomScheduleProperty;
import me.mrgeneralq.bloodmoon.properties.schedule.RepeatingScheduleProperty;
import me.mrgeneralq.bloodmoon.properties.schedule.TonightMessageScheduleProperty;
import me.mrgeneralq.bloodmoon.runnables.BloodmoonBellTimer;
import me.mrgeneralq.bloodmoon.statics.Tuple;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class BloodmoonService
implements IBloodmoonService,
ITabCompleteParent {
    private final IBloodmoonRepository bloodmoonRepository;
    private final BloodmoonCore bloodmoonCore;
    private final IConfigService configService;
    private final IMobService mobService;
    private final IItemService itemService;
    private final IMobRepository mobRepository;
    private final ILifeCycleService lifeCycleService;
    private final IActionService actionService;
    private final IMessageService messageService;
    private final IUpdateService updateService;
    private final IBloodmoonScheduleService scheduleService;
    private final HashMap<String, ISubCommand> subCommands = new HashMap();
    private final HashMap<String, ISubCommand> itemSubCommands = new HashMap();
    private final HashMap<String, ISubCommand> mobSubCommands = new HashMap();
    private final HashMap<String, IMobCommandProperty> mobCommmandProperties = new HashMap();
    private final HashMap<String, IScheduleCommandProperty> scheduleCommandProperties = new HashMap();
    private final HashMap<String, ISubCommand> lifeCycleSubCommands = new HashMap();
    private final HashMap<String, ISubCommand> actionSubCommands = new HashMap();
    private final HashMap<String, ISubCommand> scheduleSubCommands = new HashMap();
    private List<String> mobCommands = new ArrayList<String>();
    private List<String> lifeCycleCommands = new ArrayList<String>();
    private List<String> itemCommands = new ArrayList<String>();
    private List<String> actionCommands = new ArrayList<String>();
    private List<String> bloodmoonHelpCommands = new ArrayList<String>();
    private List<String> scheduleCommands = new ArrayList<String>();

    public BloodmoonService(IBloodmoonRepository iBloodmoonRepository, IConfigService iConfigService, BloodmoonCore bloodmoonCore, IMobService iMobService, IItemService iItemService, IMobRepository iMobRepository, ILifeCycleService iLifeCycleService, IActionService iActionService, IMessageService iMessageService, IUpdateService iUpdateService, IBloodmoonScheduleService iBloodmoonScheduleService) {
        this.bloodmoonRepository = iBloodmoonRepository;
        this.configService = iConfigService;
        this.bloodmoonCore = bloodmoonCore;
        this.mobService = iMobService;
        this.itemService = iItemService;
        this.mobRepository = iMobRepository;
        this.lifeCycleService = iLifeCycleService;
        this.actionService = iActionService;
        this.messageService = iMessageService;
        this.updateService = iUpdateService;
        this.scheduleService = iBloodmoonScheduleService;
        this.bloodmoonHelpCommands.add("start");
        this.bloodmoonHelpCommands.add("stop");
        this.bloodmoonHelpCommands.add("cancel");
        this.bloodmoonHelpCommands.add("schedule");
        this.bloodmoonHelpCommands.add("item");
        this.bloodmoonHelpCommands.add("mob");
        this.bloodmoonHelpCommands.add("lifecycle");
        this.bloodmoonHelpCommands.add("action");
        this.bloodmoonHelpCommands.add("say");
        this.bloodmoonHelpCommands.add("reload");
        this.bloodmoonHelpCommands.add("butcher");
        this.bloodmoonHelpCommands.add("version");
        this.bloodmoonHelpCommands.add("next");
        this.subCommands.put("start", new StartSubCommand(this, iMessageService, iConfigService));
        this.subCommands.put("stop", new StopSubCommand(this, iMessageService));
        this.subCommands.put("cancel", new CancelSubCommand(this, iMessageService, iBloodmoonScheduleService));
        this.subCommands.put("schedule", new ScheduleSubCommand(this, iMessageService, iBloodmoonScheduleService, iConfigService));
        this.subCommands.put("reload", new ReloadSubCommand(this.configService, iMobService, iItemService, iActionService, iLifeCycleService, iMessageService, iBloodmoonScheduleService));
        this.subCommands.put("item", new ItemSubCommand(this, iMessageService));
        this.subCommands.put("mob", new MobSubCommand(this, iMessageService));
        this.subCommands.put("lifecycle", new LifeCycleSubCommand(this, iMessageService));
        this.subCommands.put("action", new ActionSubCommand(this, iMessageService));
        this.subCommands.put("say", new SaySubCommand(iMessageService));
        this.subCommands.put("butcher", new ButcherSubCommand(iMessageService, this));
        this.subCommands.put("version", new VersionSubCommand(iUpdateService, iMessageService));
        this.subCommands.put("next", new NextSubCommand(this, iMessageService, iBloodmoonScheduleService, iConfigService));
        this.itemSubCommands.put("get", new GetItem(this.itemService, iMessageService, iConfigService));
        this.itemSubCommands.put("set", new SetItem(this.itemService, iMessageService));
        this.itemSubCommands.put("print", new PrintItem(this.itemService, iMessageService));
        this.itemSubCommands.put("remove", new RemoveItem(this.itemService, iMessageService));
        this.itemSubCommands.put("give", new GiveItem(this.itemService, iMessageService, iConfigService));
        this.itemSubCommands.put("list", new ItemList(this.itemService, iMessageService));
        this.mobSubCommands.put("create", new CreateMob(this.mobService, iMessageService));
        this.mobSubCommands.put("spawn", new SpawnMob(this.mobService, iMessageService, this));
        this.mobSubCommands.put("spawn-boss", new SpawnBoss(this.mobService, iMessageService, this));
        this.mobSubCommands.put("set", new SetPropertyMob(iMobService, this, iMessageService));
        this.mobSubCommands.put("remove", new RemoveMob(this.mobService, iMessageService));
        this.mobSubCommands.put("add-drop", new AddDrop(this.mobService, this.itemService, iMessageService));
        this.mobSubCommands.put("list", new MobList(this.mobService, iMessageService));
        this.actionSubCommands.put("create", new CreateAction(this.actionService, iMessageService));
        this.actionSubCommands.put("remove", new RemoveAction(this.actionService, this.messageService));
        this.actionSubCommands.put("add-event", new AddActionEvent(this.actionService, this.messageService));
        this.actionSubCommands.put("add-command", new AddCommand(this.actionService, this.messageService));
        this.actionSubCommands.put("events", new ListActionEvents(this.actionService, this.messageService));
        this.actionSubCommands.put("remove-event", new RemoveActionEvent(this.actionService, iMessageService));
        this.actionSubCommands.put("remove-command", new RemoveActionCommand(this.actionService, this.messageService));
        this.actionSubCommands.put("commands", new ListActionCommands(this.actionService, this.messageService));
        this.actionSubCommands.put("list", new ActionList(this.actionService, iMessageService));
        this.actionCommands.add("action create <action>");
        this.actionCommands.add("action remove <action>");
        this.actionCommands.add("action add-event <action> <chance> <event> [arguments]");
        this.actionCommands.add("action remove-event <action> <index>");
        this.actionCommands.add("action add-command <action> <chance> <command>");
        this.actionCommands.add("action remove-command <action> <index>");
        this.actionCommands.add("action events <action>");
        this.actionCommands.add("action commands <action>");
        this.actionCommands.add("action list");
        this.mobCommmandProperties.put("health", new HealthProperty());
        this.mobCommmandProperties.put("speed", new SpeedProperty());
        this.mobCommmandProperties.put("damage", new DamageProperty());
        this.mobCommmandProperties.put("name", new NameProperty());
        this.mobCommmandProperties.put("spawnchance", new SpawnChanceProperty());
        this.mobCommmandProperties.put("explosionradius", new ExplosionRadiusProperty());
        this.mobCommmandProperties.put("size", new SizeProperty());
        this.mobCommmandProperties.put("baby", new BabyProperty());
        this.mobCommmandProperties.put("glowing", new GlowingProperty());
        this.mobCommmandProperties.put("powered", new PoweredProperty());
        this.mobCommmandProperties.put("angry", new AngryProperty());
        this.mobCommmandProperties.put("lifecycle", new LifeCycleProperty(this.lifeCycleService));
        this.mobCommmandProperties.put("helmet", new HelmetProperty(this.itemService));
        this.mobCommmandProperties.put("chestplate", new ChestplateProperty(this.itemService));
        this.mobCommmandProperties.put("leggins", new LeggingsProperty(this.itemService));
        this.mobCommmandProperties.put("boots", new BootsProperty(this.itemService));
        this.mobCommmandProperties.put("hand", new HandProperty(this.itemService));
        this.mobCommmandProperties.put("boss", new BossProperty());
        this.mobCommmandProperties.put("surface-spawn", new SurfaceSpawnProperty());
        this.mobCommmandProperties.put("mythicmob", new MythicProperty());
        this.lifeCycleSubCommands.put("create", new CreateLifeCycle(this.lifeCycleService, iMessageService));
        this.lifeCycleSubCommands.put("remove", new RemoveLifeCycle(this.lifeCycleService, iMessageService));
        this.lifeCycleSubCommands.put("add-action", new AddLifeCycleAction(this.lifeCycleService, this.actionService, this.messageService));
        this.lifeCycleSubCommands.put("remove-action", new RemoveLifeCycleAction(this.lifeCycleService, this.messageService));
        this.lifeCycleSubCommands.put("actions", new ListCycleAction(this.lifeCycleService, this.messageService));
        this.lifeCycleSubCommands.put("list", new LifecycleList(this.lifeCycleService, iMessageService));
        this.mobCommands.add("mob create <mob> <entity type>");
        this.mobCommands.add("mob remove <mob>");
        this.mobCommands.add("mob spawn <mob>");
        this.mobCommands.add("mob set <mob> <property> <value>");
        this.mobCommands.add("mob add-drop <mob> <item> <amount> <chance>");
        this.mobCommands.add("mob list");
        this.lifeCycleCommands.add("lifecycle create <cycle>");
        this.lifeCycleCommands.add("lifecycle remove <cycle>");
        this.lifeCycleCommands.add("lifecycle remove-action <cycle> <action>");
        this.lifeCycleCommands.add("lifecycle add-action <cycle> <action> <start> <end> <chance> <usages>");
        this.lifeCycleCommands.add("lifecycle actions <cycle>");
        this.lifeCycleCommands.add("lifecycle list");
        this.itemCommands.add("item set <itemname>");
        this.itemCommands.add("item get <item>");
        this.itemCommands.add("item print");
        this.itemCommands.add("item remove <item>");
        this.itemCommands.add("item give <item> <playername>");
        this.itemCommands.add("item list");
        this.scheduleCommands.add("schedule create [world]");
        this.scheduleCommands.add("schedule remove [world]");
        this.scheduleCommands.add("schedule info [world]");
        this.scheduleCommands.add("schedule set <property> <world> <property value>");
        this.scheduleCommands.add("schedule list");
        this.scheduleSubCommands.put("create", new ScheduleCreateCommand(this.scheduleService, iMessageService, iConfigService));
        this.scheduleSubCommands.put("remove", new ScheduleRemoveCommand(this.scheduleService, iMessageService, iConfigService));
        this.scheduleSubCommands.put("list", new ScheduleListCommand(this.scheduleService, iMessageService));
        this.scheduleSubCommands.put("set", new ScheduleSetPropertyCommand(this.scheduleService, this, iMessageService));
        this.scheduleSubCommands.put("info", new ScheduleInfoCommand(this.scheduleService, iMessageService, iConfigService));
        this.scheduleCommandProperties.put("random", new RandomScheduleProperty());
        this.scheduleCommandProperties.put("broadcast", new BroadcastScheduleProperty());
        this.scheduleCommandProperties.put("repeating", new RepeatingScheduleProperty());
        this.scheduleCommandProperties.put("chance", new ChanceScheduleProperty());
        this.scheduleCommandProperties.put("days", new DaysScheduleProperty());
        this.scheduleCommandProperties.put("days-left-msg", new DaysLeftMessageScheduleProperty());
        this.scheduleCommandProperties.put("tonight-msg", new TonightMessageScheduleProperty());
    }

    @Override
    public void startBloodmoon(World world) {
        if (this.configService.longerNightsEnabled()) {
            world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
        }
        Bloodmoon bloodmoon = this.getBloodmoon(world);
        bloodmoon.start();
    }

    @Override
    public boolean bloodmoonIsRunning(World world) {
        if (!this.bloodmoonRepository.exists(world.getUID())) {
            return false;
        }
        Bloodmoon bloodmoon = (Bloodmoon)this.bloodmoonRepository.get(world.getUID());
        return bloodmoon.getState() == BloodmoonState.RUNNING;
    }

    @Override
    public Bloodmoon getBloodmoon(World world) {
        Bloodmoon bloodmoon = (Bloodmoon)this.bloodmoonRepository.get(world.getUID());
        if (bloodmoon == null) {
            BossBar bossBar = Bukkit.createBossBar((String)this.configService.getBossbarTitle(), (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            bossBar.setVisible(false);
            if (this.configService.bossBarFogEnabled()) {
                bossBar.addFlag(BarFlag.CREATE_FOG);
            }
            if (this.configService.isBossbarDarkEnabled()) {
                bossBar.addFlag(BarFlag.DARKEN_SKY);
            }
            bloodmoon = new Bloodmoon(world, bossBar);
            this.addBloodmoon(bloodmoon);
        }
        return bloodmoon;
    }

    @Override
    public List<World> getRunningWorlds() {
        return this.bloodmoonRepository.getAll().stream().filter(bloodmoon -> bloodmoon.getState() == BloodmoonState.RUNNING).map(Bloodmoon::getWorld).collect(Collectors.toList());
    }

    @Override
    public List<Bloodmoon> getAllBloodmoons() {
        return this.bloodmoonRepository.getAll();
    }

    @Override
    public boolean isNight(World world) {
        return world.getTime() >= (long)this.configService.getStartNightTime() && world.getTime() < (long)this.configService.getEndNightTime();
    }

    @Override
    public void spawnMob(World world) {
    }

    @Override
    public void spawnMobNearPlayer(Player player) {
    }

    @Override
    public void registerMob(LivingEntity livingEntity, World world) {
        Bloodmoon bloodmoon = (Bloodmoon)this.bloodmoonRepository.get(world.getUID());
        bloodmoon.getRegisteredMobs().put(livingEntity.getUniqueId(), livingEntity);
        this.bloodmoonRepository.addOrUpdate(bloodmoon);
    }

    @Override
    public void replaceMob(LivingEntity livingEntity, boolean bl) {
        Location location = livingEntity.getLocation();
        List list = this.mobService.getAllMobs().stream().filter(defaultMob -> !defaultMob.isBoss()).collect(Collectors.toList());
        if (list.size() <= 0) {
            return;
        }
        DefaultMob defaultMob2 = (DefaultMob)list.get(new Random().nextInt(list.size()));
        if (defaultMob2.getType() == null) {
            return;
        }
        double d = new Random().nextDouble() * 100.0;
        if (d <= defaultMob2.getPercentage()) {
            Location location2 = defaultMob2.isSpawnOnSurface() ? new Location(location.getWorld(), location.getX(), (double)location.getWorld().getHighestBlockYAt(location), location.getZ()) : location;
            LivingEntity livingEntity2 = this.mobService.spawnMob(location2, defaultMob2);
            this.registerMob(livingEntity2, livingEntity.getWorld());
            livingEntity.remove();
        } else if (bl) {
            this.registerMob(livingEntity, livingEntity.getWorld());
        }
    }

    @Override
    public void replaceMob(LivingEntity livingEntity) {
        this.replaceMob(livingEntity, false);
    }

    @Override
    public void increaseMonsterSpawnRatio(World world) {
    }

    @Override
    public void resetMonsterSpawnRatio(World world) {
        world.setMonsterSpawnLimit(-1);
    }

    @Override
    public void setDifficulty(World world, Difficulty difficulty) {
        Bloodmoon bloodmoon = (Bloodmoon)this.bloodmoonRepository.get(world.getUID());
        bloodmoon.setDifficulty(difficulty);
    }

    @Override
    public void resetDifficulty(World world) {
        Bloodmoon bloodmoon = (Bloodmoon)this.bloodmoonRepository.get(world.getUID());
        bloodmoon.resetDifficulty();
    }

    @Override
    public void runBell(World world, int n) {
        BukkitTask bukkitTask = new BloodmoonBellTimer(this.configService, world, n).runTaskTimer((Plugin)this.bloodmoonCore, 20L, 40L);
    }

    @Override
    public void addBloodmoon(Bloodmoon bloodmoon) {
        this.bloodmoonRepository.addOrUpdate(bloodmoon);
    }

    @Override
    public List<String> getBloodmoonHelpCommands() {
        return this.bloodmoonHelpCommands;
    }

    @Override
    public HashMap<String, ISubCommand> getSubCommands() {
        return this.subCommands;
    }

    @Override
    public HashMap<String, ISubCommand> getItemSubCommands() {
        return this.itemSubCommands;
    }

    @Override
    public HashMap<String, ISubCommand> getMobSubCommands() {
        return this.mobSubCommands;
    }

    @Override
    public HashMap<String, ISubCommand> getScheduleSubCommands() {
        return this.scheduleSubCommands;
    }

    @Override
    public HashMap<String, ISubCommand> getLifeCycleSubCommands() {
        return this.lifeCycleSubCommands;
    }

    @Override
    public HashMap<String, ISubCommand> getActionSubCommands() {
        return this.actionSubCommands;
    }

    @Override
    public HashMap<String, IMobCommandProperty> getMobCommandProperties() {
        return this.mobCommmandProperties;
    }

    @Override
    public HashMap<String, IScheduleCommandProperty> getScheduleCommandProperties() {
        return this.scheduleCommandProperties;
    }

    @Override
    public List<String> getMobCommands() {
        return this.mobCommands;
    }

    @Override
    public List<String> getLifeCycleCommands() {
        return this.lifeCycleCommands;
    }

    @Override
    public List<String> getItemCommands() {
        return this.itemCommands;
    }

    @Override
    public void stopBloodmoon(World world) {
        boolean bl;
        if (!this.bloodmoonIsRunning(world)) {
            return;
        }
        if (this.configService.longerNightsEnabled()) {
            world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)true);
        }
        Bloodmoon bloodmoon = (Bloodmoon)this.bloodmoonRepository.get(world.getUID());
        this.mobService.resetLifeCycles();
        this.mobService.resetPathDelays();
        this.bloodmoonRepository.resetActiveShields();
        Sound sound = null;
        Particle particle = null;
        boolean bl2 = this.configService.isPlayDespawnSound();
        if (bl2) {
            sound = this.configService.getDespawnSound();
        }
        if (bl = this.configService.isPlayDespawnParticle()) {
            particle = this.configService.getDespawnParticle();
        }
        bloodmoon.removeMobs(bl2, sound, bl, particle);
        bloodmoon.stop();
    }

    @Override
    public Set<String> get() {
        return this.getMobCommandProperties().keySet();
    }

    @Override
    public List<String> getActionCommands() {
        return this.actionCommands;
    }

    @Override
    public void addActiveShield(UUID uUID) {
        this.bloodmoonRepository.addActiveShield(uUID);
    }

    @Override
    public HashMap<UUID, Date> getActiveShields() {
        return this.bloodmoonRepository.getActiveShields();
    }

    @Override
    public Tuple<UUID, Date> getActiveShield(UUID uUID) {
        return this.bloodmoonRepository.getActiveShield(uUID);
    }

    @Override
    public void checkActiveShield(UUID uUID, int n) {
        this.bloodmoonRepository.checkActiveShield(uUID, n);
    }

    @Override
    public void loadMemory() {
        for (World world : Bukkit.getWorlds()) {
            Bloodmoon bloodmoon = this.getBloodmoon(world);
            this.addBloodmoon(bloodmoon);
        }
    }

    @Override
    public List<String> getScheduleCommands() {
        return this.scheduleCommands;
    }

    @Override
    public double getProgressNumber(World world) {
        return 1.0 - 9.523809523809524E-5 * (double)(world.getTime() - 13000L);
    }

    @Override
    public void registerPlayersForBossBar(World world) {
        Bloodmoon bloodmoon = this.getBloodmoon(world);
        BossBar bossBar = bloodmoon.getBossbar();
        bossBar.removeAll();
        for (Player player : world.getPlayers()) {
            bossBar.addPlayer(player);
        }
    }
}

