/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.services;

import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.utils.serialize.Position;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.mrgeneralq.bloodmoon.defaults.DefaultItem;
import me.mrgeneralq.bloodmoon.defaults.DefaultLifecycle;
import me.mrgeneralq.bloodmoon.defaults.DefaultMob;
import me.mrgeneralq.bloodmoon.defaults.MobMetadata;
import me.mrgeneralq.bloodmoon.interfaces.ITabCompleteParent;
import me.mrgeneralq.bloodmoon.interfaces.repositories.IMobRepository;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IItemService;
import me.mrgeneralq.bloodmoon.interfaces.services.ILifeCycleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMobService;
import me.mrgeneralq.bloodmoon.models.DeathAction;
import me.mrgeneralq.bloodmoon.models.LifeCycle;
import me.mrgeneralq.bloodmoon.models.LifeCyclePhase;
import me.mrgeneralq.bloodmoon.statics.Message;
import me.mrgeneralq.bloodmoon.statics.Statics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class MobService
implements IMobService,
ITabCompleteParent {
    private final IMobRepository mobRepository;
    private final IItemService itemService;
    private final ILifeCycleService lifeCycleService;
    private final IConfigService configService;

    public MobService(IMobRepository iMobRepository, IItemService iItemService, ILifeCycleService iLifeCycleService, IConfigService iConfigService, IBloodmoonService iBloodmoonService) {
        this.mobRepository = iMobRepository;
        this.itemService = iItemService;
        this.lifeCycleService = iLifeCycleService;
        this.configService = iConfigService;
    }

    @Override
    public DefaultMob getMob(String string) {
        return this.mobRepository.get(string);
    }

    @Override
    public void createMob(String string, EntityType entityType) {
        DefaultMob defaultMob = new DefaultMob(string, entityType);
        this.mobRepository.addOrUpdate(defaultMob);
    }

    @Override
    public void updateMob(DefaultMob defaultMob) {
        this.mobRepository.addOrUpdate(defaultMob);
    }

    @Override
    public void removeMob(String string) {
        this.mobRepository.remove(string);
    }

    @Override
    public LivingEntity spawnMob(Location location, DefaultMob defaultMob) {
        boolean bl;
        boolean bl2 = bl = this.configService.getBossChance() >= new Random().nextDouble() * 100.0 && this.configService.bossEnabled() && !this.mobRepository.getBossUsed();
        if (bl) {
            this.mobRepository.bossUsed(true);
            List list = this.getAllMobs().stream().filter(DefaultMob::isBoss).collect(Collectors.toList());
            if (list.size() == 0) {
                return this.spawnMob(location, defaultMob, false);
            }
            DefaultMob defaultMob2 = (DefaultMob)list.get(new Random().nextInt(list.size()));
            return this.spawnMob(location, defaultMob2, true);
        }
        return this.spawnMob(location, defaultMob, false);
    }

    private void setMobMetaData(LivingEntity livingEntity, DefaultMob defaultMob, boolean bl, String string) {
        DefaultLifecycle defaultLifecycle;
        livingEntity.setMetadata("mobID", (MetadataValue)new MobMetadata(defaultMob.getMobID(), this.mobRepository.getPlugin(), bl));
        if (bl) {
            livingEntity.setRemoveWhenFarAway(false);
        }
        if ((defaultLifecycle = this.lifeCycleService.getCycle(string)) != null) {
            LifeCycle lifeCycle = new LifeCycle(string, livingEntity);
            List<LifeCyclePhase> list = defaultLifecycle.getConvertedLifecycle().stream().map(LifeCyclePhase::new).collect(Collectors.toList());
            lifeCycle.addPhase(list);
            List<DeathAction> list2 = defaultLifecycle.getConvertedDeathActions().stream().map(DeathAction::new).collect(Collectors.toList());
            lifeCycle.addDeathActions(list2);
            this.mobRepository.addLifecycle(livingEntity.getUniqueId(), lifeCycle);
        }
    }

    @Override
    public LivingEntity spawnMob(Location location, DefaultMob defaultMob, boolean bl) {
        ItemStack itemStack;
        if (defaultMob.getType() == null) {
            Bukkit.getLogger().warning(String.format("%s does't have a valid type. Is this a mob from a newer version?", defaultMob.getMobID()));
            return null;
        }
        String string = defaultMob.getLifecycleID();
        double d = defaultMob.getHealth();
        double d2 = defaultMob.getDamage();
        double d3 = defaultMob.getSpeed();
        String string2 = defaultMob.getName();
        if (Bukkit.getPluginManager().isPluginEnabled("MythicMobs") && defaultMob.getMythicMob() != null) {
            Position position = Position.of((Location)location);
            AbstractLocation abstractLocation = new AbstractLocation(position);
            Optional optional = MythicProvider.get().getMobManager().getMythicMob(defaultMob.getMythicMob());
            if (optional.isPresent()) {
                ActiveMob activeMob = ((MythicMob)optional.get()).spawn(abstractLocation, 0.0);
                LivingEntity livingEntity = (LivingEntity)activeMob.getEntity().getBukkitEntity();
                this.setMobMetaData(livingEntity, defaultMob, bl, string);
                return livingEntity;
            }
            return null;
        }
        LivingEntity livingEntity = (LivingEntity)location.getWorld().spawnEntity(location, defaultMob.getType());
        this.setMobMetaData(livingEntity, defaultMob, bl, string);
        String string3 = defaultMob.getItems().get("hand");
        String string4 = defaultMob.getItems().get("helmet");
        String string5 = defaultMob.getItems().get("chestplate");
        String string6 = defaultMob.getItems().get("leggings");
        String string7 = defaultMob.getItems().get("boots");
        float f = (float)defaultMob.getItemDropChange();
        if (string3 != null && (itemStack = this.getItem(string3)) != null) {
            Objects.requireNonNull(livingEntity.getEquipment()).setItemInMainHand(itemStack);
            livingEntity.getEquipment().setItemInMainHandDropChance(f);
        }
        if (string4 != null && (itemStack = this.getItem(string4)) != null) {
            Objects.requireNonNull(livingEntity.getEquipment()).setHelmet(itemStack);
            livingEntity.getEquipment().setHelmetDropChance(f);
        }
        if (string5 != null && (itemStack = this.getItem(string5)) != null) {
            Objects.requireNonNull(livingEntity.getEquipment()).setChestplate(itemStack);
            livingEntity.getEquipment().setChestplateDropChance(f);
        }
        if (string6 != null && (itemStack = this.getItem(string6)) != null) {
            Objects.requireNonNull(livingEntity.getEquipment()).setLeggings(itemStack);
            livingEntity.getEquipment().setLeggingsDropChance(f);
        }
        if (string7 != null && (itemStack = this.getItem(string7)) != null) {
            Objects.requireNonNull(livingEntity.getEquipment()).setBoots(itemStack);
            livingEntity.getEquipment().setBootsDropChance(f);
        }
        try {
            Objects.requireNonNull(livingEntity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED)).setBaseValue(d3);
            Objects.requireNonNull(livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH)).setBaseValue(d);
            Objects.requireNonNull(livingEntity.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE)).setBaseValue(d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        livingEntity.setCustomName(Message.getMessage(string2));
        livingEntity.setHealth(d);
        livingEntity.setGlowing(defaultMob.isGlowing());
        if (defaultMob.getType() == Statics.getEntityType("ZOMBIE")) {
            itemStack = (Zombie)livingEntity;
            itemStack.setBaby(defaultMob.isBaby());
        }
        if (livingEntity instanceof Slime) {
            itemStack = (Slime)livingEntity;
            itemStack.setSize(defaultMob.getSize());
        }
        if (defaultMob.getType() == Statics.getEntityType("CREEPER")) {
            itemStack = (Creeper)livingEntity;
            try {
                itemStack.setExplosionRadius(defaultMob.getExplosionRadius());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            itemStack.setPowered(defaultMob.isPowered());
        }
        if (defaultMob.getType() == Statics.getEntityType("WOLF")) {
            itemStack = (Wolf)livingEntity;
            itemStack.setAngry(defaultMob.isAngry());
            if (defaultMob.isBaby()) {
                itemStack.setBaby();
            }
        }
        if (defaultMob.getType() == Statics.getEntityType("PIG_ZOMBIE")) {
            itemStack = (PigZombie)livingEntity;
            itemStack.setAngry(defaultMob.isAngry());
        }
        return livingEntity;
    }

    @Override
    public LivingEntity spawnMob(Location location, EntityType entityType) {
        return (LivingEntity)Objects.requireNonNull(location.getWorld()).spawnEntity(location, entityType);
    }

    private ItemStack getItem(String string) {
        DefaultItem defaultItem = this.itemService.getItem(string);
        if (defaultItem == null) {
            Bukkit.getLogger().warning(Message.getMessage(String.format("Item '%s' does not exists.", string)));
            return null;
        }
        return defaultItem.getItem();
    }

    @Override
    public HashMap<ItemStack, Double> getDrops(String string) {
        DefaultMob defaultMob = this.mobRepository.get(string);
        HashMap<ItemStack, Double> hashMap = new HashMap<ItemStack, Double>();
        if (defaultMob == null) {
            return null;
        }
        for (String string2 : defaultMob.getDrops()) {
            Object[] objectArray = this.convertToStackPercentage(string2);
            if (objectArray == null) continue;
            hashMap.put((ItemStack)objectArray[0], (Double)objectArray[1]);
        }
        return hashMap;
    }

    private Object[] convertToStackPercentage(String string) {
        double d;
        int n;
        ItemStack itemStack;
        String[] stringArray = string.split(" ");
        DefaultItem defaultItem = this.itemService.getItem(stringArray[0]);
        if (defaultItem == null && !stringArray[0].equalsIgnoreCase(Statics.PATH_FINDER_NAME)) {
            return null;
        }
        Material material = Material.matchMaterial((String)this.configService.getPathMaterial());
        if (defaultItem == null && material == null) {
            return null;
        }
        ItemStack itemStack2 = itemStack = defaultItem != null ? defaultItem.getItem() : new ItemStack(material);
        if (defaultItem == null) {
            Statics.setPathFinderMeta(itemStack);
        }
        try {
            n = Integer.parseInt(stringArray[1]);
            d = Double.parseDouble(stringArray[2]);
        }
        catch (Exception exception) {
            return null;
        }
        itemStack.setAmount(n);
        return new Object[]{itemStack, d};
    }

    @Override
    public Set<String> getAllMobIds() {
        return this.mobRepository.getSectionList("mobs");
    }

    @Override
    public List<DefaultMob> getAllMobs() {
        return this.mobRepository.getSectionList("mobs").stream().map(this::getMob).collect(Collectors.toList());
    }

    @Override
    public boolean isValidEntityType(String string) {
        try {
            if (string.equalsIgnoreCase("player")) {
                return false;
            }
            EntityType entityType = EntityType.valueOf((String)string);
            return entityType.isAlive();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public LivingEntity getNearbyBoss(Player player) {
        double d = player.getLocation().getX();
        double d2 = player.getLocation().getZ();
        player.getWorld().getEntities();
        List list = player.getWorld().getEntities().stream().filter(entity -> entity.getMetadata("mobID").size() >= 1 && ((MetadataValue)entity.getMetadata("mobID").get(0)).asBoolean()).collect(Collectors.toList());
        if (list.size() > 0) {
            List list2 = list.stream().sorted((entity, entity2) -> Statics.bigger(entity, entity2, d, d2)).collect(Collectors.toList());
            LivingEntity livingEntity = (LivingEntity)list2.get(0);
            if (player.getNearbyEntities(20.0, 20.0, 20.0).contains(livingEntity)) {
                return livingEntity;
            }
        }
        return null;
    }

    @Override
    public DefaultMob getMob(LivingEntity livingEntity) {
        List list = livingEntity.getMetadata("mobID");
        if (list.size() == 0) {
            return null;
        }
        MetadataValue metadataValue = (MetadataValue)list.get(0);
        if (!(metadataValue instanceof MobMetadata)) {
            return null;
        }
        MobMetadata mobMetadata = (MobMetadata)metadataValue;
        DefaultMob defaultMob = this.getMob(mobMetadata.getID());
        return defaultMob;
    }

    @Override
    public LifeCycle getLifeCycle(UUID uUID) {
        return this.mobRepository.getLifeCycle(uUID);
    }

    @Override
    public void resetLifeCycles() {
        this.mobRepository.resetLifeCyles();
        this.mobRepository.bossUsed(false);
    }

    @Override
    public void reloadConfig() {
        this.mobRepository.reloadConfig();
    }

    @Override
    public Set<String> get() {
        return this.getAllMobIds();
    }

    @Override
    public Plugin getPlugin() {
        return this.mobRepository.getPlugin();
    }

    @Override
    public void addPathDelay(Player player) {
        this.mobRepository.addPathDelay(player);
    }

    @Override
    public boolean canUsePath(Player player) {
        return this.mobRepository.canUsePath(player, this.configService.getPathDelay());
    }

    @Override
    public void resetPathDelays() {
        this.mobRepository.resetPathDelays();
    }
}

