/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.services;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.mrgeneralq.bloodmoon.BloodmoonCore;
import me.mrgeneralq.bloodmoon.interfaces.repositories.IUpdateRepository;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IUpdateService;

public class UpdateService
implements IUpdateService {
    private final IUpdateRepository updateRepository;
    private final BloodmoonCore main;
    private final IConfigService configService;

    public UpdateService(IUpdateRepository iUpdateRepository, BloodmoonCore bloodmoonCore, IConfigService iConfigService) {
        this.updateRepository = iUpdateRepository;
        this.main = bloodmoonCore;
        this.configService = iConfigService;
    }

    @Override
    public boolean hasUpdate() {
        return this.hasUpdate(this.getCurrentVersion());
    }

    @Override
    public boolean hasUpdate(String string) {
        if (!this.configService.isUpdateCheckerEnabled()) {
            return false;
        }
        String string2 = this.updateRepository.getLatestVersion();
        if (string2.equals(string)) {
            return false;
        }
        List<Integer> list = UpdateService.getComponents(string);
        List<Integer> list2 = UpdateService.getComponents(string2);
        UpdateService.equalizeSizes(list2, list);
        for (int i = 0; i < list2.size(); ++i) {
            Integer n = list.get(i);
            Integer n2 = list2.get(i);
            if (n2 > n) {
                return true;
            }
            if (n2 >= n) continue;
            return false;
        }
        return false;
    }

    @Override
    public String getCurrentVersion() {
        return this.main.getDescription().getVersion();
    }

    @Override
    public String getCachedUpdateVersion() {
        return this.updateRepository.getLatestVersion();
    }

    private static List<Integer> getComponents(String string) {
        return Arrays.stream(string.split("\\.")).map(Integer::parseInt).collect(Collectors.toList());
    }

    private static void equalizeSizes(List<Integer> list, List<Integer> list2) {
        int n = list.size();
        int n2 = list2.size();
        int n3 = Math.max(n, n2) - Math.min(n, n2);
        List<Integer> list3 = n < n2 ? list : list2;
        for (int i = 1; i <= n3; ++i) {
            list3.add(0);
        }
    }
}

