/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.statics;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import me.mrgeneralq.bloodmoon.BloodmoonCore;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private static ConfigManager instance;
    private HashMap<String, YamlConfiguration> configList = new HashMap();
    private BloodmoonCore bloodmoonCore;

    private ConfigManager() {
    }

    public static ConfigManager getManager() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    public static void initialize(BloodmoonCore bloodmoonCore) {
        ConfigManager.getManager().bloodmoonCore = bloodmoonCore;
    }

    public YamlConfiguration getConfig(String string) {
        if (!this.configList.containsKey(string)) {
            this.createConfig(string);
        }
        return this.configList.get(string);
    }

    public void createConfig(String string) {
        File file = new File(this.bloodmoonCore.getDataFolder(), String.format("%s.yml", string));
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            this.bloodmoonCore.saveResource(String.format("%s.yml", string), false);
        }
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        try {
            yamlConfiguration.load(file);
            if (string.toLowerCase().equalsIgnoreCase("messages")) {
                this.matchMessages(yamlConfiguration, string);
            }
            this.configList.put(string, yamlConfiguration);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            invalidConfigurationException.printStackTrace();
        }
    }

    public void saveConfig(YamlConfiguration yamlConfiguration, String string) {
        try {
            yamlConfiguration.save(this.bloodmoonCore.getDataFolder() + String.format("/%s.yml", string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public YamlConfiguration reloadConfig(String string) {
        this.configList.remove(string);
        this.createConfig(string);
        return this.getConfig(string);
    }

    private void matchMessages(YamlConfiguration yamlConfiguration, String string) {
        try {
            InputStream inputStream = this.bloodmoonCore.getResource(String.format("%s.yml", string));
            if (inputStream != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((Reader)inputStreamReader);
                for (String string2 : yamlConfiguration2.getConfigurationSection("messages").getKeys(false)) {
                    String string3 = (String)yamlConfiguration.get("messages." + string2);
                    if (string3 != null) continue;
                    yamlConfiguration.set("messages." + string2, yamlConfiguration2.get("messages." + string2));
                }
                this.saveConfig(yamlConfiguration, string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

