/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.statics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemStackSerializer {
    public static String serialize(ItemStack itemStack) {
        String string;
        Color color;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(itemStack.getType().toString());
        ItemMeta itemMeta = itemStack.getItemMeta();
        int n = 0;
        try {
            Class.forName("Damageable");
            if (itemMeta instanceof Damageable) {
                n = ((Damageable)itemMeta).getDamage();
            }
        }
        catch (Exception exception) {
            n = itemStack.getDurability();
        }
        stringBuilder.append(":").append(n);
        stringBuilder.append(" ").append(itemStack.getAmount());
        for (Object object2 : itemStack.getEnchantments().keySet()) {
            stringBuilder.append(" ").append(object2.getKey().toString().replace("minecraft:", "")).append(":").append(itemStack.getEnchantments().get(object2));
        }
        String string2 = ItemStackSerializer.getName(itemStack);
        if (string2 != null) {
            stringBuilder.append(" name:").append(string2);
        }
        if ((object2 = ItemStackSerializer.getLore(itemStack)) != null) {
            stringBuilder.append(" lore:").append((String)object2);
        }
        if ((color = ItemStackSerializer.getArmorColor(itemStack)) != null) {
            stringBuilder.append(" rgb:").append(color.getRed()).append("|").append(color.getGreen()).append("|").append(color.getBlue());
        }
        if ((string = ItemStackSerializer.getOwner(itemStack)) != null) {
            stringBuilder.append(" owner:").append(string);
        }
        return stringBuilder.toString();
    }

    public static ItemStack deserialize(String string) {
        ItemMeta itemMeta;
        String[] stringArray;
        String[] stringArray2 = string.split(" ");
        HashMap<ItemMeta, Integer> hashMap = new HashMap<ItemMeta, Integer>();
        ItemStack itemStack = new ItemStack(Material.AIR);
        for (String string2 : stringArray2) {
            stringArray = string2.split(":");
            if (Material.matchMaterial((String)stringArray[0]) == null || itemStack.getType() != Material.AIR) continue;
            itemStack.setType(Material.matchMaterial((String)stringArray[0]));
            if (stringArray.length != 2) break;
            itemMeta = itemStack.getItemMeta();
            try {
                Class.forName("Damageable");
                if (!(itemMeta instanceof Damageable)) break;
                ((Damageable)itemMeta).setDamage((int)Short.parseShort(stringArray[1]));
            }
            catch (Exception exception) {
                itemStack.setDurability(Short.parseShort(stringArray[1]));
            }
            break;
        }
        if (itemStack.getType() == Material.AIR) {
            Bukkit.getLogger().info("Could not find a valid material for the item in \"" + string + "\"");
            return null;
        }
        for (String string2 : stringArray2) {
            stringArray = string2.split(":", 2);
            if (ItemStackSerializer.isNumber(stringArray[0])) {
                itemStack.setAmount(Integer.parseInt(stringArray[0]));
            }
            if (stringArray.length == 1) continue;
            if (stringArray[0].equalsIgnoreCase("name")) {
                ItemStackSerializer.setName(itemStack, ChatColor.translateAlternateColorCodes((char)'&', (String)stringArray[1]));
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("lore")) {
                ItemStackSerializer.setLore(itemStack, ChatColor.translateAlternateColorCodes((char)'&', (String)stringArray[1]));
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("rgb")) {
                ItemStackSerializer.setArmorColor(itemStack, stringArray[1]);
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("owner")) {
                ItemStackSerializer.setOwner(itemStack, stringArray[1]);
                continue;
            }
            try {
                itemMeta = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)stringArray[0].toLowerCase()));
            }
            catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
                itemMeta = Enchantment.getByName((String)stringArray[0].toLowerCase());
            }
            if (itemMeta == null) continue;
            hashMap.put(itemMeta, Integer.parseInt(stringArray[1]));
        }
        itemStack.addUnsafeEnchantments(hashMap);
        return itemStack.getType().equals((Object)Material.AIR) ? null : itemStack;
    }

    private static String getOwner(ItemStack itemStack) {
        if (!(itemStack.getItemMeta() instanceof SkullMeta)) {
            return null;
        }
        return ((SkullMeta)itemStack.getItemMeta()).getOwningPlayer().getName();
    }

    private static void setOwner(ItemStack itemStack, String string) {
        try {
            SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
            if (skullMeta.hasOwner()) {
                skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)string));
            }
            itemStack.setItemMeta((ItemMeta)skullMeta);
        }
        catch (Exception exception) {
            return;
        }
    }

    private static String getName(ItemStack itemStack) {
        if (!itemStack.hasItemMeta()) {
            return null;
        }
        if (!itemStack.getItemMeta().hasDisplayName()) {
            return null;
        }
        return itemStack.getItemMeta().getDisplayName().replace(" ", "_").replace('\u00a7', '&');
    }

    private static void setName(ItemStack itemStack, String string) {
        string = string.replace("_", " ");
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(string);
        itemStack.setItemMeta(itemMeta);
    }

    private static String getLore(ItemStack itemStack) {
        if (!itemStack.hasItemMeta()) {
            return null;
        }
        if (!itemStack.getItemMeta().hasLore()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        List list = itemStack.getItemMeta().getLore();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append((i > 0 ? "|" : "") + ((String)list.get(i)).replace(" ", "_").replace('\u00a7', '&'));
        }
        return stringBuilder.toString();
    }

    private static void setLore(ItemStack itemStack, String string) {
        string = string.replace("_", " ");
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setLore(Arrays.asList(string.split("\\|")));
        itemStack.setItemMeta(itemMeta);
    }

    private static Color getArmorColor(ItemStack itemStack) {
        if (!(itemStack.getItemMeta() instanceof LeatherArmorMeta)) {
            return null;
        }
        return ((LeatherArmorMeta)itemStack.getItemMeta()).getColor();
    }

    private static void setArmorColor(ItemStack itemStack, String string) {
        try {
            String[] stringArray = string.split("\\|");
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            int n3 = Integer.parseInt(stringArray[2]);
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStack.getItemMeta();
            leatherArmorMeta.setColor(Color.fromRGB((int)n, (int)n2, (int)n3));
            itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
        }
        catch (Exception exception) {
            return;
        }
    }

    private static boolean isNumber(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }
}

