/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.statics;

import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.models.BloodmoonSchedule;
import me.mrgeneralq.bloodmoon.statics.Message;

public class MessageHelper {
    private String message;
    private final IMessageService messageService;

    public MessageHelper(String string, IMessageService iMessageService) {
        this.message = string;
        this.messageService = iMessageService;
    }

    public String getMessage() {
        return Message.getMessage(this.message);
    }

    public MessageHelper usePrefix() {
        this.message = this.messageService.getConfigMessage("prefix") + " " + this.message;
        return this;
    }

    public MessageHelper useConfigMessage() {
        this.message = this.messageService.getConfigMessage(this.message);
        return this;
    }

    public MessageHelper setType(String string) {
        this.message = this.message.replaceAll("%type%", string);
        return this;
    }

    public MessageHelper setWorld(String string) {
        this.message = this.message.replaceAll("%world%", string);
        return this;
    }

    public MessageHelper setPosition(String string) {
        this.message = this.message.replaceAll("%position%", string);
        return this;
    }

    public MessageHelper setArg(String string) {
        this.message = this.message.replaceAll("%arg%", string);
        return this;
    }

    public MessageHelper setSubType(String string) {
        this.message = this.message.replaceAll("%subtype%", string);
        return this;
    }

    public MessageHelper setPlayer(String string) {
        this.message = this.message.replaceAll("%player%", string);
        return this;
    }

    public MessageHelper setAmount(String string) {
        this.message = this.message.replaceAll("%amount%", string);
        return this;
    }

    public MessageHelper setArgs(String string) {
        this.message = this.message.replaceAll("%args%", string);
        return this;
    }

    public MessageHelper setDays(String string) {
        this.message = this.message.replaceAll("%days%", string);
        return this;
    }

    public MessageHelper setVersion(String string) {
        this.message = this.message.replaceAll("%version%", string);
        return this;
    }

    public MessageHelper setDaysLeft(String string) {
        this.message = this.message.replaceAll("%days-left%", string);
        return this;
    }

    public MessageHelper setChance(String string) {
        this.message = this.message.replaceAll("%chance%", string);
        return this;
    }

    public MessageHelper setTotalDays(String string) {
        this.message = this.message.replaceAll("%total-days%", string);
        return this;
    }

    public MessageHelper setSchedule(BloodmoonSchedule bloodmoonSchedule) {
        return this.setWorld(bloodmoonSchedule.getWorld().getName()).setChance(String.valueOf(bloodmoonSchedule.getChance())).setDaysLeft(String.valueOf(bloodmoonSchedule.getDaysLeft())).setTotalDays(String.valueOf(bloodmoonSchedule.getTotalDays()));
    }
}

