/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.apache.commons.lang3.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.forseth11.easybackup.dependencies.apache.commons.lang3.ArrayUtils;
import me.forseth11.easybackup.dependencies.apache.commons.lang3.ClassUtils;
import me.forseth11.easybackup.dependencies.apache.commons.lang3.builder.Builder;
import me.forseth11.easybackup.dependencies.apache.commons.lang3.builder.EqualsExclude;
import me.forseth11.easybackup.dependencies.apache.commons.lang3.builder.IDKey;
import me.forseth11.easybackup.dependencies.apache.commons.lang3.builder.ReflectionToStringBuilder;
import me.forseth11.easybackup.dependencies.apache.commons.lang3.tuple.Pair;

public class EqualsBuilder
implements Builder<Boolean> {
    private static final ThreadLocal<Set<Pair<IDKey, IDKey>>> REGISTRY = new ThreadLocal();
    private boolean isEquals = true;
    private boolean testTransients = false;
    private boolean testRecursive = false;
    private List<Class<?>> bypassReflectionClasses = new ArrayList();
    private Class<?> reflectUpToClass = null;
    private String[] excludeFields = null;

    static Set<Pair<IDKey, IDKey>> getRegistry() {
        return REGISTRY.get();
    }

    static Pair<IDKey, IDKey> getRegisterPair(Object object, Object object2) {
        IDKey iDKey = new IDKey(object);
        IDKey iDKey2 = new IDKey(object2);
        return Pair.of(iDKey, iDKey2);
    }

    static boolean isRegistered(Object object, Object object2) {
        Set<Pair<IDKey, IDKey>> set = EqualsBuilder.getRegistry();
        Pair<IDKey, IDKey> pair = EqualsBuilder.getRegisterPair(object, object2);
        Pair<IDKey, IDKey> pair2 = Pair.of(pair.getRight(), pair.getLeft());
        return set != null && (set.contains(pair) || set.contains(pair2));
    }

    private static void register(Object object, Object object2) {
        Set<Pair<IDKey, IDKey>> set = EqualsBuilder.getRegistry();
        if (set == null) {
            set = new HashSet<Pair<IDKey, IDKey>>();
            REGISTRY.set(set);
        }
        Pair<IDKey, IDKey> pair = EqualsBuilder.getRegisterPair(object, object2);
        set.add(pair);
    }

    private static void unregister(Object object, Object object2) {
        Set<Pair<IDKey, IDKey>> set = EqualsBuilder.getRegistry();
        if (set != null) {
            Pair<IDKey, IDKey> pair = EqualsBuilder.getRegisterPair(object, object2);
            set.remove(pair);
            if (set.isEmpty()) {
                REGISTRY.remove();
            }
        }
    }

    public EqualsBuilder() {
        this.bypassReflectionClasses.add(String.class);
    }

    public EqualsBuilder setTestTransients(boolean bl2) {
        this.testTransients = bl2;
        return this;
    }

    public EqualsBuilder setTestRecursive(boolean bl2) {
        this.testRecursive = bl2;
        return this;
    }

    public EqualsBuilder setBypassReflectionClasses(List<Class<?>> list) {
        this.bypassReflectionClasses = list;
        return this;
    }

    public EqualsBuilder setReflectUpToClass(Class<?> clazz) {
        this.reflectUpToClass = clazz;
        return this;
    }

    public EqualsBuilder setExcludeFields(String ... stringArray) {
        this.excludeFields = stringArray;
        return this;
    }

    public static boolean reflectionEquals(Object object, Object object2, Collection<String> collection) {
        return EqualsBuilder.reflectionEquals(object, object2, ReflectionToStringBuilder.toNoNullStringArray(collection));
    }

    public static boolean reflectionEquals(Object object, Object object2, String ... stringArray) {
        return EqualsBuilder.reflectionEquals(object, object2, false, null, stringArray);
    }

    public static boolean reflectionEquals(Object object, Object object2, boolean bl2) {
        return EqualsBuilder.reflectionEquals(object, object2, bl2, null, new String[0]);
    }

    public static boolean reflectionEquals(Object object, Object object2, boolean bl2, Class<?> clazz, String ... stringArray) {
        return EqualsBuilder.reflectionEquals(object, object2, bl2, clazz, false, stringArray);
    }

    public static boolean reflectionEquals(Object object, Object object2, boolean bl2, Class<?> clazz, boolean bl3, String ... stringArray) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return new EqualsBuilder().setExcludeFields(stringArray).setReflectUpToClass(clazz).setTestTransients(bl2).setTestRecursive(bl3).reflectionAppend(object, object2).isEquals();
    }

    public EqualsBuilder reflectionAppend(Object object, Object object2) {
        Class<?> clazz;
        if (!this.isEquals) {
            return this;
        }
        if (object == object2) {
            return this;
        }
        if (object == null || object2 == null) {
            this.isEquals = false;
            return this;
        }
        Class<?> clazz2 = object.getClass();
        Class<?> clazz3 = object2.getClass();
        if (clazz2.isInstance(object2)) {
            clazz = clazz2;
            if (!clazz3.isInstance(object)) {
                clazz = clazz3;
            }
        } else if (clazz3.isInstance(object)) {
            clazz = clazz3;
            if (!clazz2.isInstance(object2)) {
                clazz = clazz2;
            }
        } else {
            this.isEquals = false;
            return this;
        }
        try {
            if (clazz.isArray()) {
                this.append(object, object2);
            } else if (this.bypassReflectionClasses != null && (this.bypassReflectionClasses.contains(clazz2) || this.bypassReflectionClasses.contains(clazz3))) {
                this.isEquals = object.equals(object2);
            } else {
                this.reflectionAppend(object, object2, clazz);
                while (clazz.getSuperclass() != null && clazz != this.reflectUpToClass) {
                    clazz = clazz.getSuperclass();
                    this.reflectionAppend(object, object2, clazz);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals = false;
            return this;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reflectionAppend(Object object, Object object2, Class<?> clazz) {
        if (EqualsBuilder.isRegistered(object, object2)) {
            return;
        }
        try {
            EqualsBuilder.register(object, object2);
            AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(accessibleObjectArray, true);
            for (int i2 = 0; i2 < accessibleObjectArray.length && this.isEquals; ++i2) {
                AccessibleObject accessibleObject = accessibleObjectArray[i2];
                if (ArrayUtils.contains(this.excludeFields, ((Field)accessibleObject).getName()) || ((Field)accessibleObject).getName().contains("$") || !this.testTransients && Modifier.isTransient(((Field)accessibleObject).getModifiers()) || Modifier.isStatic(((Field)accessibleObject).getModifiers()) || accessibleObject.isAnnotationPresent(EqualsExclude.class)) continue;
                try {
                    this.append(((Field)accessibleObject).get(object), ((Field)accessibleObject).get(object2));
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InternalError("Unexpected IllegalAccessException");
                }
            }
        }
        finally {
            EqualsBuilder.unregister(object, object2);
        }
    }

    public EqualsBuilder appendSuper(boolean bl2) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = bl2;
        return this;
    }

    public EqualsBuilder append(Object object, Object object2) {
        if (!this.isEquals) {
            return this;
        }
        if (object == object2) {
            return this;
        }
        if (object == null || object2 == null) {
            this.setEquals(false);
            return this;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            this.appendArray(object, object2);
        } else if (this.testRecursive && !ClassUtils.isPrimitiveOrWrapper(clazz)) {
            this.reflectionAppend(object, object2);
        } else {
            this.isEquals = object.equals(object2);
        }
        return this;
    }

    private void appendArray(Object object, Object object2) {
        if (object.getClass() != object2.getClass()) {
            this.setEquals(false);
        } else if (object instanceof long[]) {
            this.append((long[])object, (long[])object2);
        } else if (object instanceof int[]) {
            this.append((int[])object, (int[])object2);
        } else if (object instanceof short[]) {
            this.append((short[])object, (short[])object2);
        } else if (object instanceof char[]) {
            this.append((char[])object, (char[])object2);
        } else if (object instanceof byte[]) {
            this.append((byte[])object, (byte[])object2);
        } else if (object instanceof double[]) {
            this.append((double[])object, (double[])object2);
        } else if (object instanceof float[]) {
            this.append((float[])object, (float[])object2);
        } else if (object instanceof boolean[]) {
            this.append((boolean[])object, (boolean[])object2);
        } else {
            this.append((Object[])object, (Object[])object2);
        }
    }

    public EqualsBuilder append(long l2, long l3) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = l2 == l3;
        return this;
    }

    public EqualsBuilder append(int n2, int n3) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = n2 == n3;
        return this;
    }

    public EqualsBuilder append(short s2, short s3) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = s2 == s3;
        return this;
    }

    public EqualsBuilder append(char c10, char c11) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = c10 == c11;
        return this;
    }

    public EqualsBuilder append(byte by2, byte by3) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = by2 == by3;
        return this;
    }

    public EqualsBuilder append(double d3, double d4) {
        if (!this.isEquals) {
            return this;
        }
        return this.append(Double.doubleToLongBits(d3), Double.doubleToLongBits(d4));
    }

    public EqualsBuilder append(float f2, float f3) {
        if (!this.isEquals) {
            return this;
        }
        return this.append(Float.floatToIntBits(f2), Float.floatToIntBits(f3));
    }

    public EqualsBuilder append(boolean bl2, boolean bl3) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = bl2 == bl3;
        return this;
    }

    public EqualsBuilder append(Object[] objectArray, Object[] objectArray2) {
        if (!this.isEquals) {
            return this;
        }
        if (objectArray == objectArray2) {
            return this;
        }
        if (objectArray == null || objectArray2 == null) {
            this.setEquals(false);
            return this;
        }
        if (objectArray.length != objectArray2.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < objectArray.length && this.isEquals; ++i2) {
            this.append(objectArray[i2], objectArray2[i2]);
        }
        return this;
    }

    public EqualsBuilder append(long[] lArray, long[] lArray2) {
        if (!this.isEquals) {
            return this;
        }
        if (lArray == lArray2) {
            return this;
        }
        if (lArray == null || lArray2 == null) {
            this.setEquals(false);
            return this;
        }
        if (lArray.length != lArray2.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < lArray.length && this.isEquals; ++i2) {
            this.append(lArray[i2], lArray2[i2]);
        }
        return this;
    }

    public EqualsBuilder append(int[] nArray, int[] nArray2) {
        if (!this.isEquals) {
            return this;
        }
        if (nArray == nArray2) {
            return this;
        }
        if (nArray == null || nArray2 == null) {
            this.setEquals(false);
            return this;
        }
        if (nArray.length != nArray2.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < nArray.length && this.isEquals; ++i2) {
            this.append(nArray[i2], nArray2[i2]);
        }
        return this;
    }

    public EqualsBuilder append(short[] sArray, short[] sArray2) {
        if (!this.isEquals) {
            return this;
        }
        if (sArray == sArray2) {
            return this;
        }
        if (sArray == null || sArray2 == null) {
            this.setEquals(false);
            return this;
        }
        if (sArray.length != sArray2.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < sArray.length && this.isEquals; ++i2) {
            this.append(sArray[i2], sArray2[i2]);
        }
        return this;
    }

    public EqualsBuilder append(char[] cArray, char[] cArray2) {
        if (!this.isEquals) {
            return this;
        }
        if (cArray == cArray2) {
            return this;
        }
        if (cArray == null || cArray2 == null) {
            this.setEquals(false);
            return this;
        }
        if (cArray.length != cArray2.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < cArray.length && this.isEquals; ++i2) {
            this.append(cArray[i2], cArray2[i2]);
        }
        return this;
    }

    public EqualsBuilder append(byte[] byArray, byte[] byArray2) {
        if (!this.isEquals) {
            return this;
        }
        if (byArray == byArray2) {
            return this;
        }
        if (byArray == null || byArray2 == null) {
            this.setEquals(false);
            return this;
        }
        if (byArray.length != byArray2.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < byArray.length && this.isEquals; ++i2) {
            this.append(byArray[i2], byArray2[i2]);
        }
        return this;
    }

    public EqualsBuilder append(double[] dArray, double[] dArray2) {
        if (!this.isEquals) {
            return this;
        }
        if (dArray == dArray2) {
            return this;
        }
        if (dArray == null || dArray2 == null) {
            this.setEquals(false);
            return this;
        }
        if (dArray.length != dArray2.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < dArray.length && this.isEquals; ++i2) {
            this.append(dArray[i2], dArray2[i2]);
        }
        return this;
    }

    public EqualsBuilder append(float[] fArray, float[] fArray2) {
        if (!this.isEquals) {
            return this;
        }
        if (fArray == fArray2) {
            return this;
        }
        if (fArray == null || fArray2 == null) {
            this.setEquals(false);
            return this;
        }
        if (fArray.length != fArray2.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < fArray.length && this.isEquals; ++i2) {
            this.append(fArray[i2], fArray2[i2]);
        }
        return this;
    }

    public EqualsBuilder append(boolean[] blArray, boolean[] blArray2) {
        if (!this.isEquals) {
            return this;
        }
        if (blArray == blArray2) {
            return this;
        }
        if (blArray == null || blArray2 == null) {
            this.setEquals(false);
            return this;
        }
        if (blArray.length != blArray2.length) {
            this.setEquals(false);
            return this;
        }
        for (int i2 = 0; i2 < blArray.length && this.isEquals; ++i2) {
            this.append(blArray[i2], blArray2[i2]);
        }
        return this;
    }

    public boolean isEquals() {
        return this.isEquals;
    }

    @Override
    public Boolean build() {
        return this.isEquals();
    }

    protected void setEquals(boolean bl2) {
        this.isEquals = bl2;
    }

    public void reset() {
        this.isEquals = true;
    }
}

