/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.apache.commons.net.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.forseth11.easybackup.dependencies.apache.commons.net.MalformedServerReplyException;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.Configurable;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTP;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPClientConfig;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPCmd;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPCommand;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPFile;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPFileEntryParser;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPFileFilter;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPFileFilters;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPListParseEngine;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPReply;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser.DefaultFTPFileEntryParserFactory;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser.MLSxEntryParser;
import me.forseth11.easybackup.dependencies.apache.commons.net.io.CRLFLineReader;
import me.forseth11.easybackup.dependencies.apache.commons.net.io.CopyStreamAdapter;
import me.forseth11.easybackup.dependencies.apache.commons.net.io.CopyStreamEvent;
import me.forseth11.easybackup.dependencies.apache.commons.net.io.CopyStreamListener;
import me.forseth11.easybackup.dependencies.apache.commons.net.io.FromNetASCIIInputStream;
import me.forseth11.easybackup.dependencies.apache.commons.net.io.SocketInputStream;
import me.forseth11.easybackup.dependencies.apache.commons.net.io.SocketOutputStream;
import me.forseth11.easybackup.dependencies.apache.commons.net.io.ToNetASCIIOutputStream;
import me.forseth11.easybackup.dependencies.apache.commons.net.io.Util;

public class FTPClient
extends FTP
implements Configurable {
    public static final String FTP_SYSTEM_TYPE = "me.forseth11.easybackup.dependencies.apache.commons.net.ftp.systemType";
    public static final String FTP_SYSTEM_TYPE_DEFAULT = "me.forseth11.easybackup.dependencies.apache.commons.net.ftp.systemType.default";
    public static final String SYSTEM_TYPE_PROPERTIES = "/systemType.properties";
    public static final int ACTIVE_LOCAL_DATA_CONNECTION_MODE = 0;
    public static final int ACTIVE_REMOTE_DATA_CONNECTION_MODE = 1;
    public static final int PASSIVE_LOCAL_DATA_CONNECTION_MODE = 2;
    public static final int PASSIVE_REMOTE_DATA_CONNECTION_MODE = 3;
    private int __dataConnectionMode;
    private int __dataTimeout;
    private int __passivePort;
    private String __passiveHost;
    private final Random __random;
    private int __activeMinPort;
    private int __activeMaxPort;
    private InetAddress __activeExternalHost;
    private InetAddress __reportActiveExternalHost;
    private InetAddress __passiveLocalHost;
    private int __fileType;
    private int __fileFormat;
    private int __fileStructure;
    private int __fileTransferMode;
    private boolean __remoteVerificationEnabled;
    private long __restartOffset;
    private FTPFileEntryParserFactory __parserFactory;
    private int __bufferSize;
    private int __sendDataSocketBufferSize;
    private int __receiveDataSocketBufferSize;
    private boolean __listHiddenFiles;
    private boolean __useEPSVwithIPv4;
    private String __systemName;
    private FTPFileEntryParser __entryParser;
    private String __entryParserKey;
    private FTPClientConfig __configuration;
    private CopyStreamListener __copyStreamListener;
    private long __controlKeepAliveTimeout;
    private int __controlKeepAliveReplyTimeout = 1000;
    private boolean __passiveNatWorkaround = true;
    private static final Pattern __PARMS_PAT = Pattern.compile("(\\d{1,3},\\d{1,3},\\d{1,3},\\d{1,3}),(\\d{1,3}),(\\d{1,3})");
    private boolean __autodetectEncoding = false;
    private HashMap<String, Set<String>> __featuresMap;

    private static Properties getOverrideProperties() {
        return PropertiesSingleton.PROPERTIES;
    }

    public FTPClient() {
        this.__initDefaults();
        this.__dataTimeout = -1;
        this.__remoteVerificationEnabled = true;
        this.__parserFactory = new DefaultFTPFileEntryParserFactory();
        this.__configuration = null;
        this.__listHiddenFiles = false;
        this.__useEPSVwithIPv4 = false;
        this.__random = new Random();
        this.__passiveLocalHost = null;
    }

    private void __initDefaults() {
        this.__dataConnectionMode = 0;
        this.__passiveHost = null;
        this.__passivePort = -1;
        this.__activeExternalHost = null;
        this.__reportActiveExternalHost = null;
        this.__activeMinPort = 0;
        this.__activeMaxPort = 0;
        this.__fileType = 0;
        this.__fileStructure = 7;
        this.__fileFormat = 4;
        this.__fileTransferMode = 10;
        this.__restartOffset = 0L;
        this.__systemName = null;
        this.__entryParser = null;
        this.__entryParserKey = "";
        this.__featuresMap = null;
    }

    static String __parsePathname(String string) {
        String string2 = string.substring(4);
        if (string2.startsWith("\"")) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = false;
            for (int i2 = 1; i2 < string2.length(); ++i2) {
                char c10 = string2.charAt(i2);
                if (c10 == '\"') {
                    if (bl2) {
                        stringBuilder.append(c10);
                        bl2 = false;
                        continue;
                    }
                    bl2 = true;
                    continue;
                }
                if (bl2) {
                    return stringBuilder.toString();
                }
                stringBuilder.append(c10);
            }
            if (bl2) {
                return stringBuilder.toString();
            }
        }
        return string2;
    }

    protected void _parsePassiveModeReply(String string) {
        Matcher matcher = __PARMS_PAT.matcher(string);
        if (!matcher.find()) {
            throw new MalformedServerReplyException("Could not parse passive host information.\nServer Reply: " + string);
        }
        this.__passiveHost = matcher.group(1).replace(',', '.');
        try {
            int n2 = Integer.parseInt(matcher.group(2));
            int n3 = Integer.parseInt(matcher.group(3));
            this.__passivePort = n2 << 8 | n3;
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedServerReplyException("Could not parse passive port information.\nServer Reply: " + string);
        }
        if (this.__passiveNatWorkaround) {
            try {
                InetAddress inetAddress;
                InetAddress inetAddress2 = InetAddress.getByName(this.__passiveHost);
                if (inetAddress2.isSiteLocalAddress() && !(inetAddress = this.getRemoteAddress()).isSiteLocalAddress()) {
                    String string2 = inetAddress.getHostAddress();
                    this.fireReplyReceived(0, "[Replacing site local address " + this.__passiveHost + " with " + string2 + "]\n");
                    this.__passiveHost = string2;
                }
            }
            catch (UnknownHostException unknownHostException) {
                throw new MalformedServerReplyException("Could not parse passive host information.\nServer Reply: " + string);
            }
        }
    }

    protected void _parseExtendedPassiveModeReply(String string) {
        int n2;
        string = string.substring(string.indexOf(40) + 1, string.indexOf(41)).trim();
        char c10 = string.charAt(0);
        char c11 = string.charAt(1);
        char c12 = string.charAt(2);
        char c13 = string.charAt(string.length() - 1);
        if (c10 != c11 || c11 != c12 || c12 != c13) {
            throw new MalformedServerReplyException("Could not parse extended passive host information.\nServer Reply: " + string);
        }
        try {
            n2 = Integer.parseInt(string.substring(3, string.length() - 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedServerReplyException("Could not parse extended passive host information.\nServer Reply: " + string);
        }
        this.__passiveHost = this.getRemoteAddress().getHostAddress();
        this.__passivePort = n2;
    }

    private boolean __storeFile(FTPCmd fTPCmd, String string, InputStream inputStream) {
        return this._storeFile(fTPCmd.getCommand(), string, inputStream);
    }

    protected boolean _storeFile(String string, String string2, InputStream inputStream) {
        Socket socket = this._openDataConnection_(string, string2);
        if (socket == null) {
            return false;
        }
        OutputStream outputStream = this.getBufferedOutputStream(socket.getOutputStream());
        if (this.__fileType == 0) {
            outputStream = new ToNetASCIIOutputStream(outputStream);
        }
        CSL cSL = null;
        if (this.__controlKeepAliveTimeout > 0L) {
            cSL = new CSL(this, this.__controlKeepAliveTimeout, this.__controlKeepAliveReplyTimeout);
        }
        try {
            Util.copyStream(inputStream, outputStream, this.getBufferSize(), -1L, this.__mergeListeners(cSL), false);
        }
        catch (IOException iOException) {
            Util.closeQuietly(socket);
            if (cSL != null) {
                cSL.cleanUp();
            }
            throw iOException;
        }
        outputStream.close();
        socket.close();
        if (cSL != null) {
            cSL.cleanUp();
        }
        boolean bl2 = this.completePendingCommand();
        return bl2;
    }

    private OutputStream __storeFileStream(FTPCmd fTPCmd, String string) {
        return this._storeFileStream(fTPCmd.getCommand(), string);
    }

    protected OutputStream _storeFileStream(String string, String string2) {
        Socket socket = this._openDataConnection_(string, string2);
        if (socket == null) {
            return null;
        }
        OutputStream outputStream = socket.getOutputStream();
        if (this.__fileType == 0) {
            outputStream = this.getBufferedOutputStream(outputStream);
            outputStream = new ToNetASCIIOutputStream(outputStream);
        }
        return new SocketOutputStream(socket, outputStream);
    }

    @Deprecated
    protected Socket _openDataConnection_(int n2, String string) {
        return this._openDataConnection_(FTPCommand.getCommand(n2), string);
    }

    protected Socket _openDataConnection_(FTPCmd fTPCmd, String string) {
        return this._openDataConnection_(fTPCmd.getCommand(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Socket _openDataConnection_(String var1_1, String var2_2) {
        if (this.__dataConnectionMode != 0 && this.__dataConnectionMode != 2) {
            return null;
        }
        var3_3 = this.getRemoteAddress() instanceof Inet6Address;
        if (this.__dataConnectionMode == 0) {
            var5_4 = this._serverSocketFactory_.createServerSocket(this.getActivePort(), 1, this.getHostAddress());
            try {
                if (var3_3) {
                    if (!FTPReply.isPositiveCompletion(this.eprt(this.getReportHostAddress(), var5_4.getLocalPort()))) {
                        var6_6 = null;
                        return var6_6;
                    }
                } else if (!FTPReply.isPositiveCompletion(this.port(this.getReportHostAddress(), var5_4.getLocalPort()))) {
                    var6_7 = null;
                    return var6_7;
                }
                if (this.__restartOffset > 0L && !this.restart(this.__restartOffset)) {
                    var6_8 = null;
                    return var6_8;
                }
                if (!FTPReply.isPositivePreliminary(this.sendCommand(var1_1, var2_2))) {
                    var6_9 = null;
                    return var6_9;
                }
                if (this.__dataTimeout >= 0) {
                    var5_4.setSoTimeout(this.__dataTimeout);
                }
                var4_10 = var5_4.accept();
                if (this.__dataTimeout >= 0) {
                    var4_10.setSoTimeout(this.__dataTimeout);
                }
                if (this.__receiveDataSocketBufferSize > 0) {
                    var4_10.setReceiveBufferSize(this.__receiveDataSocketBufferSize);
                }
                if (this.__sendDataSocketBufferSize <= 0) ** GOTO lbl59
                var4_10.setSendBufferSize(this.__sendDataSocketBufferSize);
            }
            finally {
                var5_4.close();
            }
        } else {
            v0 = var5_5 = this.isUseEPSVwithIPv4() != false || var3_3 != false;
            if (var5_5 && this.epsv() == 229) {
                this._parseExtendedPassiveModeReply((String)this._replyLines.get(0));
            } else {
                if (var3_3) {
                    return null;
                }
                if (this.pasv() != 227) {
                    return null;
                }
                this._parsePassiveModeReply((String)this._replyLines.get(0));
            }
            var4_10 = this._socketFactory_.createSocket();
            if (this.__receiveDataSocketBufferSize > 0) {
                var4_10.setReceiveBufferSize(this.__receiveDataSocketBufferSize);
            }
            if (this.__sendDataSocketBufferSize > 0) {
                var4_10.setSendBufferSize(this.__sendDataSocketBufferSize);
            }
            if (this.__passiveLocalHost != null) {
                var4_10.bind(new InetSocketAddress(this.__passiveLocalHost, 0));
            }
            if (this.__dataTimeout >= 0) {
                var4_10.setSoTimeout(this.__dataTimeout);
            }
            var4_10.connect(new InetSocketAddress(this.__passiveHost, this.__passivePort), this.connectTimeout);
            if (this.__restartOffset > 0L && !this.restart(this.__restartOffset)) {
                var4_10.close();
                return null;
            }
            if (!FTPReply.isPositivePreliminary(this.sendCommand(var1_1, var2_2))) {
                var4_10.close();
                return null;
            }
        }
lbl59:
        // 4 sources

        if (this.__remoteVerificationEnabled && !this.verifyRemote(var4_10)) {
            var4_10.close();
            throw new IOException("Host attempting data connection " + var4_10.getInetAddress().getHostAddress() + " is not same as server " + this.getRemoteAddress().getHostAddress());
        }
        return var4_10;
    }

    protected void _connectAction_() {
        super._connectAction_();
        this.__initDefaults();
        if (this.__autodetectEncoding) {
            ArrayList arrayList = new ArrayList(this._replyLines);
            int n2 = this._replyCode;
            if (this.hasFeature("UTF8") || this.hasFeature("UTF-8")) {
                this.setControlEncoding("UTF-8");
                this._controlInput_ = new CRLFLineReader(new InputStreamReader(this._input_, this.getControlEncoding()));
                this._controlOutput_ = new BufferedWriter(new OutputStreamWriter(this._output_, this.getControlEncoding()));
            }
            this._replyLines.clear();
            this._replyLines.addAll(arrayList);
            this._replyCode = n2;
        }
    }

    public void setDataTimeout(int n2) {
        this.__dataTimeout = n2;
    }

    public void setParserFactory(FTPFileEntryParserFactory fTPFileEntryParserFactory) {
        this.__parserFactory = fTPFileEntryParserFactory;
    }

    public void disconnect() {
        super.disconnect();
        this.__initDefaults();
    }

    public void setRemoteVerificationEnabled(boolean bl2) {
        this.__remoteVerificationEnabled = bl2;
    }

    public boolean isRemoteVerificationEnabled() {
        return this.__remoteVerificationEnabled;
    }

    public boolean login(String string, String string2) {
        this.user(string);
        if (FTPReply.isPositiveCompletion(this._replyCode)) {
            return true;
        }
        if (!FTPReply.isPositiveIntermediate(this._replyCode)) {
            return false;
        }
        return FTPReply.isPositiveCompletion(this.pass(string2));
    }

    public boolean login(String string, String string2, String string3) {
        this.user(string);
        if (FTPReply.isPositiveCompletion(this._replyCode)) {
            return true;
        }
        if (!FTPReply.isPositiveIntermediate(this._replyCode)) {
            return false;
        }
        this.pass(string2);
        if (FTPReply.isPositiveCompletion(this._replyCode)) {
            return true;
        }
        if (!FTPReply.isPositiveIntermediate(this._replyCode)) {
            return false;
        }
        return FTPReply.isPositiveCompletion(this.acct(string3));
    }

    public boolean logout() {
        return FTPReply.isPositiveCompletion(this.quit());
    }

    public boolean changeWorkingDirectory(String string) {
        return FTPReply.isPositiveCompletion(this.cwd(string));
    }

    public boolean changeToParentDirectory() {
        return FTPReply.isPositiveCompletion(this.cdup());
    }

    public boolean structureMount(String string) {
        return FTPReply.isPositiveCompletion(this.smnt(string));
    }

    boolean reinitialize() {
        this.rein();
        if (FTPReply.isPositiveCompletion(this._replyCode) || FTPReply.isPositivePreliminary(this._replyCode) && FTPReply.isPositiveCompletion(this.getReply())) {
            this.__initDefaults();
            return true;
        }
        return false;
    }

    public void enterLocalActiveMode() {
        this.__dataConnectionMode = 0;
        this.__passiveHost = null;
        this.__passivePort = -1;
    }

    public void enterLocalPassiveMode() {
        this.__dataConnectionMode = 2;
        this.__passiveHost = null;
        this.__passivePort = -1;
    }

    public boolean enterRemoteActiveMode(InetAddress inetAddress, int n2) {
        if (FTPReply.isPositiveCompletion(this.port(inetAddress, n2))) {
            this.__dataConnectionMode = 1;
            this.__passiveHost = null;
            this.__passivePort = -1;
            return true;
        }
        return false;
    }

    public boolean enterRemotePassiveMode() {
        if (this.pasv() != 227) {
            return false;
        }
        this.__dataConnectionMode = 3;
        this._parsePassiveModeReply((String)this._replyLines.get(0));
        return true;
    }

    public String getPassiveHost() {
        return this.__passiveHost;
    }

    public int getPassivePort() {
        return this.__passivePort;
    }

    public int getDataConnectionMode() {
        return this.__dataConnectionMode;
    }

    private int getActivePort() {
        if (this.__activeMinPort > 0 && this.__activeMaxPort >= this.__activeMinPort) {
            if (this.__activeMaxPort == this.__activeMinPort) {
                return this.__activeMaxPort;
            }
            return this.__random.nextInt(this.__activeMaxPort - this.__activeMinPort + 1) + this.__activeMinPort;
        }
        return 0;
    }

    private InetAddress getHostAddress() {
        if (this.__activeExternalHost != null) {
            return this.__activeExternalHost;
        }
        return this.getLocalAddress();
    }

    private InetAddress getReportHostAddress() {
        if (this.__reportActiveExternalHost != null) {
            return this.__reportActiveExternalHost;
        }
        return this.getHostAddress();
    }

    public void setActivePortRange(int n2, int n3) {
        this.__activeMinPort = n2;
        this.__activeMaxPort = n3;
    }

    public void setActiveExternalIPAddress(String string) {
        this.__activeExternalHost = InetAddress.getByName(string);
    }

    public void setPassiveLocalIPAddress(String string) {
        this.__passiveLocalHost = InetAddress.getByName(string);
    }

    public void setPassiveLocalIPAddress(InetAddress inetAddress) {
        this.__passiveLocalHost = inetAddress;
    }

    public InetAddress getPassiveLocalIPAddress() {
        return this.__passiveLocalHost;
    }

    public void setReportActiveExternalIPAddress(String string) {
        this.__reportActiveExternalHost = InetAddress.getByName(string);
    }

    public boolean setFileType(int n2) {
        if (FTPReply.isPositiveCompletion(this.type(n2))) {
            this.__fileType = n2;
            this.__fileFormat = 4;
            return true;
        }
        return false;
    }

    public boolean setFileType(int n2, int n3) {
        if (FTPReply.isPositiveCompletion(this.type(n2, n3))) {
            this.__fileType = n2;
            this.__fileFormat = n3;
            return true;
        }
        return false;
    }

    public boolean setFileStructure(int n2) {
        if (FTPReply.isPositiveCompletion(this.stru(n2))) {
            this.__fileStructure = n2;
            return true;
        }
        return false;
    }

    public boolean setFileTransferMode(int n2) {
        if (FTPReply.isPositiveCompletion(this.mode(n2))) {
            this.__fileTransferMode = n2;
            return true;
        }
        return false;
    }

    public boolean remoteRetrieve(String string) {
        if (this.__dataConnectionMode == 1 || this.__dataConnectionMode == 3) {
            return FTPReply.isPositivePreliminary(this.retr(string));
        }
        return false;
    }

    public boolean remoteStore(String string) {
        if (this.__dataConnectionMode == 1 || this.__dataConnectionMode == 3) {
            return FTPReply.isPositivePreliminary(this.stor(string));
        }
        return false;
    }

    public boolean remoteStoreUnique(String string) {
        if (this.__dataConnectionMode == 1 || this.__dataConnectionMode == 3) {
            return FTPReply.isPositivePreliminary(this.stou(string));
        }
        return false;
    }

    public boolean remoteStoreUnique() {
        if (this.__dataConnectionMode == 1 || this.__dataConnectionMode == 3) {
            return FTPReply.isPositivePreliminary(this.stou());
        }
        return false;
    }

    public boolean remoteAppend(String string) {
        if (this.__dataConnectionMode == 1 || this.__dataConnectionMode == 3) {
            return FTPReply.isPositivePreliminary(this.appe(string));
        }
        return false;
    }

    public boolean completePendingCommand() {
        return FTPReply.isPositiveCompletion(this.getReply());
    }

    public boolean retrieveFile(String string, OutputStream outputStream) {
        return this._retrieveFile(FTPCmd.RETR.getCommand(), string, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _retrieveFile(String string, String string2, OutputStream outputStream) {
        Socket socket = this._openDataConnection_(string, string2);
        if (socket == null) {
            return false;
        }
        InputStream inputStream = this.getBufferedInputStream(socket.getInputStream());
        if (this.__fileType == 0) {
            inputStream = new FromNetASCIIInputStream(inputStream);
        }
        CSL cSL = null;
        if (this.__controlKeepAliveTimeout > 0L) {
            cSL = new CSL(this, this.__controlKeepAliveTimeout, this.__controlKeepAliveReplyTimeout);
        }
        try {
            Util.copyStream(inputStream, outputStream, this.getBufferSize(), -1L, this.__mergeListeners(cSL), false);
        }
        finally {
            Util.closeQuietly(inputStream);
            Util.closeQuietly(socket);
            if (cSL != null) {
                cSL.cleanUp();
            }
        }
        boolean bl2 = this.completePendingCommand();
        return bl2;
    }

    public InputStream retrieveFileStream(String string) {
        return this._retrieveFileStream(FTPCmd.RETR.getCommand(), string);
    }

    protected InputStream _retrieveFileStream(String string, String string2) {
        Socket socket = this._openDataConnection_(string, string2);
        if (socket == null) {
            return null;
        }
        InputStream inputStream = socket.getInputStream();
        if (this.__fileType == 0) {
            inputStream = this.getBufferedInputStream(inputStream);
            inputStream = new FromNetASCIIInputStream(inputStream);
        }
        return new SocketInputStream(socket, inputStream);
    }

    public boolean storeFile(String string, InputStream inputStream) {
        return this.__storeFile(FTPCmd.STOR, string, inputStream);
    }

    public OutputStream storeFileStream(String string) {
        return this.__storeFileStream(FTPCmd.STOR, string);
    }

    public boolean appendFile(String string, InputStream inputStream) {
        return this.__storeFile(FTPCmd.APPE, string, inputStream);
    }

    public OutputStream appendFileStream(String string) {
        return this.__storeFileStream(FTPCmd.APPE, string);
    }

    public boolean storeUniqueFile(String string, InputStream inputStream) {
        return this.__storeFile(FTPCmd.STOU, string, inputStream);
    }

    public OutputStream storeUniqueFileStream(String string) {
        return this.__storeFileStream(FTPCmd.STOU, string);
    }

    public boolean storeUniqueFile(InputStream inputStream) {
        return this.__storeFile(FTPCmd.STOU, null, inputStream);
    }

    public OutputStream storeUniqueFileStream() {
        return this.__storeFileStream(FTPCmd.STOU, null);
    }

    public boolean allocate(int n2) {
        return FTPReply.isPositiveCompletion(this.allo(n2));
    }

    public boolean features() {
        return FTPReply.isPositiveCompletion(this.feat());
    }

    public String[] featureValues(String string) {
        if (!this.initFeatureMap()) {
            return null;
        }
        Set<String> set = this.__featuresMap.get(string.toUpperCase(Locale.ENGLISH));
        if (set != null) {
            return set.toArray(new String[set.size()]);
        }
        return null;
    }

    public String featureValue(String string) {
        String[] stringArray = this.featureValues(string);
        if (stringArray != null) {
            return stringArray[0];
        }
        return null;
    }

    public boolean hasFeature(String string) {
        if (!this.initFeatureMap()) {
            return false;
        }
        return this.__featuresMap.containsKey(string.toUpperCase(Locale.ENGLISH));
    }

    public boolean hasFeature(String string, String string2) {
        if (!this.initFeatureMap()) {
            return false;
        }
        Set<String> set = this.__featuresMap.get(string.toUpperCase(Locale.ENGLISH));
        if (set != null) {
            return set.contains(string2);
        }
        return false;
    }

    private boolean initFeatureMap() {
        if (this.__featuresMap == null) {
            boolean bl2 = FTPReply.isPositiveCompletion(this.feat());
            this.__featuresMap = new HashMap();
            if (!bl2) {
                return false;
            }
            for (String string : this.getReplyStrings()) {
                String string2;
                if (!string.startsWith(" ")) continue;
                String string3 = "";
                int n2 = string.indexOf(32, 1);
                if (n2 > 0) {
                    string2 = string.substring(1, n2);
                    string3 = string.substring(n2 + 1);
                } else {
                    string2 = string.substring(1);
                }
                string2 = string2.toUpperCase(Locale.ENGLISH);
                Set<String> set = this.__featuresMap.get(string2);
                if (set == null) {
                    set = new HashSet<String>();
                    this.__featuresMap.put(string2, set);
                }
                set.add(string3);
            }
        }
        return true;
    }

    public boolean allocate(int n2, int n3) {
        return FTPReply.isPositiveCompletion(this.allo(n2, n3));
    }

    public boolean doCommand(String string, String string2) {
        return FTPReply.isPositiveCompletion(this.sendCommand(string, string2));
    }

    public String[] doCommandAsStrings(String string, String string2) {
        boolean bl2 = FTPReply.isPositiveCompletion(this.sendCommand(string, string2));
        if (bl2) {
            return this.getReplyStrings();
        }
        return null;
    }

    public FTPFile mlistFile(String string) {
        boolean bl2 = FTPReply.isPositiveCompletion(this.sendCommand(FTPCmd.MLST, string));
        if (bl2) {
            String string2 = this.getReplyStrings()[1].substring(1);
            return MLSxEntryParser.parseEntry(string2);
        }
        return null;
    }

    public FTPFile[] mlistDir() {
        return this.mlistDir(null);
    }

    public FTPFile[] mlistDir(String string) {
        FTPListParseEngine fTPListParseEngine = this.initiateMListParsing(string);
        return fTPListParseEngine.getFiles();
    }

    public FTPFile[] mlistDir(String string, FTPFileFilter fTPFileFilter) {
        FTPListParseEngine fTPListParseEngine = this.initiateMListParsing(string);
        return fTPListParseEngine.getFiles(fTPFileFilter);
    }

    protected boolean restart(long l2) {
        this.__restartOffset = 0L;
        return FTPReply.isPositiveIntermediate(this.rest(Long.toString(l2)));
    }

    public void setRestartOffset(long l2) {
        if (l2 >= 0L) {
            this.__restartOffset = l2;
        }
    }

    public long getRestartOffset() {
        return this.__restartOffset;
    }

    public boolean rename(String string, String string2) {
        if (!FTPReply.isPositiveIntermediate(this.rnfr(string))) {
            return false;
        }
        return FTPReply.isPositiveCompletion(this.rnto(string2));
    }

    public boolean abort() {
        return FTPReply.isPositiveCompletion(this.abor());
    }

    public boolean deleteFile(String string) {
        return FTPReply.isPositiveCompletion(this.dele(string));
    }

    public boolean removeDirectory(String string) {
        return FTPReply.isPositiveCompletion(this.rmd(string));
    }

    public boolean makeDirectory(String string) {
        return FTPReply.isPositiveCompletion(this.mkd(string));
    }

    public String printWorkingDirectory() {
        if (this.pwd() != 257) {
            return null;
        }
        return FTPClient.__parsePathname((String)this._replyLines.get(this._replyLines.size() - 1));
    }

    public boolean sendSiteCommand(String string) {
        return FTPReply.isPositiveCompletion(this.site(string));
    }

    public String getSystemType() {
        if (this.__systemName == null) {
            if (FTPReply.isPositiveCompletion(this.syst())) {
                this.__systemName = ((String)this._replyLines.get(this._replyLines.size() - 1)).substring(4);
            } else {
                String string = System.getProperty(FTP_SYSTEM_TYPE_DEFAULT);
                if (string != null) {
                    this.__systemName = string;
                } else {
                    throw new IOException("Unable to determine system type - response: " + this.getReplyString());
                }
            }
        }
        return this.__systemName;
    }

    public String listHelp() {
        if (FTPReply.isPositiveCompletion(this.help())) {
            return this.getReplyString();
        }
        return null;
    }

    public String listHelp(String string) {
        if (FTPReply.isPositiveCompletion(this.help(string))) {
            return this.getReplyString();
        }
        return null;
    }

    public boolean sendNoOp() {
        return FTPReply.isPositiveCompletion(this.noop());
    }

    public String[] listNames(String string) {
        String string2;
        Socket socket = this._openDataConnection_(FTPCmd.NLST, this.getListArguments(string));
        if (socket == null) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), this.getControlEncoding()));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            arrayList.add(string2);
        }
        bufferedReader.close();
        socket.close();
        if (this.completePendingCommand()) {
            String[] stringArray = new String[arrayList.size()];
            return arrayList.toArray(stringArray);
        }
        return null;
    }

    public String[] listNames() {
        return this.listNames(null);
    }

    public FTPFile[] listFiles(String string) {
        FTPListParseEngine fTPListParseEngine = this.initiateListParsing((String)null, string);
        return fTPListParseEngine.getFiles();
    }

    public FTPFile[] listFiles() {
        return this.listFiles(null);
    }

    public FTPFile[] listFiles(String string, FTPFileFilter fTPFileFilter) {
        FTPListParseEngine fTPListParseEngine = this.initiateListParsing((String)null, string);
        return fTPListParseEngine.getFiles(fTPFileFilter);
    }

    public FTPFile[] listDirectories() {
        return this.listDirectories(null);
    }

    public FTPFile[] listDirectories(String string) {
        return this.listFiles(string, FTPFileFilters.DIRECTORIES);
    }

    public FTPListParseEngine initiateListParsing() {
        return this.initiateListParsing(null);
    }

    public FTPListParseEngine initiateListParsing(String string) {
        return this.initiateListParsing((String)null, string);
    }

    public FTPListParseEngine initiateListParsing(String string, String string2) {
        if (this.__entryParser == null || !this.__entryParserKey.equals(string)) {
            if (null != string) {
                this.__entryParser = this.__parserFactory.createFileEntryParser(string);
                this.__entryParserKey = string;
            } else if (null != this.__configuration) {
                this.__entryParser = this.__parserFactory.createFileEntryParser(this.__configuration);
                this.__entryParserKey = this.__configuration.getServerSystemKey();
            } else {
                String string3 = System.getProperty(FTP_SYSTEM_TYPE);
                if (string3 == null) {
                    String string4;
                    string3 = this.getSystemType();
                    Properties properties = FTPClient.getOverrideProperties();
                    if (properties != null && (string4 = properties.getProperty(string3)) != null) {
                        string3 = string4;
                    }
                }
                this.__entryParser = this.__parserFactory.createFileEntryParser(string3);
                this.__entryParserKey = string3;
            }
        }
        return this.initiateListParsing(this.__entryParser, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPListParseEngine initiateListParsing(FTPFileEntryParser fTPFileEntryParser, String string) {
        Socket socket = this._openDataConnection_(FTPCmd.LIST, this.getListArguments(string));
        FTPListParseEngine fTPListParseEngine = new FTPListParseEngine(fTPFileEntryParser);
        if (socket == null) {
            return fTPListParseEngine;
        }
        try {
            fTPListParseEngine.readServerList(socket.getInputStream(), this.getControlEncoding());
        }
        finally {
            Util.closeQuietly(socket);
        }
        this.completePendingCommand();
        return fTPListParseEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPListParseEngine initiateMListParsing(String string) {
        Socket socket = this._openDataConnection_(FTPCmd.MLSD, string);
        FTPListParseEngine fTPListParseEngine = new FTPListParseEngine(MLSxEntryParser.getInstance());
        if (socket == null) {
            return fTPListParseEngine;
        }
        try {
            fTPListParseEngine.readServerList(socket.getInputStream(), this.getControlEncoding());
        }
        finally {
            Util.closeQuietly(socket);
            this.completePendingCommand();
        }
        return fTPListParseEngine;
    }

    protected String getListArguments(String string) {
        if (this.getListHiddenFiles()) {
            if (string != null) {
                StringBuilder stringBuilder = new StringBuilder(string.length() + 3);
                stringBuilder.append("-a ");
                stringBuilder.append(string);
                return stringBuilder.toString();
            }
            return "-a";
        }
        return string;
    }

    public String getStatus() {
        if (FTPReply.isPositiveCompletion(this.stat())) {
            return this.getReplyString();
        }
        return null;
    }

    public String getStatus(String string) {
        if (FTPReply.isPositiveCompletion(this.stat(string))) {
            return this.getReplyString();
        }
        return null;
    }

    public String getModificationTime(String string) {
        if (FTPReply.isPositiveCompletion(this.mdtm(string))) {
            return this.getReplyString();
        }
        return null;
    }

    public boolean setModificationTime(String string, String string2) {
        return FTPReply.isPositiveCompletion(this.mfmt(string, string2));
    }

    public void setBufferSize(int n2) {
        this.__bufferSize = n2;
    }

    public int getBufferSize() {
        return this.__bufferSize;
    }

    public void setSendDataSocketBufferSize(int n2) {
        this.__sendDataSocketBufferSize = n2;
    }

    public int getSendDataSocketBufferSize() {
        return this.__sendDataSocketBufferSize;
    }

    public void setReceieveDataSocketBufferSize(int n2) {
        this.__receiveDataSocketBufferSize = n2;
    }

    public int getReceiveDataSocketBufferSize() {
        return this.__receiveDataSocketBufferSize;
    }

    public void configure(FTPClientConfig fTPClientConfig) {
        this.__configuration = fTPClientConfig;
    }

    public void setListHiddenFiles(boolean bl2) {
        this.__listHiddenFiles = bl2;
    }

    public boolean getListHiddenFiles() {
        return this.__listHiddenFiles;
    }

    public boolean isUseEPSVwithIPv4() {
        return this.__useEPSVwithIPv4;
    }

    public void setUseEPSVwithIPv4(boolean bl2) {
        this.__useEPSVwithIPv4 = bl2;
    }

    public void setCopyStreamListener(CopyStreamListener copyStreamListener) {
        this.__copyStreamListener = copyStreamListener;
    }

    public CopyStreamListener getCopyStreamListener() {
        return this.__copyStreamListener;
    }

    public void setControlKeepAliveTimeout(long l2) {
        this.__controlKeepAliveTimeout = l2 * 1000L;
    }

    public long getControlKeepAliveTimeout() {
        return this.__controlKeepAliveTimeout / 1000L;
    }

    public void setControlKeepAliveReplyTimeout(int n2) {
        this.__controlKeepAliveReplyTimeout = n2;
    }

    public int getControlKeepAliveReplyTimeout() {
        return this.__controlKeepAliveReplyTimeout;
    }

    public void setPassiveNatWorkaround(boolean bl2) {
        this.__passiveNatWorkaround = bl2;
    }

    private OutputStream getBufferedOutputStream(OutputStream outputStream) {
        if (this.__bufferSize > 0) {
            return new BufferedOutputStream(outputStream, this.__bufferSize);
        }
        return new BufferedOutputStream(outputStream);
    }

    private InputStream getBufferedInputStream(InputStream inputStream) {
        if (this.__bufferSize > 0) {
            return new BufferedInputStream(inputStream, this.__bufferSize);
        }
        return new BufferedInputStream(inputStream);
    }

    private CopyStreamListener __mergeListeners(CopyStreamListener copyStreamListener) {
        if (copyStreamListener == null) {
            return this.__copyStreamListener;
        }
        if (this.__copyStreamListener == null) {
            return copyStreamListener;
        }
        CopyStreamAdapter copyStreamAdapter = new CopyStreamAdapter();
        copyStreamAdapter.addCopyStreamListener(copyStreamListener);
        copyStreamAdapter.addCopyStreamListener(this.__copyStreamListener);
        return copyStreamAdapter;
    }

    public void setAutodetectUTF8(boolean bl2) {
        this.__autodetectEncoding = bl2;
    }

    public boolean getAutodetectUTF8() {
        return this.__autodetectEncoding;
    }

    @Deprecated
    public String getSystemName() {
        if (this.__systemName == null && FTPReply.isPositiveCompletion(this.syst())) {
            this.__systemName = ((String)this._replyLines.get(this._replyLines.size() - 1)).substring(4);
        }
        return this.__systemName;
    }

    private static class CSL
    implements CopyStreamListener {
        private final FTPClient parent;
        private final long idle;
        private final int currentSoTimeout;
        private long time = System.currentTimeMillis();
        private int notAcked;

        CSL(FTPClient fTPClient, long l2, int n2) {
            this.idle = l2;
            this.parent = fTPClient;
            this.currentSoTimeout = fTPClient.getSoTimeout();
            fTPClient.setSoTimeout(n2);
        }

        public void bytesTransferred(CopyStreamEvent copyStreamEvent) {
            this.bytesTransferred(copyStreamEvent.getTotalBytesTransferred(), copyStreamEvent.getBytesTransferred(), copyStreamEvent.getStreamSize());
        }

        public void bytesTransferred(long l2, int n2, long l3) {
            long l4 = System.currentTimeMillis();
            if (l4 - this.time > this.idle) {
                try {
                    this.parent.__noop();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    ++this.notAcked;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.time = l4;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanUp() {
            try {
                while (this.notAcked-- > 0) {
                    this.parent.__getReplyNoReport();
                }
            }
            finally {
                this.parent.setSoTimeout(this.currentSoTimeout);
            }
        }
    }

    private static class PropertiesSingleton {
        static final Properties PROPERTIES;

        private PropertiesSingleton() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            InputStream inputStream = FTPClient.class.getResourceAsStream(FTPClient.SYSTEM_TYPE_PROPERTIES);
            Properties properties = null;
            if (inputStream != null) {
                properties = new Properties();
                try {
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            PROPERTIES = properties;
        }
    }
}

