/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.apache.commons.net.ftp;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Formatter;

public class FTPFile
implements Serializable {
    private static final long serialVersionUID = 9010790363003271996L;
    public static final int FILE_TYPE = 0;
    public static final int DIRECTORY_TYPE = 1;
    public static final int SYMBOLIC_LINK_TYPE = 2;
    public static final int UNKNOWN_TYPE = 3;
    public static final int USER_ACCESS = 0;
    public static final int GROUP_ACCESS = 1;
    public static final int WORLD_ACCESS = 2;
    public static final int READ_PERMISSION = 0;
    public static final int WRITE_PERMISSION = 1;
    public static final int EXECUTE_PERMISSION = 2;
    private int _type = 3;
    private int _hardLinkCount = 0;
    private long _size = -1L;
    private String _rawListing = null;
    private String _user = "";
    private String _group = "";
    private String _name = null;
    private String _link;
    private Calendar _date = null;
    private final boolean[][] _permissions = new boolean[3][3];

    public void setRawListing(String string) {
        this._rawListing = string;
    }

    public String getRawListing() {
        return this._rawListing;
    }

    public boolean isDirectory() {
        return this._type == 1;
    }

    public boolean isFile() {
        return this._type == 0;
    }

    public boolean isSymbolicLink() {
        return this._type == 2;
    }

    public boolean isUnknown() {
        return this._type == 3;
    }

    public void setType(int n2) {
        this._type = n2;
    }

    public int getType() {
        return this._type;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public void setSize(long l2) {
        this._size = l2;
    }

    public long getSize() {
        return this._size;
    }

    public void setHardLinkCount(int n2) {
        this._hardLinkCount = n2;
    }

    public int getHardLinkCount() {
        return this._hardLinkCount;
    }

    public void setGroup(String string) {
        this._group = string;
    }

    public String getGroup() {
        return this._group;
    }

    public void setUser(String string) {
        this._user = string;
    }

    public String getUser() {
        return this._user;
    }

    public void setLink(String string) {
        this._link = string;
    }

    public String getLink() {
        return this._link;
    }

    public void setTimestamp(Calendar calendar) {
        this._date = calendar;
    }

    public Calendar getTimestamp() {
        return this._date;
    }

    public void setPermission(int n2, int n3, boolean bl2) {
        this._permissions[n2][n3] = bl2;
    }

    public boolean hasPermission(int n2, int n3) {
        return this._permissions[n2][n3];
    }

    public String toString() {
        return this.getRawListing();
    }

    public String toFormattedString() {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder);
        stringBuilder.append(this.formatType());
        stringBuilder.append(this.permissionToString(0));
        stringBuilder.append(this.permissionToString(1));
        stringBuilder.append(this.permissionToString(2));
        formatter.format(" %4d", this.getHardLinkCount());
        formatter.format(" %-8s %-8s", this.getGroup(), this.getUser());
        formatter.format(" %8d", this.getSize());
        Calendar calendar = this.getTimestamp();
        if (calendar != null) {
            formatter.format(" %1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS", calendar);
            formatter.format(" %1$tZ", calendar);
            stringBuilder.append(' ');
        }
        stringBuilder.append(' ');
        stringBuilder.append(this.getName());
        formatter.close();
        return stringBuilder.toString();
    }

    private char formatType() {
        switch (this._type) {
            case 0: {
                return '-';
            }
            case 1: {
                return 'd';
            }
            case 2: {
                return 'l';
            }
        }
        return '?';
    }

    private String permissionToString(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasPermission(n2, 0)) {
            stringBuilder.append('r');
        } else {
            stringBuilder.append('-');
        }
        if (this.hasPermission(n2, 1)) {
            stringBuilder.append('w');
        } else {
            stringBuilder.append('-');
        }
        if (this.hasPermission(n2, 2)) {
            stringBuilder.append('x');
        } else {
            stringBuilder.append('-');
        }
        return stringBuilder.toString();
    }
}

