/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPFile;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPFileEntryParser;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPFileFilter;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPFileFilters;
import me.forseth11.easybackup.dependencies.apache.commons.net.util.Charsets;

public class FTPListParseEngine {
    private List<String> entries = new LinkedList<String>();
    private ListIterator<String> _internalIterator = this.entries.listIterator();
    private final FTPFileEntryParser parser;

    public FTPListParseEngine(FTPFileEntryParser fTPFileEntryParser) {
        this.parser = fTPFileEntryParser;
    }

    public void readServerList(InputStream inputStream, String string) {
        this.entries = new LinkedList<String>();
        this.readStream(inputStream, string);
        this.parser.preParse(this.entries);
        this.resetIterator();
    }

    private void readStream(InputStream inputStream, String string) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charsets.toCharset(string)));
        String string2 = this.parser.readNextEntry(bufferedReader);
        while (string2 != null) {
            this.entries.add(string2);
            string2 = this.parser.readNextEntry(bufferedReader);
        }
        bufferedReader.close();
    }

    public FTPFile[] getNext(int n2) {
        LinkedList<FTPFile> linkedList = new LinkedList<FTPFile>();
        for (int i2 = n2; i2 > 0 && this._internalIterator.hasNext(); --i2) {
            String string = this._internalIterator.next();
            FTPFile fTPFile = this.parser.parseFTPEntry(string);
            linkedList.add(fTPFile);
        }
        return linkedList.toArray(new FTPFile[linkedList.size()]);
    }

    public FTPFile[] getPrevious(int n2) {
        LinkedList<FTPFile> linkedList = new LinkedList<FTPFile>();
        for (int i2 = n2; i2 > 0 && this._internalIterator.hasPrevious(); --i2) {
            String string = this._internalIterator.previous();
            FTPFile fTPFile = this.parser.parseFTPEntry(string);
            linkedList.add(0, fTPFile);
        }
        return linkedList.toArray(new FTPFile[linkedList.size()]);
    }

    public FTPFile[] getFiles() {
        return this.getFiles(FTPFileFilters.NON_NULL);
    }

    public FTPFile[] getFiles(FTPFileFilter fTPFileFilter) {
        ArrayList<FTPFile> arrayList = new ArrayList<FTPFile>();
        for (String string : this.entries) {
            FTPFile fTPFile = this.parser.parseFTPEntry(string);
            if (!fTPFileFilter.accept(fTPFile)) continue;
            arrayList.add(fTPFile);
        }
        return arrayList.toArray(new FTPFile[arrayList.size()]);
    }

    public boolean hasNext() {
        return this._internalIterator.hasNext();
    }

    public boolean hasPrevious() {
        return this._internalIterator.hasPrevious();
    }

    public void resetIterator() {
        this._internalIterator = this.entries.listIterator();
    }

    @Deprecated
    public void readServerList(InputStream inputStream) {
        this.readServerList(inputStream, null);
    }
}

