/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.builder;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import me.forseth11.easybackup.dependencies.cronutils.model.Cron;
import me.forseth11.easybackup.dependencies.cronutils.model.SingleCron;
import me.forseth11.easybackup.dependencies.cronutils.model.definition.CronDefinition;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.constraint.FieldConstraints;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.visitor.ValidationFieldExpressionVisitor;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;
import me.forseth11.easybackup.dependencies.cronutils.utils.VisibleForTesting;

public class CronBuilder {
    private final Map<CronFieldName, CronField> fields = new EnumMap<CronFieldName, CronField>(CronFieldName.class);
    private final CronDefinition definition;

    private CronBuilder(CronDefinition cronDefinition) {
        this.definition = cronDefinition;
    }

    public static CronBuilder cron(CronDefinition cronDefinition) {
        return new CronBuilder(cronDefinition);
    }

    public CronBuilder withDoY(FieldExpression fieldExpression) {
        return this.addField(CronFieldName.DAY_OF_YEAR, fieldExpression);
    }

    public CronBuilder withYear(FieldExpression fieldExpression) {
        return this.addField(CronFieldName.YEAR, fieldExpression);
    }

    public CronBuilder withDoM(FieldExpression fieldExpression) {
        return this.addField(CronFieldName.DAY_OF_MONTH, fieldExpression);
    }

    public CronBuilder withMonth(FieldExpression fieldExpression) {
        return this.addField(CronFieldName.MONTH, fieldExpression);
    }

    public CronBuilder withDoW(FieldExpression fieldExpression) {
        return this.addField(CronFieldName.DAY_OF_WEEK, fieldExpression);
    }

    public CronBuilder withHour(FieldExpression fieldExpression) {
        return this.addField(CronFieldName.HOUR, fieldExpression);
    }

    public CronBuilder withMinute(FieldExpression fieldExpression) {
        return this.addField(CronFieldName.MINUTE, fieldExpression);
    }

    public CronBuilder withSecond(FieldExpression fieldExpression) {
        return this.addField(CronFieldName.SECOND, fieldExpression);
    }

    public Cron instance() {
        return new SingleCron(this.definition, new ArrayList<CronField>(this.fields.values())).validate();
    }

    @VisibleForTesting
    CronBuilder addField(CronFieldName cronFieldName, FieldExpression fieldExpression) {
        Preconditions.checkState(this.definition != null, "CronBuilder not initialized.", new Object[0]);
        FieldConstraints fieldConstraints = this.definition.getFieldDefinition(cronFieldName).getConstraints();
        fieldExpression.accept(new ValidationFieldExpressionVisitor(fieldConstraints));
        this.fields.put(cronFieldName, new CronField(cronFieldName, fieldExpression, fieldConstraints));
        return this;
    }
}

