/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.descriptor;

import java.util.HashSet;
import java.util.Set;
import me.forseth11.easybackup.dependencies.cronutils.Function;
import me.forseth11.easybackup.dependencies.cronutils.descriptor.DescriptionStrategy;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Always;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Between;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Every;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.On;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.IntegerFieldValue;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

class TimeDescriptionStrategy
extends DescriptionStrategy {
    private static final int DEFAULTSECONDS = 0;
    private static final String EVERY_MINUTE_FORMAT = "%s %s ";
    private final FieldExpression hours;
    private final FieldExpression minutes;
    private final FieldExpression seconds;
    private final Set<Function<TimeFields, String>> descriptions;

    TimeDescriptionStrategy(FieldExpression fieldExpression, FieldExpression fieldExpression2, FieldExpression fieldExpression3) {
        this.hours = this.ensureInstance(fieldExpression, FieldExpression.always());
        this.minutes = this.ensureInstance(fieldExpression2, FieldExpression.always());
        this.seconds = this.ensureInstance(fieldExpression3, new On(new IntegerFieldValue(0)));
        this.descriptions = new HashSet<Function<TimeFields, String>>();
        this.registerFunctions();
    }

    private FieldExpression ensureInstance(FieldExpression fieldExpression, FieldExpression fieldExpression2) {
        Preconditions.checkNotNull(fieldExpression2, "Default expression must not be null");
        if (fieldExpression != null) {
            return fieldExpression;
        }
        return fieldExpression2;
    }

    @Override
    public String describe() {
        Function<TimeFields, String> function2;
        TimeFields timeFields = new TimeFields(this.hours, this.minutes, this.seconds);
        for (Function<TimeFields, String> function2 : this.descriptions) {
            if ("".equals(function2.apply(timeFields))) continue;
            return (String)function2.apply(timeFields);
        }
        Object object = "";
        function2 = "";
        String string = this.addTimeExpressions(this.describe(this.hours), "hour", "hours");
        if (!(this.seconds instanceof On) || !this.isDefault((On)this.seconds)) {
            object = this.addTimeExpressions(this.describe(this.seconds), "second", "seconds");
        }
        if (!(this.minutes instanceof On) || !this.isDefault((On)this.minutes)) {
            function2 = this.addTimeExpressions(this.describe(this.minutes), "minute", "minutes");
        }
        return String.format("%s %s %s", object, function2, string);
    }

    private String addTimeExpressions(String string, String string2, String string3) {
        return string.replaceAll("%s", string2).replaceAll("replace_plural", string3);
    }

    private void registerFunctions() {
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof Always && ((TimeFields)timeFields).minutes instanceof Always) {
                if (((TimeFields)timeFields).seconds instanceof Always) {
                    return String.format(EVERY_MINUTE_FORMAT, "every", "second");
                }
                if (((TimeFields)timeFields).seconds instanceof On) {
                    if (this.isDefault((On)((TimeFields)timeFields).seconds)) {
                        return String.format(EVERY_MINUTE_FORMAT, "every", "minute");
                    }
                    return String.format("%s %s %s %s %02d", "every", "minute", "at", "second", ((On)((TimeFields)timeFields).seconds).getTime().getValue());
                }
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof Always && ((TimeFields)timeFields).minutes instanceof On && ((TimeFields)timeFields).seconds instanceof On) {
                if (this.isDefault((On)((TimeFields)timeFields).seconds)) {
                    if (this.isDefault((On)((TimeFields)timeFields).minutes)) {
                        return String.format(EVERY_MINUTE_FORMAT, "every", "hour");
                    }
                    return String.format("%s %s %s %s %s", "every", "hour", "at", "minute", ((On)((TimeFields)timeFields).minutes).getTime().getValue());
                }
                return String.format("%s %s %s %s %s %s %s %s", "every", "hour", "at", "minute", ((On)((TimeFields)timeFields).minutes).getTime().getValue(), "and", "second", ((On)((TimeFields)timeFields).seconds).getTime().getValue());
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof On && ((TimeFields)timeFields).minutes instanceof On && ((TimeFields)timeFields).seconds instanceof Always) {
                return String.format("%s %s %s %02d:%02d", "every", "second", "at", ((On)this.hours).getTime().getValue(), ((On)this.minutes).getTime().getValue());
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof On && ((TimeFields)timeFields).minutes instanceof On && ((TimeFields)timeFields).seconds instanceof On) {
                if (this.isDefault((On)((TimeFields)timeFields).seconds)) {
                    return String.format("%s %02d:%02d", "at", ((On)this.hours).getTime().getValue(), ((On)this.minutes).getTime().getValue());
                }
                return String.format("%s %02d:%02d:%02d", "at", ((On)this.hours).getTime().getValue(), ((On)this.minutes).getTime().getValue(), ((On)this.seconds).getTime().getValue());
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof On && ((TimeFields)timeFields).minutes instanceof Always && ((TimeFields)timeFields).seconds instanceof Always) {
                return String.format("%s %02d:00", "at", ((On)this.hours).getTime().getValue());
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof On && ((TimeFields)timeFields).minutes instanceof Between) {
                if (((TimeFields)timeFields).seconds instanceof On) {
                    return String.format("%s %s %s %02d:%02d %s %02d:%02d", "every", "minute", "between", ((On)((TimeFields)timeFields).hours).getTime().getValue(), ((Between)((TimeFields)timeFields).minutes).getFrom().getValue(), "and", ((On)((TimeFields)timeFields).hours).getTime().getValue(), ((Between)((TimeFields)timeFields).minutes).getTo().getValue());
                }
                if (((TimeFields)timeFields).seconds instanceof Always) {
                    return String.format("%s %s %s %02d:%02d %s %02d:%02d", "every", "second", "between", ((On)((TimeFields)timeFields).hours).getTime().getValue(), ((Between)((TimeFields)timeFields).minutes).getFrom().getValue(), "and", ((On)((TimeFields)timeFields).hours).getTime().getValue(), ((Between)((TimeFields)timeFields).minutes).getTo().getValue());
                }
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof Always && ((TimeFields)timeFields).minutes instanceof Every && ((TimeFields)timeFields).seconds instanceof On) {
                Every every = (Every)((TimeFields)timeFields).minutes;
                String string = every.getPeriod().getValue() == 1 && this.isDefault((On)((TimeFields)timeFields).seconds) ? String.format(EVERY_MINUTE_FORMAT, "every", "minute") : String.format("%s %s %s ", "every", every.getPeriod().getValue(), "minutes");
                if (every.getExpression() instanceof Between) {
                    return "";
                }
                return string;
            }
            return "";
        });
        this.descriptions.add(timeFields -> {
            if (((TimeFields)timeFields).hours instanceof Every && ((TimeFields)timeFields).minutes instanceof On && ((TimeFields)timeFields).seconds instanceof On) {
                Object object;
                if (((On)((TimeFields)timeFields).minutes).getTime().getValue() == 0 && ((On)((TimeFields)timeFields).seconds).getTime().getValue() == 0 && ((object = ((Every)((TimeFields)timeFields).hours).getPeriod().getValue()) == null || (Integer)object == 1)) {
                    return String.format(EVERY_MINUTE_FORMAT, "every", "hour");
                }
                object = String.format("%s %s %s %s %s %s ", "every", ((Every)this.hours).getPeriod().getValue(), "hours", "at", "minute", ((On)this.minutes).getTime().getValue());
                if (this.isDefault((On)((TimeFields)timeFields).seconds)) {
                    return object;
                }
                return String.format("%s %s %s", "and", "second", ((On)this.seconds).getTime().getValue());
            }
            return "";
        });
    }

    private boolean isDefault(On on) {
        return on.getTime().getValue() == 0;
    }

    class TimeFields {
        private final FieldExpression seconds;
        private final FieldExpression minutes;
        private final FieldExpression hours;

        public TimeFields(FieldExpression fieldExpression, FieldExpression fieldExpression2, FieldExpression fieldExpression3) {
            this.hours = fieldExpression;
            this.minutes = fieldExpression2;
            this.seconds = fieldExpression3;
        }
    }
}

