/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.forseth11.easybackup.dependencies.cronutils.mapper.CronMapper;
import me.forseth11.easybackup.dependencies.cronutils.model.Cron;
import me.forseth11.easybackup.dependencies.cronutils.model.definition.CronDefinition;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

public class CompositeCron
implements Cron {
    private static final long serialVersionUID = -9095432563699768737L;
    private final Pattern split = Pattern.compile("\\|");
    private final List<Cron> crons;
    private final CronDefinition definition;

    public CompositeCron(List<Cron> list) {
        this.crons = Collections.unmodifiableList(list);
        Preconditions.checkNotNullNorEmpty(list, (Object)"List of Cron cannot be null or empty");
        this.definition = list.get(0).getCronDefinition();
        Preconditions.checkArgument((long)list.size() == list.stream().filter(cron -> cron.getCronDefinition().equals(this.definition)).count(), "All Cron objects must have same definition for CompositeCron");
    }

    public List<Cron> getCrons() {
        return this.crons;
    }

    @Override
    public CronField retrieve(CronFieldName cronFieldName) {
        throw new UnsupportedOperationException("Currently not supported for CompositeCron");
    }

    @Override
    public Map<CronFieldName, CronField> retrieveFieldsAsMap() {
        throw new UnsupportedOperationException("Currently not supported for CompositeCron");
    }

    @Override
    public String asString() {
        StringBuilder stringBuilder = new StringBuilder();
        List list = this.crons.stream().map(Cron::asString).collect(Collectors.toList());
        int n2 = ((String)list.get(0)).split(" ").length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StringBuilder stringBuilder2 = new StringBuilder();
            for (String string : list) {
                stringBuilder2.append(String.format("%s ", string.split(" ")[i2]));
            }
            Object object = stringBuilder2.toString().trim().replaceAll(" ", "|");
            if (this.split.splitAsStream((CharSequence)object).distinct().limit(2L).count() <= 1L) {
                object = this.split.split((CharSequence)object)[0];
            }
            stringBuilder.append(String.format("%s ", object));
        }
        return stringBuilder.toString().trim();
    }

    @Override
    public CronDefinition getCronDefinition() {
        return this.definition;
    }

    @Override
    public Cron validate() {
        for (Cron cron : this.crons) {
            cron.validate();
        }
        return this;
    }

    @Override
    public boolean equivalent(CronMapper cronMapper, Cron cron) {
        throw new UnsupportedOperationException("Currently not supported for CompositeCron");
    }

    @Override
    public boolean equivalent(Cron cron) {
        return this.asString().equals(cron.asString());
    }
}

