/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.definition;

import java.io.Serializable;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.forseth11.easybackup.dependencies.cronutils.model.definition.CronConstraint;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.definition.FieldDefinition;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

public class CronDefinition
implements Serializable {
    private static final long serialVersionUID = 7067112327461432170L;
    private final Map<CronFieldName, FieldDefinition> fieldDefinitions;
    private final Set<CronConstraint> cronConstraints;
    private final boolean matchDayOfWeekAndDayOfMonth;

    public CronDefinition(List<FieldDefinition> list, Set<CronConstraint> set, boolean bl2) {
        Preconditions.checkNotNull(list, "Field definitions must not be null");
        Preconditions.checkNotNull(set, "Cron validations must not be null");
        Preconditions.checkNotNullNorEmpty(list, (Object)"Field definitions must not be empty");
        Preconditions.checkArgument(!list.get(0).isOptional(), "The first field must not be optional");
        this.fieldDefinitions = new EnumMap<CronFieldName, FieldDefinition>(CronFieldName.class);
        for (FieldDefinition fieldDefinition : list) {
            this.fieldDefinitions.put(fieldDefinition.getFieldName(), fieldDefinition);
        }
        this.cronConstraints = Collections.unmodifiableSet(set);
        this.matchDayOfWeekAndDayOfMonth = bl2;
    }

    public boolean isMatchDayOfWeekAndDayOfMonth() {
        return this.matchDayOfWeekAndDayOfMonth;
    }

    public Set<FieldDefinition> getFieldDefinitions() {
        return new HashSet<FieldDefinition>(this.fieldDefinitions.values());
    }

    public Map<CronFieldName, FieldDefinition> retrieveFieldDefinitionsAsMap() {
        return Collections.unmodifiableMap(this.fieldDefinitions);
    }

    public FieldDefinition getFieldDefinition(CronFieldName cronFieldName) {
        return this.fieldDefinitions.get((Object)cronFieldName);
    }

    public boolean containsFieldDefinition(CronFieldName cronFieldName) {
        return this.fieldDefinitions.containsKey((Object)cronFieldName);
    }

    public Set<CronConstraint> getCronConstraints() {
        return this.cronConstraints;
    }
}

