/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.definition;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.forseth11.easybackup.dependencies.cronutils.model.CronType;
import me.forseth11.easybackup.dependencies.cronutils.model.definition.CronConstraint;
import me.forseth11.easybackup.dependencies.cronutils.model.definition.CronConstraintsFactory;
import me.forseth11.easybackup.dependencies.cronutils.model.definition.CronDefinition;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.definition.FieldDayOfWeekDefinitionBuilder;
import me.forseth11.easybackup.dependencies.cronutils.model.field.definition.FieldDefinition;
import me.forseth11.easybackup.dependencies.cronutils.model.field.definition.FieldDefinitionBuilder;
import me.forseth11.easybackup.dependencies.cronutils.model.field.definition.FieldQuestionMarkDefinitionBuilder;
import me.forseth11.easybackup.dependencies.cronutils.model.field.definition.FieldSpecialCharsDefinitionBuilder;

public class CronDefinitionBuilder {
    private final Map<CronFieldName, FieldDefinition> fields = new EnumMap<CronFieldName, FieldDefinition>(CronFieldName.class);
    private final Set<CronConstraint> cronConstraints = new HashSet<CronConstraint>();
    private boolean matchDayOfWeekAndDayOfMonth;

    private CronDefinitionBuilder() {
    }

    public static CronDefinitionBuilder defineCron() {
        return new CronDefinitionBuilder();
    }

    private static CronDefinition cron4j() {
        return CronDefinitionBuilder.defineCron().withMinutes().withStrictRange().and().withHours().withStrictRange().and().withDayOfMonth().supportsL().withStrictRange().and().withMonth().withStrictRange().and().withDayOfWeek().withValidRange(0, 6).withMondayDoWValue(1).withStrictRange().and().matchDayOfWeekAndDayOfMonth().instance();
    }

    private static CronDefinition quartz() {
        return CronDefinitionBuilder.defineCron().withSeconds().and().withMinutes().and().withHours().and().withDayOfMonth().withValidRange(1, 32).supportsL().supportsW().supportsLW().supportsQuestionMark().and().withMonth().withValidRange(1, 13).and().withDayOfWeek().withValidRange(1, 7).withMondayDoWValue(2).supportsHash().supportsL().supportsQuestionMark().and().withYear().withValidRange(1970, 2099).withStrictRange().optional().and().withCronValidation(CronConstraintsFactory.ensureEitherDayOfWeekOrDayOfMonth()).instance();
    }

    private static CronDefinition spring() {
        return CronDefinitionBuilder.defineCron().withSeconds().withStrictRange().and().withMinutes().withStrictRange().and().withHours().withStrictRange().and().withDayOfMonth().supportsQuestionMark().and().withMonth().and().withDayOfWeek().withValidRange(1, 7).withMondayDoWValue(2).supportsQuestionMark().and().instance();
    }

    private static CronDefinition unixCrontab() {
        return CronDefinitionBuilder.defineCron().withMinutes().withStrictRange().and().withHours().withStrictRange().and().withDayOfMonth().withStrictRange().and().withMonth().withStrictRange().and().withDayOfWeek().withValidRange(0, 7).withMondayDoWValue(1).withIntMapping(7, 0).withStrictRange().and().instance();
    }

    public static CronDefinition instanceDefinitionFor(CronType cronType) {
        switch (cronType) {
            case CRON4J: {
                return CronDefinitionBuilder.cron4j();
            }
            case QUARTZ: {
                return CronDefinitionBuilder.quartz();
            }
            case UNIX: {
                return CronDefinitionBuilder.unixCrontab();
            }
            case SPRING: {
                return CronDefinitionBuilder.spring();
            }
        }
        throw new IllegalArgumentException(String.format("No cron definition found for %s", new Object[]{cronType}));
    }

    public FieldDefinitionBuilder withSeconds() {
        return new FieldDefinitionBuilder(this, CronFieldName.SECOND);
    }

    public FieldDefinitionBuilder withMinutes() {
        return new FieldDefinitionBuilder(this, CronFieldName.MINUTE);
    }

    public FieldDefinitionBuilder withHours() {
        return new FieldDefinitionBuilder(this, CronFieldName.HOUR);
    }

    public FieldSpecialCharsDefinitionBuilder withDayOfMonth() {
        return new FieldSpecialCharsDefinitionBuilder(this, CronFieldName.DAY_OF_MONTH);
    }

    public FieldDefinitionBuilder withMonth() {
        return new FieldDefinitionBuilder(this, CronFieldName.MONTH);
    }

    public FieldDayOfWeekDefinitionBuilder withDayOfWeek() {
        return new FieldDayOfWeekDefinitionBuilder(this, CronFieldName.DAY_OF_WEEK);
    }

    public FieldDefinitionBuilder withYear() {
        return new FieldDefinitionBuilder(this, CronFieldName.YEAR);
    }

    public FieldQuestionMarkDefinitionBuilder withDayOfYear() {
        return new FieldQuestionMarkDefinitionBuilder(this, CronFieldName.DAY_OF_YEAR);
    }

    public CronDefinitionBuilder matchDayOfWeekAndDayOfMonth() {
        this.matchDayOfWeekAndDayOfMonth = true;
        return this;
    }

    public CronDefinitionBuilder withCronValidation(CronConstraint cronConstraint) {
        this.cronConstraints.add(cronConstraint);
        return this;
    }

    public void register(FieldDefinition fieldDefinition) {
        boolean bl2 = false;
        for (FieldDefinition fieldDefinition2 : this.fields.values()) {
            if (!fieldDefinition2.isOptional()) continue;
            bl2 = true;
            break;
        }
        if (!fieldDefinition.isOptional() && bl2) {
            throw new IllegalArgumentException("Can't register mandatory definition after a optional definition.");
        }
        this.fields.put(fieldDefinition.getFieldName(), fieldDefinition);
    }

    public CronDefinition instance() {
        HashSet<CronConstraint> hashSet = new HashSet<CronConstraint>();
        hashSet.addAll(this.cronConstraints);
        ArrayList<FieldDefinition> arrayList = new ArrayList<FieldDefinition>(this.fields.values());
        arrayList.sort(FieldDefinition.createFieldDefinitionComparator());
        return new CronDefinition(arrayList, hashSet, this.matchDayOfWeekAndDayOfMonth);
    }
}

