/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.field;

import java.io.Serializable;
import java.util.Comparator;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.constraint.FieldConstraints;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

public class CronField
implements Serializable {
    private static final long serialVersionUID = -4042499846855256325L;
    private final CronFieldName field;
    private final FieldExpression expression;
    private final FieldConstraints constraints;

    public CronField(CronFieldName cronFieldName, FieldExpression fieldExpression, FieldConstraints fieldConstraints) {
        this.field = cronFieldName;
        this.expression = Preconditions.checkNotNull(fieldExpression, "FieldExpression must not be null");
        this.constraints = Preconditions.checkNotNull(fieldConstraints, "FieldConstraints must not be null");
    }

    public static Comparator<CronField> createFieldComparator() {
        return Comparator.comparingInt(cronField -> cronField.getField().getOrder());
    }

    public CronFieldName getField() {
        return this.field;
    }

    public FieldExpression getExpression() {
        return this.expression;
    }

    public FieldConstraints getConstraints() {
        return this.constraints;
    }

    public String toString() {
        return "CronField{field=" + (Object)((Object)this.field) + '}';
    }
}

