/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.field.constraint;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.constraint.FieldConstraints;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.SpecialChar;

public class FieldConstraintsBuilder {
    private final Map<Integer, Integer> intMapping;
    private final Set<SpecialChar> specialChars;
    private Map<String, Integer> stringMapping = new HashMap<String, Integer>();
    private int startRange = 0;
    private int endRange;
    private boolean strictRange = false;

    private FieldConstraintsBuilder() {
        this.intMapping = new HashMap<Integer, Integer>();
        this.endRange = Integer.MAX_VALUE;
        this.specialChars = new HashSet<SpecialChar>();
        this.specialChars.add(SpecialChar.NONE);
    }

    private static Map<String, Integer> daysOfWeekMapping() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("MON", 1);
        hashMap.put("TUE", 2);
        hashMap.put("WED", 3);
        hashMap.put("THU", 4);
        hashMap.put("FRI", 5);
        hashMap.put("SAT", 6);
        hashMap.put("SUN", 7);
        return hashMap;
    }

    private static Map<String, Integer> monthsMapping() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("JAN", 1);
        hashMap.put("FEB", 2);
        hashMap.put("MAR", 3);
        hashMap.put("APR", 4);
        hashMap.put("MAY", 5);
        hashMap.put("JUN", 6);
        hashMap.put("JUL", 7);
        hashMap.put("AUG", 8);
        hashMap.put("SEP", 9);
        hashMap.put("OCT", 10);
        hashMap.put("NOV", 11);
        hashMap.put("DEC", 12);
        return hashMap;
    }

    public static FieldConstraintsBuilder instance() {
        return new FieldConstraintsBuilder();
    }

    public FieldConstraintsBuilder forField(CronFieldName cronFieldName) {
        switch (cronFieldName) {
            case SECOND: 
            case MINUTE: {
                this.endRange = 59;
                return this;
            }
            case HOUR: {
                this.endRange = 23;
                return this;
            }
            case DAY_OF_WEEK: {
                this.stringMapping = FieldConstraintsBuilder.daysOfWeekMapping();
                this.endRange = 6;
                return this;
            }
            case DAY_OF_MONTH: {
                this.startRange = 1;
                this.endRange = 31;
                return this;
            }
            case MONTH: {
                this.stringMapping = FieldConstraintsBuilder.monthsMapping();
                this.startRange = 1;
                this.endRange = 12;
                return this;
            }
            case DAY_OF_YEAR: {
                this.startRange = 1;
                this.endRange = 366;
                return this;
            }
        }
        return this;
    }

    public FieldConstraintsBuilder addHashSupport() {
        this.specialChars.add(SpecialChar.HASH);
        return this;
    }

    public FieldConstraintsBuilder addLSupport() {
        this.specialChars.add(SpecialChar.L);
        return this;
    }

    public FieldConstraintsBuilder addWSupport() {
        this.specialChars.add(SpecialChar.W);
        return this;
    }

    public FieldConstraintsBuilder addLWSupport() {
        this.specialChars.add(SpecialChar.LW);
        return this;
    }

    public FieldConstraintsBuilder addQuestionMarkSupport() {
        this.specialChars.add(SpecialChar.QUESTION_MARK);
        return this;
    }

    public FieldConstraintsBuilder withIntValueMapping(int n2, int n3) {
        this.intMapping.put(n2, n3);
        return this;
    }

    public FieldConstraintsBuilder withValidRange(int n2, int n3) {
        this.startRange = n2;
        this.endRange = n3;
        return this;
    }

    public FieldConstraintsBuilder withStrictRange() {
        this.strictRange = true;
        return this;
    }

    public FieldConstraintsBuilder withShiftedStringMapping(int n2) {
        if (n2 > 0 || this.endRange < this.stringMapping.size()) {
            for (Map.Entry<String, Integer> entry : this.stringMapping.entrySet()) {
                int n3 = entry.getValue();
                if ((n3 += n2) > this.endRange) {
                    n3 -= this.stringMapping.size();
                } else if (n3 < this.startRange) {
                    n3 += this.startRange - this.endRange;
                }
                this.stringMapping.put(entry.getKey(), n3);
            }
        }
        return this;
    }

    public FieldConstraints createConstraintsInstance() {
        return new FieldConstraints(this.stringMapping, this.intMapping, this.specialChars, this.startRange, this.endRange, this.strictRange);
    }
}

