/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.field.definition;

import me.forseth11.easybackup.dependencies.cronutils.model.definition.CronDefinitionBuilder;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.constraint.FieldConstraintsBuilder;
import me.forseth11.easybackup.dependencies.cronutils.model.field.definition.FieldDefinition;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

public class FieldDefinitionBuilder {
    protected final CronFieldName fieldName;
    protected CronDefinitionBuilder cronDefinitionBuilder;
    protected FieldConstraintsBuilder constraints;
    protected boolean optional;

    public FieldDefinitionBuilder(CronDefinitionBuilder cronDefinitionBuilder, CronFieldName cronFieldName) {
        this.cronDefinitionBuilder = Preconditions.checkNotNull(cronDefinitionBuilder, "ParserBuilder must not be null");
        this.fieldName = Preconditions.checkNotNull(cronFieldName, "CronFieldName must not be null");
        this.constraints = FieldConstraintsBuilder.instance().forField(cronFieldName);
    }

    public FieldDefinitionBuilder withIntMapping(int n2, int n3) {
        this.constraints.withIntValueMapping(n2, n3);
        return this;
    }

    public FieldDefinitionBuilder withValidRange(int n2, int n3) {
        this.constraints.withValidRange(n2, n3);
        return this;
    }

    public FieldDefinitionBuilder withStrictRange() {
        this.constraints.withStrictRange();
        return this;
    }

    public FieldDefinitionBuilder optional() {
        this.optional = true;
        return this;
    }

    public CronDefinitionBuilder and() {
        this.cronDefinitionBuilder.register(new FieldDefinition(this.fieldName, this.constraints.createConstraintsInstance(), this.optional));
        return this.cronDefinitionBuilder;
    }
}

