/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.field.expression.visitor;

import me.forseth11.easybackup.dependencies.cronutils.StringValidations;
import me.forseth11.easybackup.dependencies.cronutils.model.field.constraint.FieldConstraints;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Always;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.And;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Between;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Every;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.On;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.QuestionMark;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.visitor.FieldExpressionVisitor;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.FieldValue;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.IntegerFieldValue;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.SpecialChar;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.SpecialCharFieldValue;
import me.forseth11.easybackup.dependencies.cronutils.utils.VisibleForTesting;

public class ValidationFieldExpressionVisitor
implements FieldExpressionVisitor {
    private static final String OORANGE = "Value %s not in range [%s, %s]";
    private static final String EMPTY_STRING = "";
    private final FieldConstraints constraints;
    private final StringValidations stringValidations;

    public ValidationFieldExpressionVisitor(FieldConstraints fieldConstraints) {
        this.constraints = fieldConstraints;
        this.stringValidations = new StringValidations(fieldConstraints);
    }

    protected ValidationFieldExpressionVisitor(FieldConstraints fieldConstraints, StringValidations stringValidations) {
        this.constraints = fieldConstraints;
        this.stringValidations = stringValidations;
    }

    @Override
    public FieldExpression visit(FieldExpression fieldExpression) {
        String string = this.stringValidations.removeValidChars(fieldExpression.asString());
        if (EMPTY_STRING.equals(string)) {
            if (fieldExpression instanceof Always) {
                return this.visit((Always)fieldExpression);
            }
            if (fieldExpression instanceof And) {
                return this.visit((And)fieldExpression);
            }
            if (fieldExpression instanceof Between) {
                return this.visit((Between)fieldExpression);
            }
            if (fieldExpression instanceof Every) {
                return this.visit((Every)fieldExpression);
            }
            if (fieldExpression instanceof On) {
                return this.visit((On)fieldExpression);
            }
            if (fieldExpression instanceof QuestionMark) {
                return this.visit((QuestionMark)fieldExpression);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid chars in expression! Expression: %s Invalid chars: %s", fieldExpression.asString(), string));
    }

    @Override
    public Always visit(Always always) {
        return always;
    }

    @Override
    public And visit(And and) {
        for (FieldExpression fieldExpression : and.getExpressions()) {
            this.visit(fieldExpression);
        }
        return and;
    }

    @Override
    public Between visit(Between between) {
        int n2;
        int n3;
        this.preConditions(between);
        if (this.constraints.isStrictRange() && between.getFrom() instanceof IntegerFieldValue && between.getTo() instanceof IntegerFieldValue && (n3 = ((IntegerFieldValue)between.getFrom()).getValue().intValue()) > (n2 = ((IntegerFieldValue)between.getTo()).getValue().intValue())) {
            throw new IllegalArgumentException(String.format("Invalid range! [%s,%s]", n3, n2));
        }
        return between;
    }

    @Override
    public Every visit(Every every) {
        if (every.getExpression() instanceof Between) {
            this.visit((Between)every.getExpression());
        }
        if (every.getExpression() instanceof On) {
            this.visit((On)every.getExpression());
        }
        this.isPeriodInRange(every.getPeriod());
        return every;
    }

    @Override
    public On visit(On on) {
        if (!this.isDefault(on.getTime())) {
            this.isInRange(on.getTime());
        }
        if (!this.isDefault(on.getNth())) {
            this.isInRange(on.getNth());
        }
        return on;
    }

    @Override
    public QuestionMark visit(QuestionMark questionMark) {
        return questionMark;
    }

    private void preConditions(Between between) {
        this.isInRange(between.getFrom());
        this.isInRange(between.getTo());
        if (this.isSpecialCharNotL(between.getFrom()) || this.isSpecialCharNotL(between.getTo())) {
            throw new IllegalArgumentException("No special characters allowed in range, except for 'L'");
        }
    }

    @VisibleForTesting
    protected void isInRange(FieldValue<?> fieldValue) {
        int n2;
        if (fieldValue instanceof IntegerFieldValue && !this.constraints.isInRange(n2 = ((IntegerFieldValue)fieldValue).getValue().intValue())) {
            throw new IllegalArgumentException(String.format(OORANGE, n2, this.constraints.getStartRange(), this.constraints.getEndRange()));
        }
    }

    @VisibleForTesting
    protected void isPeriodInRange(FieldValue<?> fieldValue) {
        int n2;
        if (fieldValue instanceof IntegerFieldValue && !this.constraints.isPeriodInRange(n2 = ((IntegerFieldValue)fieldValue).getValue().intValue())) {
            throw new IllegalArgumentException(String.format("Period %s not in range (%s, %s]", n2, this.constraints.getStartRange(), this.constraints.getEndRange()));
        }
    }

    @VisibleForTesting
    protected boolean isDefault(FieldValue<?> fieldValue) {
        return fieldValue instanceof IntegerFieldValue && ((IntegerFieldValue)fieldValue).getValue() == -1;
    }

    protected boolean isSpecialCharNotL(FieldValue<?> fieldValue) {
        return fieldValue instanceof SpecialCharFieldValue && !SpecialChar.L.equals(fieldValue.getValue());
    }
}

