/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.time;

import me.forseth11.easybackup.dependencies.cronutils.model.Cron;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.constraint.FieldConstraints;
import me.forseth11.easybackup.dependencies.cronutils.model.field.constraint.FieldConstraintsBuilder;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.On;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.IntegerFieldValue;
import me.forseth11.easybackup.dependencies.cronutils.model.time.ExecutionTime;
import me.forseth11.easybackup.dependencies.cronutils.model.time.SingleExecutionTime;
import me.forseth11.easybackup.dependencies.cronutils.model.time.TimeNode;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.FieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.FieldValueGeneratorFactory;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

class ExecutionTimeBuilder {
    private final Cron cron;
    private FieldValueGenerator yearsValueGenerator;
    private CronField daysOfWeekCronField;
    private CronField daysOfMonthCronField;
    private CronField daysOfYearCronField;
    private TimeNode months;
    private TimeNode hours;
    private TimeNode minutes;
    private TimeNode seconds;

    protected ExecutionTimeBuilder(Cron cron) {
        this.cron = cron;
    }

    protected ExecutionTimeBuilder forSecondsMatching(CronField cronField) {
        this.validate(CronFieldName.SECOND, cronField);
        this.seconds = new TimeNode(FieldValueGeneratorFactory.forCronField(cronField).generateCandidates(0, 59));
        return this;
    }

    protected ExecutionTimeBuilder forMinutesMatching(CronField cronField) {
        this.validate(CronFieldName.MINUTE, cronField);
        this.minutes = new TimeNode(FieldValueGeneratorFactory.forCronField(cronField).generateCandidates(0, 59));
        return this;
    }

    protected ExecutionTimeBuilder forHoursMatching(CronField cronField) {
        this.validate(CronFieldName.HOUR, cronField);
        this.hours = new TimeNode(FieldValueGeneratorFactory.forCronField(cronField).generateCandidates(0, 23));
        return this;
    }

    protected ExecutionTimeBuilder forMonthsMatching(CronField cronField) {
        this.validate(CronFieldName.MONTH, cronField);
        this.months = new TimeNode(FieldValueGeneratorFactory.forCronField(cronField).generateCandidates(1, 12));
        return this;
    }

    protected ExecutionTimeBuilder forYearsMatching(CronField cronField) {
        this.validate(CronFieldName.YEAR, cronField);
        this.yearsValueGenerator = FieldValueGeneratorFactory.forCronField(cronField);
        return this;
    }

    protected ExecutionTimeBuilder forDaysOfWeekMatching(CronField cronField) {
        this.validate(CronFieldName.DAY_OF_WEEK, cronField);
        this.daysOfWeekCronField = cronField;
        return this;
    }

    protected ExecutionTimeBuilder forDaysOfMonthMatching(CronField cronField) {
        this.validate(CronFieldName.DAY_OF_MONTH, cronField);
        this.daysOfMonthCronField = cronField;
        return this;
    }

    protected ExecutionTimeBuilder forDaysOfYearMatching(CronField cronField) {
        this.validate(CronFieldName.DAY_OF_YEAR, cronField);
        this.daysOfYearCronField = cronField;
        return this;
    }

    protected ExecutionTime build() {
        FieldConstraints fieldConstraints;
        boolean bl2 = false;
        if (this.seconds == null) {
            this.seconds = this.timeNodeLowest(CronFieldName.SECOND, 0, 59);
        } else {
            bl2 = true;
        }
        if (this.minutes == null) {
            this.minutes = bl2 ? this.timeNodeAlways(CronFieldName.MINUTE, 0, 59) : this.timeNodeLowest(CronFieldName.MINUTE, 0, 59);
        } else {
            bl2 = true;
        }
        if (this.hours == null) {
            this.hours = bl2 ? this.timeNodeAlways(CronFieldName.HOUR, 0, 23) : this.timeNodeLowest(CronFieldName.HOUR, 0, 23);
        } else {
            bl2 = true;
        }
        if (this.daysOfMonthCronField == null) {
            fieldConstraints = this.getConstraint(CronFieldName.DAY_OF_MONTH);
            this.daysOfMonthCronField = bl2 ? new CronField(CronFieldName.DAY_OF_MONTH, FieldExpression.always(), fieldConstraints) : new CronField(CronFieldName.DAY_OF_MONTH, new On(new IntegerFieldValue(1)), fieldConstraints);
        } else {
            bl2 = true;
        }
        if (this.daysOfWeekCronField == null) {
            fieldConstraints = this.getConstraint(CronFieldName.DAY_OF_WEEK);
            this.daysOfWeekCronField = bl2 ? new CronField(CronFieldName.DAY_OF_WEEK, FieldExpression.always(), fieldConstraints) : new CronField(CronFieldName.DAY_OF_WEEK, new On(new IntegerFieldValue(1)), fieldConstraints);
        } else {
            bl2 = true;
        }
        if (this.months == null) {
            TimeNode timeNode = this.months = bl2 ? this.timeNodeAlways(CronFieldName.MONTH, 1, 12) : this.timeNodeLowest(CronFieldName.MONTH, 1, 12);
        }
        if (this.yearsValueGenerator == null) {
            this.yearsValueGenerator = FieldValueGeneratorFactory.forCronField(new CronField(CronFieldName.YEAR, FieldExpression.always(), this.getConstraint(CronFieldName.YEAR)));
        }
        if (this.daysOfYearCronField == null) {
            fieldConstraints = this.getConstraint(CronFieldName.DAY_OF_YEAR);
            this.daysOfYearCronField = new CronField(CronFieldName.DAY_OF_YEAR, bl2 ? FieldExpression.questionMark() : FieldExpression.always(), fieldConstraints);
        }
        return new SingleExecutionTime(this.cron.getCronDefinition(), this.cron.retrieve(CronFieldName.YEAR), this.daysOfWeekCronField, this.daysOfMonthCronField, this.daysOfYearCronField, this.months, this.hours, this.minutes, this.seconds);
    }

    private TimeNode timeNodeLowest(CronFieldName cronFieldName, int n2, int n3) {
        FieldConstraints fieldConstraints = this.getConstraint(cronFieldName);
        return new TimeNode(FieldValueGeneratorFactory.forCronField(new CronField(cronFieldName, new On(new IntegerFieldValue(n2)), fieldConstraints)).generateCandidates(n2, n3));
    }

    private TimeNode timeNodeAlways(CronFieldName cronFieldName, int n2, int n3) {
        return new TimeNode(FieldValueGeneratorFactory.forCronField(new CronField(cronFieldName, FieldExpression.always(), this.getConstraint(cronFieldName))).generateCandidates(n2, n3));
    }

    private void validate(CronFieldName cronFieldName, CronField cronField) {
        Preconditions.checkNotNull(cronFieldName, "Reference CronFieldName cannot be null");
        Preconditions.checkNotNull(cronField.getField(), "CronField's CronFieldName cannot be null");
        if (!cronFieldName.equals((Object)cronField.getField())) {
            throw new IllegalArgumentException(String.format("Invalid argument! Expected CronField instance for field %s but found %s", new Object[]{cronField.getField(), cronFieldName}));
        }
    }

    private FieldConstraints getConstraint(CronFieldName cronFieldName) {
        return this.cron.getCronDefinition().getFieldDefinition(cronFieldName) != null ? this.cron.getCronDefinition().getFieldDefinition(cronFieldName).getConstraints() : FieldConstraintsBuilder.instance().forField(cronFieldName).createConstraintsInstance();
    }
}

