/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.time;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.forseth11.easybackup.dependencies.cronutils.mapper.WeekDay;
import me.forseth11.easybackup.dependencies.cronutils.model.definition.CronDefinition;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.constraint.FieldConstraintsBuilder;
import me.forseth11.easybackup.dependencies.cronutils.model.field.definition.DayOfWeekFieldDefinition;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Always;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.QuestionMark;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.SpecialChar;
import me.forseth11.easybackup.dependencies.cronutils.model.time.ExecutionTime;
import me.forseth11.easybackup.dependencies.cronutils.model.time.NearestValue;
import me.forseth11.easybackup.dependencies.cronutils.model.time.TimeNode;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.FieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.FieldValueGeneratorFactory;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.NoSuchValueException;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;
import me.forseth11.easybackup.dependencies.cronutils.utils.Predicates;
import me.forseth11.easybackup.dependencies.cronutils.utils.VisibleForTesting;

public class SingleExecutionTime
implements ExecutionTime {
    private static final int MAX_ITERATIONS = 100000;
    private static final LocalTime MAX_SECONDS = LocalTime.MAX.truncatedTo(ChronoUnit.SECONDS);
    private final CronDefinition cronDefinition;
    private final FieldValueGenerator yearsValueGenerator;
    private final CronField daysOfWeekCronField;
    private final CronField daysOfMonthCronField;
    private final CronField daysOfYearCronField;
    private final TimeNode months;
    private final TimeNode hours;
    private final TimeNode minutes;
    private final TimeNode seconds;

    @VisibleForTesting
    SingleExecutionTime(CronDefinition cronDefinition, CronField cronField, CronField cronField2, CronField cronField3, CronField cronField4, TimeNode timeNode, TimeNode timeNode2, TimeNode timeNode3, TimeNode timeNode4) {
        this.cronDefinition = Preconditions.checkNotNull(cronDefinition);
        FieldValueGenerator fieldValueGenerator = FieldValueGeneratorFactory.forCronField(new CronField(CronFieldName.YEAR, Always.always(), FieldConstraintsBuilder.instance().createConstraintsInstance()));
        if (cronDefinition.containsFieldDefinition(CronFieldName.YEAR)) {
            if (!cronDefinition.getFieldDefinition(CronFieldName.YEAR).isOptional()) {
                Preconditions.checkNotNull(cronField);
            }
            this.yearsValueGenerator = cronField == null ? fieldValueGenerator : FieldValueGeneratorFactory.createYearValueGeneratorInstance(cronField);
        } else {
            this.yearsValueGenerator = fieldValueGenerator;
        }
        this.daysOfWeekCronField = Preconditions.checkNotNull(cronField2);
        this.daysOfMonthCronField = Preconditions.checkNotNull(cronField3);
        this.daysOfYearCronField = cronField4;
        this.months = Preconditions.checkNotNull(timeNode);
        this.hours = Preconditions.checkNotNull(timeNode2);
        this.minutes = Preconditions.checkNotNull(timeNode3);
        this.seconds = Preconditions.checkNotNull(timeNode4);
    }

    private static ExecutionTimeResult getNextPotentialValue(ZonedDateTime zonedDateTime, TimeNode timeNode, TemporalField temporalField) {
        HashSet<Integer> hashSet = new HashSet<Integer>(timeNode.values);
        TemporalUnit temporalUnit = temporalField.getBaseUnit();
        long l2 = temporalField.range().getMaximum();
        long l3 = temporalField.range().getMinimum();
        long l4 = l2 - l3;
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        for (long i2 = 0L; i2 < 2L * l4; ++i2) {
            if (!hashSet.contains((zonedDateTime2 = zonedDateTime2.plus(1L, temporalUnit)).get(temporalField))) continue;
            zonedDateTime2 = zonedDateTime2.truncatedTo(temporalUnit);
            return new ExecutionTimeResult(zonedDateTime2, false);
        }
        throw new NoSuchValueException();
    }

    private static ExecutionTimeResult getPreviousPotentialValue(ZonedDateTime zonedDateTime, TimeNode timeNode, TemporalField temporalField) {
        HashSet<Integer> hashSet = new HashSet<Integer>(timeNode.values);
        TemporalUnit temporalUnit = temporalField.getBaseUnit();
        long l2 = temporalField.range().getMaximum();
        long l3 = temporalField.range().getMinimum();
        long l4 = l2 - l3;
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        for (long i2 = 0L; i2 < 2L * l4; ++i2) {
            if (!hashSet.contains((zonedDateTime2 = zonedDateTime2.minus(1L, temporalUnit)).get(temporalField))) continue;
            zonedDateTime2 = zonedDateTime2.truncatedTo(temporalUnit).plus(1L, temporalUnit).minusSeconds(1L);
            return new ExecutionTimeResult(zonedDateTime2, false);
        }
        throw new NoSuchValueException();
    }

    @Override
    public Optional<ZonedDateTime> nextExecution(ZonedDateTime zonedDateTime) {
        Preconditions.checkNotNull(zonedDateTime);
        try {
            ZonedDateTime zonedDateTime2 = this.nextClosestMatch(zonedDateTime);
            if (zonedDateTime2.equals(zonedDateTime)) {
                zonedDateTime2 = this.nextClosestMatch(zonedDateTime.plusSeconds(1L));
            }
            return Optional.of(zonedDateTime2);
        }
        catch (NoSuchValueException noSuchValueException) {
            return Optional.empty();
        }
    }

    private ZonedDateTime nextClosestMatch(ZonedDateTime zonedDateTime) {
        ExecutionTimeResult executionTimeResult = new ExecutionTimeResult(zonedDateTime, false);
        for (int i2 = 0; i2 < 100000; ++i2) {
            if ((executionTimeResult = this.potentialNextClosestMatch(executionTimeResult.getTime())).isMatch()) {
                return executionTimeResult.getTime();
            }
            if (executionTimeResult.getTime().getYear() - zonedDateTime.getYear() <= 100) continue;
            throw new NoSuchValueException();
        }
        throw new NoSuchValueException();
    }

    private ExecutionTimeResult potentialNextClosestMatch(ZonedDateTime zonedDateTime) {
        List list = this.yearsValueGenerator.generateCandidates(zonedDateTime.getYear(), zonedDateTime.getYear()).stream().filter(n2 -> n2 >= zonedDateTime.getYear()).collect(Collectors.toList());
        int n3 = this.months.getValues().get(0);
        int n4 = this.hours.getValues().get(0);
        int n5 = this.minutes.getValues().get(0);
        int n6 = this.seconds.getValues().get(0);
        if (list.isEmpty()) {
            return this.getNextPotentialYear(zonedDateTime, n3, n4, n5, n6);
        }
        if (!this.months.getValues().contains(zonedDateTime.getMonthValue())) {
            return this.getNextPotentialMonth(zonedDateTime, n4, n5, n6);
        }
        Optional<TimeNode> optional = this.generateDays(this.cronDefinition, zonedDateTime);
        if (!optional.isPresent()) {
            return new ExecutionTimeResult(this.toBeginOfNextMonth(zonedDateTime), false);
        }
        TimeNode timeNode = optional.get();
        if (!timeNode.getValues().contains(zonedDateTime.getDayOfMonth())) {
            return this.getNextPotentialDayOfMonth(zonedDateTime, n4, n5, n6, timeNode);
        }
        if (!this.hours.getValues().contains(zonedDateTime.getHour())) {
            return this.getNextPotentialHour(zonedDateTime);
        }
        if (!this.minutes.getValues().contains(zonedDateTime.getMinute())) {
            return this.getNextPotentialMinute(zonedDateTime);
        }
        if (!this.seconds.getValues().contains(zonedDateTime.getSecond())) {
            return this.getNextPotentialSecond(zonedDateTime);
        }
        return new ExecutionTimeResult(zonedDateTime, true);
    }

    private ExecutionTimeResult getNextPotentialYear(ZonedDateTime zonedDateTime, int n2, int n3, int n4, int n5) {
        int n6 = this.yearsValueGenerator.generateNextValue(zonedDateTime.getYear());
        Optional<TimeNode> optional = this.generateDays(this.cronDefinition, ZonedDateTime.of(LocalDate.of(n6, n2, 1), LocalTime.MIN, zonedDateTime.getZone()));
        if (optional.isPresent()) {
            List<Integer> list = optional.get().getValues();
            return new ExecutionTimeResult(ZonedDateTime.of(LocalDate.of(n6, n2, (int)list.get(0)), LocalTime.of(n3, n4, n5), zonedDateTime.getZone()), false);
        }
        return new ExecutionTimeResult(this.toBeginOfNextMonth(zonedDateTime), false);
    }

    private ExecutionTimeResult getNextPotentialMonth(ZonedDateTime zonedDateTime, int n2, int n3, int n4) {
        NearestValue nearestValue = this.months.getNextValue(zonedDateTime.getMonthValue(), 0);
        int n5 = nearestValue.getValue();
        if (nearestValue.getShifts() > 0) {
            return new ExecutionTimeResult(zonedDateTime.truncatedTo(ChronoUnit.DAYS).withMonth(1).withDayOfMonth(1).plusYears(nearestValue.getShifts()), false);
        }
        Optional<TimeNode> optional = this.generateDays(this.cronDefinition, ZonedDateTime.of(LocalDateTime.of(zonedDateTime.getYear(), n5, 1, 0, 0), zonedDateTime.getZone()));
        if (optional.isPresent()) {
            List<Integer> list = optional.get().getValues();
            return new ExecutionTimeResult(zonedDateTime.truncatedTo(ChronoUnit.SECONDS).withMonth(n5).withDayOfMonth(list.get(0)).with(LocalTime.of(n2, n3, n4)), false);
        }
        return new ExecutionTimeResult(this.toBeginOfNextMonth(zonedDateTime), false);
    }

    private ExecutionTimeResult getNextPotentialDayOfMonth(ZonedDateTime zonedDateTime, int n2, int n3, int n4, TimeNode timeNode) {
        NearestValue nearestValue = timeNode.getNextValue(zonedDateTime.getDayOfMonth(), 0);
        if (nearestValue.getShifts() > 0) {
            return new ExecutionTimeResult(zonedDateTime.truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1).plusMonths(nearestValue.getShifts()), false);
        }
        return new ExecutionTimeResult(zonedDateTime.truncatedTo(ChronoUnit.SECONDS).withDayOfMonth(nearestValue.getValue()).with(LocalTime.of(n2, n3, n4)), false);
    }

    private ExecutionTimeResult getNextPotentialHour(ZonedDateTime zonedDateTime) {
        return SingleExecutionTime.getNextPotentialValue(zonedDateTime, this.hours, ChronoField.HOUR_OF_DAY);
    }

    private ExecutionTimeResult getNextPotentialMinute(ZonedDateTime zonedDateTime) {
        return SingleExecutionTime.getNextPotentialValue(zonedDateTime, this.minutes, ChronoField.MINUTE_OF_HOUR);
    }

    private ExecutionTimeResult getNextPotentialSecond(ZonedDateTime zonedDateTime) {
        return SingleExecutionTime.getNextPotentialValue(zonedDateTime, this.seconds, ChronoField.SECOND_OF_MINUTE);
    }

    private ZonedDateTime toBeginOfNextMonth(ZonedDateTime zonedDateTime) {
        return zonedDateTime.truncatedTo(ChronoUnit.DAYS).plusMonths(1L).withDayOfMonth(1);
    }

    private ZonedDateTime previousClosestMatch(ZonedDateTime zonedDateTime) {
        ExecutionTimeResult executionTimeResult = new ExecutionTimeResult(zonedDateTime, false);
        for (int i2 = 0; i2 < 100000; ++i2) {
            if (!(executionTimeResult = this.potentialPreviousClosestMatch(executionTimeResult.getTime())).isMatch()) continue;
            return executionTimeResult.getTime();
        }
        throw new NoSuchValueException();
    }

    private ExecutionTimeResult potentialPreviousClosestMatch(ZonedDateTime zonedDateTime) {
        List<Integer> list = this.yearsValueGenerator.generateCandidates(zonedDateTime.getYear(), zonedDateTime.getYear());
        Optional<TimeNode> optional = this.generateDays(this.cronDefinition, zonedDateTime);
        if (!optional.isPresent()) {
            return new ExecutionTimeResult(this.toEndOfPreviousMonth(zonedDateTime), false);
        }
        TimeNode timeNode = optional.get();
        int n2 = this.months.getValues().get(this.months.getValues().size() - 1);
        int n3 = timeNode.getValues().get(timeNode.getValues().size() - 1);
        int n4 = this.hours.getValues().get(this.hours.getValues().size() - 1);
        int n5 = this.minutes.getValues().get(this.minutes.getValues().size() - 1);
        int n6 = this.seconds.getValues().get(this.seconds.getValues().size() - 1);
        if (list.isEmpty()) {
            return this.getPreviousPotentialYear(zonedDateTime, timeNode, n2, n3, n4, n5, n6);
        }
        if (!this.months.getValues().contains(zonedDateTime.getMonthValue())) {
            return this.getPreviousPotentialMonth(zonedDateTime, n3, n4, n5, n6);
        }
        if (!timeNode.getValues().contains(zonedDateTime.getDayOfMonth())) {
            return this.getPreviousPotentialDayOfMonth(zonedDateTime, timeNode, n4, n5, n6);
        }
        if (!this.hours.getValues().contains(zonedDateTime.getHour())) {
            return this.getPreviousPotentialHour(zonedDateTime);
        }
        if (!this.minutes.getValues().contains(zonedDateTime.getMinute())) {
            return this.getPreviousPotentialMinute(zonedDateTime);
        }
        if (!this.seconds.getValues().contains(zonedDateTime.getSecond())) {
            return this.getPreviousPotentialSecond(zonedDateTime);
        }
        return new ExecutionTimeResult(zonedDateTime.truncatedTo(ChronoUnit.SECONDS), true);
    }

    private ExecutionTimeResult getPreviousPotentialYear(ZonedDateTime zonedDateTime, TimeNode timeNode, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = this.yearsValueGenerator.generatePreviousValue(zonedDateTime.getYear());
        if (n3 > 28 && n3 > (n7 = LocalDate.of(n8, n2, 1).lengthOfMonth())) {
            NearestValue nearestValue = timeNode.getPreviousValue(n3, 1);
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime zonedDateTime2 = ZonedDateTime.of(LocalDate.of(n8, n2, 1), MAX_SECONDS, zonedDateTime.getZone()).minusMonths(nearestValue.getShifts()).with(TemporalAdjusters.lastDayOfMonth());
                return new ExecutionTimeResult(zonedDateTime2, false);
            }
            n3 = nearestValue.getValue();
        }
        return new ExecutionTimeResult(ZonedDateTime.of(LocalDate.of(n8, n2, n3), LocalTime.of(n4, n5, n6), zonedDateTime.getZone()), false);
    }

    private ExecutionTimeResult getPreviousPotentialMonth(ZonedDateTime zonedDateTime, int n2, int n3, int n4, int n5) {
        NearestValue nearestValue = this.months.getPreviousValue(zonedDateTime.getMonthValue(), 0);
        int n6 = nearestValue.getValue();
        if (nearestValue.getShifts() > 0) {
            ZonedDateTime zonedDateTime2 = ZonedDateTime.of(LocalDate.of(zonedDateTime.getYear(), 12, 31), MAX_SECONDS, zonedDateTime.getZone()).minusYears(nearestValue.getShifts());
            return new ExecutionTimeResult(zonedDateTime2, false);
        }
        ZonedDateTime zonedDateTime3 = ZonedDateTime.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), 1, 0, 0, 0, 0, zonedDateTime.getZone()).minusNanos(1L);
        return new ExecutionTimeResult(zonedDateTime3, false);
    }

    private ExecutionTimeResult getPreviousPotentialDayOfMonth(ZonedDateTime zonedDateTime, TimeNode timeNode, int n2, int n3, int n4) {
        NearestValue nearestValue = timeNode.getPreviousValue(zonedDateTime.getDayOfMonth(), 0);
        if (nearestValue.getShifts() > 0) {
            ZonedDateTime zonedDateTime2 = ZonedDateTime.of(LocalDate.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), 1), MAX_SECONDS, zonedDateTime.getZone()).minusMonths(nearestValue.getShifts()).with(TemporalAdjusters.lastDayOfMonth());
            return new ExecutionTimeResult(zonedDateTime2, false);
        }
        return new ExecutionTimeResult(zonedDateTime.withDayOfMonth(nearestValue.getValue()).with(LocalTime.of(n2, n3, n4)).truncatedTo(ChronoUnit.SECONDS), false);
    }

    private ExecutionTimeResult getPreviousPotentialHour(ZonedDateTime zonedDateTime) {
        return SingleExecutionTime.getPreviousPotentialValue(zonedDateTime, this.hours, ChronoField.HOUR_OF_DAY);
    }

    private ExecutionTimeResult getPreviousPotentialMinute(ZonedDateTime zonedDateTime) {
        return SingleExecutionTime.getPreviousPotentialValue(zonedDateTime, this.minutes, ChronoField.MINUTE_OF_HOUR);
    }

    private ExecutionTimeResult getPreviousPotentialSecond(ZonedDateTime zonedDateTime) {
        return SingleExecutionTime.getPreviousPotentialValue(zonedDateTime, this.seconds, ChronoField.SECOND_OF_MINUTE);
    }

    private ZonedDateTime toEndOfPreviousMonth(ZonedDateTime zonedDateTime) {
        ZonedDateTime zonedDateTime2 = zonedDateTime.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
        int n2 = this.hours.getValues().get(this.hours.getValues().size() - 1);
        int n3 = this.minutes.getValues().get(this.minutes.getValues().size() - 1);
        int n4 = this.seconds.getValues().get(this.seconds.getValues().size() - 1);
        return ZonedDateTime.of(zonedDateTime2.getYear(), zonedDateTime2.getMonth().getValue(), zonedDateTime2.getDayOfMonth(), n2, n3, n4, 0, zonedDateTime2.getZone());
    }

    private Optional<TimeNode> generateDays(CronDefinition cronDefinition, ZonedDateTime zonedDateTime) {
        if (this.isGenerateDaysAsDoY(cronDefinition)) {
            return this.generateDayCandidatesUsingDoY(zonedDateTime);
        }
        if (cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK) != null && cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_MONTH) != null) {
            return this.generateDaysDoWAndDoMSupported(cronDefinition, zonedDateTime);
        }
        if (cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK) == null) {
            return Optional.of(this.generateDayCandidatesUsingDoM(zonedDateTime));
        }
        return Optional.of(this.generateDayCandidatesUsingDoW(zonedDateTime, ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue()));
    }

    private boolean isGenerateDaysAsDoY(CronDefinition cronDefinition) {
        if (!cronDefinition.containsFieldDefinition(CronFieldName.DAY_OF_YEAR)) {
            return false;
        }
        if (!cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_YEAR).getConstraints().getSpecialChars().contains((Object)SpecialChar.QUESTION_MARK)) {
            return true;
        }
        return !(this.daysOfYearCronField.getExpression() instanceof QuestionMark);
    }

    private Optional<TimeNode> generateDayCandidatesUsingDoY(ZonedDateTime zonedDateTime) {
        int n3 = zonedDateTime.getYear();
        int n5 = zonedDateTime.getMonthValue();
        LocalDate localDate = LocalDate.of(n3, 1, 1);
        int n6 = localDate.lengthOfYear();
        List<Integer> list = FieldValueGeneratorFactory.createDayOfYearValueGeneratorInstance(this.daysOfYearCronField, n3).generateCandidates(1, n6);
        int n7 = LocalDate.of(n3, n5, 1).getDayOfYear();
        int n8 = n5 == 12 ? LocalDate.of(n3, 12, 31).getDayOfYear() + 1 : LocalDate.of(n3, n5 + 1, 1).getDayOfYear();
        List list2 = list.stream().filter(n4 -> n4 >= n7 && n4 < n8).map(n2 -> LocalDate.ofYearDay(zonedDateTime.getYear(), n2).getDayOfMonth()).collect(Collectors.toList());
        return Optional.of(list2).filter(Predicates.not(List::isEmpty)).map(TimeNode::new);
    }

    private Optional<TimeNode> generateDaysDoWAndDoMSupported(CronDefinition cronDefinition, ZonedDateTime zonedDateTime) {
        boolean bl2 = cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK).getConstraints().getSpecialChars().contains((Object)SpecialChar.QUESTION_MARK);
        if (bl2) {
            List<Integer> list = this.generateDayCandidatesQuestionMarkSupportedUsingDoWAndDoM(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue());
            return Optional.of(list).filter(Predicates.not(List::isEmpty)).map(TimeNode::new);
        }
        List<Integer> list = this.generateDayCandidatesQuestionMarkNotSupportedUsingDoWAndDoM(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue());
        return Optional.of(list).filter(Predicates.not(List::isEmpty)).map(TimeNode::new);
    }

    @Override
    public Optional<Duration> timeToNextExecution(ZonedDateTime zonedDateTime) {
        Optional<ZonedDateTime> optional = this.nextExecution(zonedDateTime);
        return optional.map(zonedDateTime2 -> Duration.between(zonedDateTime, zonedDateTime2));
    }

    @Override
    public Optional<ZonedDateTime> lastExecution(ZonedDateTime zonedDateTime) {
        Preconditions.checkNotNull(zonedDateTime);
        try {
            ZonedDateTime zonedDateTime2 = this.previousClosestMatch(zonedDateTime);
            if (zonedDateTime2.equals(zonedDateTime)) {
                zonedDateTime2 = this.previousClosestMatch(zonedDateTime.minusSeconds(1L));
            }
            return Optional.of(zonedDateTime2);
        }
        catch (NoSuchValueException noSuchValueException) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<Duration> timeFromLastExecution(ZonedDateTime zonedDateTime) {
        return this.lastExecution(zonedDateTime).map(zonedDateTime2 -> Duration.between(zonedDateTime2, zonedDateTime));
    }

    @Override
    public boolean isMatch(ZonedDateTime zonedDateTime) {
        boolean bl2 = this.cronDefinition.containsFieldDefinition(CronFieldName.SECOND);
        zonedDateTime = bl2 ? zonedDateTime.truncatedTo(ChronoUnit.SECONDS) : zonedDateTime.truncatedTo(ChronoUnit.MINUTES);
        Optional<ZonedDateTime> optional = this.lastExecution(zonedDateTime);
        if (optional.isPresent()) {
            Optional<ZonedDateTime> optional2 = this.nextExecution(optional.get());
            if (optional2.isPresent()) {
                return optional2.get().equals(zonedDateTime);
            }
            boolean bl3 = false;
            try {
                bl3 = this.dateValuesInExpectedRanges(this.nextClosestMatch(zonedDateTime), zonedDateTime);
            }
            catch (NoSuchValueException noSuchValueException) {
                // empty catch block
            }
            try {
                bl3 = this.dateValuesInExpectedRanges(this.previousClosestMatch(zonedDateTime), zonedDateTime);
            }
            catch (NoSuchValueException noSuchValueException) {
                // empty catch block
            }
            return bl3;
        }
        return false;
    }

    private boolean dateValuesInExpectedRanges(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2) {
        boolean bl2 = true;
        if (this.cronDefinition.getFieldDefinition(CronFieldName.YEAR) != null) {
            boolean bl3 = bl2 = zonedDateTime.getYear() == zonedDateTime2.getYear();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.MONTH) != null) {
            boolean bl4 = bl2 = bl2 && zonedDateTime.getMonthValue() == zonedDateTime2.getMonthValue();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_MONTH) != null) {
            boolean bl5 = bl2 = bl2 && zonedDateTime.getDayOfMonth() == zonedDateTime2.getDayOfMonth();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK) != null) {
            boolean bl6 = bl2 = bl2 && zonedDateTime.getDayOfWeek().getValue() == zonedDateTime2.getDayOfWeek().getValue();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.HOUR) != null) {
            boolean bl7 = bl2 = bl2 && zonedDateTime.getHour() == zonedDateTime2.getHour();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.MINUTE) != null) {
            boolean bl8 = bl2 = bl2 && zonedDateTime.getMinute() == zonedDateTime2.getMinute();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.SECOND) != null) {
            bl2 = bl2 && zonedDateTime.getSecond() == zonedDateTime2.getSecond();
        }
        return bl2;
    }

    private List<Integer> generateDayCandidatesQuestionMarkNotSupportedUsingDoWAndDoM(int n2, int n3, WeekDay weekDay) {
        LocalDate localDate = LocalDate.of(n2, n3, 1);
        int n4 = localDate.lengthOfMonth();
        if (this.daysOfMonthCronField.getExpression() instanceof Always && this.daysOfWeekCronField.getExpression() instanceof Always) {
            return FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, n2, n3).generateCandidates(1, n4).stream().distinct().sorted().collect(Collectors.toList());
        }
        if (this.daysOfMonthCronField.getExpression() instanceof Always) {
            return FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, n2, n3, weekDay).generateCandidates(1, n4).stream().distinct().sorted().collect(Collectors.toList());
        }
        if (this.daysOfWeekCronField.getExpression() instanceof Always) {
            return FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, n2, n3).generateCandidates(1, n4).stream().distinct().sorted().collect(Collectors.toList());
        }
        List<Integer> list = FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, n2, n3, weekDay).generateCandidates(1, n4);
        List<Integer> list2 = FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, n2, n3).generateCandidates(1, n4);
        if (this.cronDefinition.isMatchDayOfWeekAndDayOfMonth()) {
            HashSet<Integer> hashSet = new HashSet<Integer>(list);
            return list2.stream().filter(hashSet::contains).distinct().sorted().collect(Collectors.toList());
        }
        return Stream.concat(list.stream(), list2.stream()).distinct().sorted().collect(Collectors.toList());
    }

    private List<Integer> generateDayCandidatesQuestionMarkSupportedUsingDoWAndDoM(int n2, int n3, WeekDay weekDay) {
        LocalDate localDate = LocalDate.of(n2, n3, 1);
        int n4 = localDate.lengthOfMonth();
        if (this.daysOfMonthCronField.getExpression() instanceof Always && this.daysOfWeekCronField.getExpression() instanceof Always) {
            return FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, n2, n3).generateCandidates(1, n4).stream().distinct().sorted().collect(Collectors.toList());
        }
        if (this.daysOfMonthCronField.getExpression() instanceof QuestionMark) {
            return FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, n2, n3, weekDay).generateCandidates(1, n4).stream().distinct().sorted().collect(Collectors.toList());
        }
        if (this.daysOfWeekCronField.getExpression() instanceof QuestionMark) {
            return FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, n2, n3).generateCandidates(1, n4).stream().distinct().sorted().collect(Collectors.toList());
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, n2, n3).generateCandidates(1, n4));
        HashSet<Integer> hashSet2 = new HashSet<Integer>(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, n2, n3, weekDay).generateCandidates(1, n4));
        hashSet.retainAll(hashSet2);
        return hashSet.stream().sorted().collect(Collectors.toList());
    }

    private TimeNode generateDayCandidatesUsingDoM(ZonedDateTime zonedDateTime) {
        LocalDate localDate = LocalDate.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), 1);
        int n2 = localDate.lengthOfMonth();
        List<Integer> list = FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, zonedDateTime.getYear(), zonedDateTime.getMonthValue()).generateCandidates(1, n2).stream().distinct().sorted().collect(Collectors.toList());
        return new TimeNode(list);
    }

    private TimeNode generateDayCandidatesUsingDoW(ZonedDateTime zonedDateTime, WeekDay weekDay) {
        LocalDate localDate = LocalDate.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), 1);
        int n2 = localDate.lengthOfMonth();
        List<Integer> list = FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, zonedDateTime.getYear(), zonedDateTime.getMonthValue(), weekDay).generateCandidates(1, n2).stream().distinct().sorted().collect(Collectors.toList());
        return new TimeNode(list);
    }

    private static final class ExecutionTimeResult {
        private final ZonedDateTime time;
        private final boolean isMatch;

        private ExecutionTimeResult(ZonedDateTime zonedDateTime, boolean bl2) {
            this.time = zonedDateTime;
            this.isMatch = bl2;
        }

        public ZonedDateTime getTime() {
            return this.time;
        }

        public boolean isMatch() {
            return this.isMatch;
        }

        public String toString() {
            return "ExecutionTimeResult{time=" + this.time + ", isMatch=" + this.isMatch + '}';
        }
    }
}

