/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.time.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.forseth11.easybackup.dependencies.cronutils.Function;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Always;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.And;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Between;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Every;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.On;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.AlwaysFieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.BetweenFieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.EveryFieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.FieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.NoSuchValueException;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.OnFieldValueGenerator;
import me.forseth11.easybackup.dependencies.sl4j.Logger;
import me.forseth11.easybackup.dependencies.sl4j.LoggerFactory;

class AndFieldValueGenerator
extends FieldValueGenerator {
    private static final Logger log = LoggerFactory.getLogger(AndFieldValueGenerator.class);

    public AndFieldValueGenerator(CronField cronField) {
        super(cronField);
    }

    @Override
    public int generateNextValue(int n2) {
        List<Integer> list = this.computeCandidates(fieldValueGenerator -> {
            try {
                return fieldValueGenerator.generateNextValue(n2);
            }
            catch (NoSuchValueException noSuchValueException) {
                return Integer.MIN_VALUE;
            }
        });
        if (list.isEmpty()) {
            throw new NoSuchValueException();
        }
        return list.get(0);
    }

    @Override
    public int generatePreviousValue(int n2) {
        List<Integer> list = this.computeCandidates(fieldValueGenerator -> {
            try {
                return fieldValueGenerator.generatePreviousValue(n2);
            }
            catch (NoSuchValueException noSuchValueException) {
                return Integer.MIN_VALUE;
            }
        });
        if (list.isEmpty()) {
            throw new NoSuchValueException();
        }
        return list.get(list.size() - 1);
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            int n4 = this.generateNextValue(n2);
            while (n4 < n3) {
                arrayList.add(n4);
                n4 = this.generateNextValue(n4);
            }
        }
        catch (NoSuchValueException noSuchValueException) {
            log.debug("Catched expected exception while generating candidates", noSuchValueException);
        }
        return arrayList;
    }

    @Override
    public boolean isMatch(int n2) {
        And and = (And)this.cronField.getExpression();
        boolean bl2 = false;
        for (FieldExpression fieldExpression : and.getExpressions()) {
            bl2 = bl2 || this.createCandidateGeneratorInstance(new CronField(this.cronField.getField(), fieldExpression, this.cronField.getConstraints())).isMatch(n2);
        }
        return bl2;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof And;
    }

    private List<Integer> computeCandidates(Function<FieldValueGenerator, Integer> function) {
        And and = (And)this.cronField.getExpression();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (FieldExpression object : and.getExpressions()) {
            arrayList.add(function.apply(this.createCandidateGeneratorInstance(new CronField(this.cronField.getField(), object, this.cronField.getConstraints()))));
        }
        ArrayList arrayList2 = new ArrayList();
        for (Integer n2 : arrayList) {
            if (n2 < 0) continue;
            arrayList2.add(n2);
        }
        Collections.sort(arrayList2);
        return arrayList2;
    }

    private FieldValueGenerator createCandidateGeneratorInstance(CronField cronField) {
        FieldExpression fieldExpression = cronField.getExpression();
        if (fieldExpression instanceof Always) {
            return new AlwaysFieldValueGenerator(cronField);
        }
        if (fieldExpression instanceof Between) {
            return new BetweenFieldValueGenerator(cronField);
        }
        if (fieldExpression instanceof Every) {
            return new EveryFieldValueGenerator(cronField);
        }
        if (fieldExpression instanceof On) {
            return new OnFieldValueGenerator(cronField);
        }
        throw new IllegalArgumentException(String.format("FieldExpression %s not supported!", fieldExpression.getClass()));
    }
}

