/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.time.generator;

import java.util.ArrayList;
import java.util.List;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Between;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Every;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.On;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.BetweenFieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.FieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.NoSuchValueException;
import me.forseth11.easybackup.dependencies.cronutils.utils.VisibleForTesting;

class EveryFieldValueGenerator
extends FieldValueGenerator {
    protected final int from;
    protected final int to;

    public EveryFieldValueGenerator(CronField cronField) {
        super(cronField);
        Every every = (Every)cronField.getExpression();
        FieldExpression fieldExpression = every.getExpression();
        if (fieldExpression instanceof Between) {
            Between between = (Between)fieldExpression;
            this.from = Math.max(cronField.getConstraints().getStartRange(), BetweenFieldValueGenerator.map(between.getFrom()));
            this.to = Math.min(cronField.getConstraints().getEndRange(), BetweenFieldValueGenerator.map(between.getTo()));
        } else {
            this.from = cronField.getConstraints().getStartRange();
            this.to = cronField.getConstraints().getEndRange();
        }
    }

    @Override
    public int generateNextValue(int n2) {
        if (n2 >= this.to) {
            throw new NoSuchValueException();
        }
        Every every = (Every)this.cronField.getExpression();
        int n3 = this.getNext(n2, every);
        if (n3 < this.from) {
            return this.from;
        }
        if (n3 > this.to) {
            throw new NoSuchValueException();
        }
        return n3;
    }

    private int getNext(int n2, Every every) {
        int n3 = this.offset();
        if (n2 >= n3) {
            int n4 = n2 - n3;
            int n5 = every.getPeriod().getValue();
            int n6 = n4 % n5;
            return n2 + (n5 - n6);
        }
        return n3;
    }

    @Override
    public int generatePreviousValue(int n2) {
        Every every = (Every)this.cronField.getExpression();
        int n3 = every.getPeriod().getValue();
        int n4 = n2 % n3;
        if (n4 == 0) {
            return n2 - n3;
        }
        return n2 - n4;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            int n4 = this.offset();
            if (n2 != n4) {
                arrayList.add(n4);
            }
            int n5 = this.generateNextValue(n2);
            while (n5 < n3) {
                if (n5 != n4) {
                    arrayList.add(n5);
                }
                n5 = this.generateNextValue(n5);
            }
        }
        catch (NoSuchValueException noSuchValueException) {
            // empty catch block
        }
        return arrayList;
    }

    @Override
    public boolean isMatch(int n2) {
        Every every = (Every)this.cronField.getExpression();
        int n3 = this.offset();
        return n2 >= n3 && (n2 - n3) % every.getPeriod().getValue() == 0 && n2 >= this.from && n2 <= this.to;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof Every;
    }

    @VisibleForTesting
    int offset() {
        FieldExpression fieldExpression = ((Every)this.cronField.getExpression()).getExpression();
        if (fieldExpression instanceof On) {
            return ((On)fieldExpression).getTime().getValue();
        }
        return this.from;
    }
}

