/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.time.generator;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

public abstract class FieldValueGenerator {
    protected static final int NO_VALUE = Integer.MIN_VALUE;
    protected CronField cronField;

    public FieldValueGenerator(CronField cronField) {
        this.cronField = Preconditions.checkNotNull(cronField, "CronField must not be null");
        Preconditions.checkArgument(this.matchesFieldExpressionClass(cronField.getExpression()), "FieldExpression does not match required class");
    }

    public abstract int generateNextValue(int var1);

    public abstract int generatePreviousValue(int var1);

    protected abstract List<Integer> generateCandidatesNotIncludingIntervalExtremes(int var1, int var2);

    public abstract boolean isMatch(int var1);

    public final List<Integer> generateCandidates(int n2, int n3) {
        List<Integer> list = this.generateCandidatesNotIncludingIntervalExtremes(n2, n3);
        if (this.isMatch(n2)) {
            list.add(n2);
        }
        if (this.isMatch(n3)) {
            list.add(n3);
        }
        list = new LinkedList<Integer>(new HashSet<Integer>(list));
        Collections.sort(list);
        return list;
    }

    protected abstract boolean matchesFieldExpressionClass(FieldExpression var1);
}

