/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.time.generator;

import me.forseth11.easybackup.dependencies.cronutils.mapper.WeekDay;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Always;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.And;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Between;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Every;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.On;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.SpecialChar;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.AlwaysFieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.AndDayOfWeekValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.AndFieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.BetweenDayOfWeekValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.BetweenFieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.EveryDayOfWeekValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.EveryFieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.FieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.NullFieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.OnDayOfMonthValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.OnDayOfWeekValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.OnFieldValueGenerator;

public class FieldValueGeneratorFactory {
    private FieldValueGeneratorFactory() {
    }

    public static FieldValueGenerator forCronField(CronField cronField) {
        FieldExpression fieldExpression = cronField.getExpression();
        if (fieldExpression instanceof Always) {
            return new AlwaysFieldValueGenerator(cronField);
        }
        if (fieldExpression instanceof And) {
            return new AndFieldValueGenerator(cronField);
        }
        if (fieldExpression instanceof Between) {
            return new BetweenFieldValueGenerator(cronField);
        }
        if (fieldExpression instanceof Every) {
            return new EveryFieldValueGenerator(cronField);
        }
        if (fieldExpression instanceof On) {
            On on = (On)fieldExpression;
            if (!SpecialChar.NONE.equals((Object)on.getSpecialChar().getValue())) {
                throw new IllegalArgumentException(String.format("Cannot create instance for On instance with %s value", on.getSpecialChar()));
            }
            return new OnFieldValueGenerator(cronField);
        }
        return new NullFieldValueGenerator(cronField);
    }

    public static FieldValueGenerator createDayOfYearValueGeneratorInstance(CronField cronField, int n2) {
        return FieldValueGeneratorFactory.forCronField(cronField);
    }

    public static FieldValueGenerator createDayOfMonthValueGeneratorInstance(CronField cronField, int n2, int n3) {
        On on;
        FieldExpression fieldExpression = cronField.getExpression();
        if (fieldExpression instanceof On && !SpecialChar.NONE.equals((Object)(on = (On)fieldExpression).getSpecialChar().getValue())) {
            return new OnDayOfMonthValueGenerator(cronField, n2, n3);
        }
        return FieldValueGeneratorFactory.forCronField(cronField);
    }

    public static FieldValueGenerator createDayOfWeekValueGeneratorInstance(CronField cronField, int n2, int n3, WeekDay weekDay) {
        FieldExpression fieldExpression = cronField.getExpression();
        if (fieldExpression instanceof On) {
            return new OnDayOfWeekValueGenerator(cronField, n2, n3, weekDay);
        }
        if (fieldExpression instanceof Between) {
            return new BetweenDayOfWeekValueGenerator(cronField, n2, n3, weekDay);
        }
        if (fieldExpression instanceof And) {
            return new AndDayOfWeekValueGenerator(cronField, n2, n3, weekDay);
        }
        if (fieldExpression instanceof Every) {
            return new EveryDayOfWeekValueGenerator(cronField, n2, n3, weekDay);
        }
        return FieldValueGeneratorFactory.forCronField(cronField);
    }

    public static FieldValueGenerator createYearValueGeneratorInstance(CronField cronField) {
        return FieldValueGeneratorFactory.forCronField(cronField);
    }
}

