/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.validation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import me.forseth11.easybackup.dependencies.cronutils.model.CronType;
import me.forseth11.easybackup.dependencies.cronutils.model.definition.CronDefinition;
import me.forseth11.easybackup.dependencies.cronutils.model.definition.CronDefinitionBuilder;
import me.forseth11.easybackup.dependencies.cronutils.parser.CronParser;
import me.forseth11.easybackup.dependencies.cronutils.validation.Cron;

public class CronValidator
implements ConstraintValidator<Cron, String> {
    private CronType type;

    public void initialize(Cron cron) {
        this.type = cron.type();
    }

    public boolean isValid(String string, ConstraintValidatorContext constraintValidatorContext) {
        if (string == null) {
            return true;
        }
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor(this.type);
        CronParser cronParser = new CronParser(cronDefinition);
        try {
            cronParser.parse(string).validate();
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate(illegalArgumentException.getMessage()).addConstraintViolation();
            return false;
        }
    }
}

