/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.expiringmap;

import java.util.concurrent.TimeUnit;
import me.forseth11.easybackup.dependencies.expiringmap.ExpirationPolicy;

public final class ExpiringValue<V> {
    private static final long UNSET_DURATION = -1L;
    private final V value;
    private final ExpirationPolicy expirationPolicy;
    private final long duration;
    private final TimeUnit timeUnit;

    public ExpiringValue(V v2) {
        this(v2, -1L, null, null);
    }

    public ExpiringValue(V v2, ExpirationPolicy expirationPolicy) {
        this(v2, -1L, null, expirationPolicy);
    }

    public ExpiringValue(V v2, long l2, TimeUnit timeUnit) {
        this(v2, l2, timeUnit, null);
        if (timeUnit == null) {
            throw new NullPointerException();
        }
    }

    public ExpiringValue(V v2, ExpirationPolicy expirationPolicy, long l2, TimeUnit timeUnit) {
        this(v2, l2, timeUnit, expirationPolicy);
        if (timeUnit == null) {
            throw new NullPointerException();
        }
    }

    private ExpiringValue(V v2, long l2, TimeUnit timeUnit, ExpirationPolicy expirationPolicy) {
        this.value = v2;
        this.expirationPolicy = expirationPolicy;
        this.duration = l2;
        this.timeUnit = timeUnit;
    }

    public V getValue() {
        return this.value;
    }

    public ExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) return false;
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpiringValue expiringValue = (ExpiringValue)object;
        if (this.value != null) {
            if (!this.value.equals(expiringValue.value)) {
                return false;
            }
        } else if (expiringValue.value != null) return false;
        if (this.expirationPolicy != expiringValue.expirationPolicy) return false;
        if (this.duration != expiringValue.duration) return false;
        if (this.timeUnit != expiringValue.timeUnit) return false;
        return true;
    }

    public String toString() {
        return "ExpiringValue{value=" + this.value + ", expirationPolicy=" + (Object)((Object)this.expirationPolicy) + ", duration=" + this.duration + ", timeUnit=" + (Object)((Object)this.timeUnit) + '}';
    }
}

