/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.gson;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import me.forseth11.easybackup.dependencies.gson.JsonElement;
import me.forseth11.easybackup.dependencies.gson.JsonIOException;
import me.forseth11.easybackup.dependencies.gson.JsonParseException;
import me.forseth11.easybackup.dependencies.gson.JsonSyntaxException;
import me.forseth11.easybackup.dependencies.gson.internal.Streams;
import me.forseth11.easybackup.dependencies.gson.stream.JsonReader;
import me.forseth11.easybackup.dependencies.gson.stream.JsonToken;
import me.forseth11.easybackup.dependencies.gson.stream.MalformedJsonException;

public final class JsonParser {
    @Deprecated
    public JsonParser() {
    }

    public static JsonElement parseString(String string) {
        return JsonParser.parseReader(new StringReader(string));
    }

    public static JsonElement parseReader(Reader reader) {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            JsonElement jsonElement = JsonParser.parseReader(jsonReader);
            if (!jsonElement.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return jsonElement;
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonSyntaxException(numberFormatException);
        }
    }

    public static JsonElement parseReader(JsonReader jsonReader) {
        boolean bl2 = jsonReader.isLenient();
        jsonReader.setLenient(true);
        try {
            JsonElement jsonElement = Streams.parse(jsonReader);
            return jsonElement;
        }
        catch (StackOverflowError stackOverflowError) {
            throw new JsonParseException("Failed parsing JSON source: " + jsonReader + " to Json", stackOverflowError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new JsonParseException("Failed parsing JSON source: " + jsonReader + " to Json", outOfMemoryError);
        }
        finally {
            jsonReader.setLenient(bl2);
        }
    }

    @Deprecated
    public JsonElement parse(String string) {
        return JsonParser.parseString(string);
    }

    @Deprecated
    public JsonElement parse(Reader reader) {
        return JsonParser.parseReader(reader);
    }

    @Deprecated
    public JsonElement parse(JsonReader jsonReader) {
        return JsonParser.parseReader(jsonReader);
    }
}

