/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.gson.internal;

import java.io.EOFException;
import java.io.IOException;
import java.io.Writer;
import me.forseth11.easybackup.dependencies.gson.JsonElement;
import me.forseth11.easybackup.dependencies.gson.JsonIOException;
import me.forseth11.easybackup.dependencies.gson.JsonNull;
import me.forseth11.easybackup.dependencies.gson.JsonSyntaxException;
import me.forseth11.easybackup.dependencies.gson.internal.bind.TypeAdapters;
import me.forseth11.easybackup.dependencies.gson.stream.JsonReader;
import me.forseth11.easybackup.dependencies.gson.stream.JsonWriter;
import me.forseth11.easybackup.dependencies.gson.stream.MalformedJsonException;

public final class Streams {
    private Streams() {
        throw new UnsupportedOperationException();
    }

    public static JsonElement parse(JsonReader jsonReader) {
        boolean bl2 = true;
        try {
            jsonReader.peek();
            bl2 = false;
            return TypeAdapters.JSON_ELEMENT.read(jsonReader);
        }
        catch (EOFException eOFException) {
            if (bl2) {
                return JsonNull.INSTANCE;
            }
            throw new JsonSyntaxException(eOFException);
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonSyntaxException(numberFormatException);
        }
    }

    public static void write(JsonElement jsonElement, JsonWriter jsonWriter) {
        TypeAdapters.JSON_ELEMENT.write(jsonWriter, jsonElement);
    }

    public static Writer writerForAppendable(Appendable appendable) {
        return appendable instanceof Writer ? (Writer)appendable : new AppendableWriter(appendable);
    }

    private static final class AppendableWriter
    extends Writer {
        private final Appendable appendable;
        private final CurrentWrite currentWrite = new CurrentWrite();

        AppendableWriter(Appendable appendable) {
            this.appendable = appendable;
        }

        @Override
        public void write(char[] cArray, int n2, int n3) {
            this.currentWrite.chars = cArray;
            this.appendable.append(this.currentWrite, n2, n2 + n3);
        }

        @Override
        public void write(int n2) {
            this.appendable.append((char)n2);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        static class CurrentWrite
        implements CharSequence {
            char[] chars;

            CurrentWrite() {
            }

            @Override
            public int length() {
                return this.chars.length;
            }

            @Override
            public char charAt(int n2) {
                return this.chars[n2];
            }

            @Override
            public CharSequence subSequence(int n2, int n3) {
                return new String(this.chars, n2, n3 - n2);
            }
        }
    }
}

