/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.gson.internal.bind;

import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import me.forseth11.easybackup.dependencies.gson.Gson;
import me.forseth11.easybackup.dependencies.gson.JsonSyntaxException;
import me.forseth11.easybackup.dependencies.gson.TypeAdapter;
import me.forseth11.easybackup.dependencies.gson.TypeAdapterFactory;
import me.forseth11.easybackup.dependencies.gson.reflect.TypeToken;
import me.forseth11.easybackup.dependencies.gson.stream.JsonReader;
import me.forseth11.easybackup.dependencies.gson.stream.JsonToken;
import me.forseth11.easybackup.dependencies.gson.stream.JsonWriter;

public final class SqlDateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Date.class ? new SqlDateTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("MMM d, yyyy");

    @Override
    public synchronized Date read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        try {
            long l2 = this.format.parse(jsonReader.nextString()).getTime();
            return new Date(l2);
        }
        catch (ParseException parseException) {
            throw new JsonSyntaxException(parseException);
        }
    }

    @Override
    public synchronized void write(JsonWriter jsonWriter, Date date) {
        jsonWriter.value(date == null ? null : this.format.format(date));
    }
}

