/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderReader;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderUtil;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderWriter;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.NumberedSplitRandomAccessFile;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.ZipInputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.UnzipParameters;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip4jConfig;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipModel;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipParameters;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.RandomAccessFileMode;
import me.forseth11.easybackup.dependencies.zip4j.progress.ProgressMonitor;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AddFilesToZipTask;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AddFolderToZipTask;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AddStreamToZipTask;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AsyncZipTask;
import me.forseth11.easybackup.dependencies.zip4j.tasks.ExtractAllFilesTask;
import me.forseth11.easybackup.dependencies.zip4j.tasks.ExtractFileTask;
import me.forseth11.easybackup.dependencies.zip4j.tasks.MergeSplitZipFileTask;
import me.forseth11.easybackup.dependencies.zip4j.tasks.RemoveFilesFromZipTask;
import me.forseth11.easybackup.dependencies.zip4j.tasks.RenameFilesTask;
import me.forseth11.easybackup.dependencies.zip4j.tasks.SetCommentTask;
import me.forseth11.easybackup.dependencies.zip4j.util.FileUtils;
import me.forseth11.easybackup.dependencies.zip4j.util.InternalZipConstants;
import me.forseth11.easybackup.dependencies.zip4j.util.RawIO;
import me.forseth11.easybackup.dependencies.zip4j.util.UnzipUtil;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;

public class ZipFile {
    private File zipFile;
    private ZipModel zipModel;
    private boolean isEncrypted;
    private ProgressMonitor progressMonitor;
    private boolean runInThread;
    private char[] password;
    private HeaderWriter headerWriter = new HeaderWriter();
    private Charset charset = null;
    private ThreadFactory threadFactory;
    private ExecutorService executorService;
    private int bufferSize = 4096;

    public ZipFile(String string) {
        this(new File(string), null);
    }

    public ZipFile(String string, char[] cArray) {
        this(new File(string), cArray);
    }

    public ZipFile(File file) {
        this(file, null);
    }

    public ZipFile(File file, char[] cArray) {
        if (file == null) {
            throw new IllegalArgumentException("input zip file parameter is null");
        }
        this.zipFile = file;
        this.password = cArray;
        this.runInThread = false;
        this.progressMonitor = new ProgressMonitor();
    }

    public void createSplitZipFile(List<File> list, ZipParameters zipParameters, boolean bl2, long l2) {
        if (this.zipFile.exists()) {
            throw new ZipException("zip file: " + this.zipFile + " already exists. To add files to existing zip file use addFile method");
        }
        if (list == null || list.size() == 0) {
            throw new ZipException("input file List is null, cannot create zip file");
        }
        this.createNewZipModel();
        this.zipModel.setSplitArchive(bl2);
        this.zipModel.setSplitLength(l2);
        new AddFilesToZipTask(this.zipModel, this.password, this.headerWriter, this.buildAsyncParameters()).execute(new AddFilesToZipTask.AddFilesToZipTaskParameters(list, zipParameters, this.buildConfig()));
    }

    public void createSplitZipFileFromFolder(File file, ZipParameters zipParameters, boolean bl2, long l2) {
        if (file == null) {
            throw new ZipException("folderToAdd is null, cannot create zip file from folder");
        }
        if (zipParameters == null) {
            throw new ZipException("input parameters are null, cannot create zip file from folder");
        }
        if (this.zipFile.exists()) {
            throw new ZipException("zip file: " + this.zipFile + " already exists. To add files to existing zip file use addFolder method");
        }
        this.createNewZipModel();
        this.zipModel.setSplitArchive(bl2);
        if (bl2) {
            this.zipModel.setSplitLength(l2);
        }
        this.addFolder(file, zipParameters, false);
    }

    public void addFile(String string) {
        this.addFile(string, new ZipParameters());
    }

    public void addFile(String string, ZipParameters zipParameters) {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("file to add is null or empty");
        }
        this.addFiles(Collections.singletonList(new File(string)), zipParameters);
    }

    public void addFile(File file) {
        this.addFiles(Collections.singletonList(file), new ZipParameters());
    }

    public void addFile(File file, ZipParameters zipParameters) {
        this.addFiles(Collections.singletonList(file), zipParameters);
    }

    public void addFiles(List<File> list) {
        this.addFiles(list, new ZipParameters());
    }

    public void addFiles(List<File> list, ZipParameters zipParameters) {
        if (list == null || list.size() == 0) {
            throw new ZipException("input file List is null or empty");
        }
        if (zipParameters == null) {
            throw new ZipException("input parameters are null");
        }
        if (this.progressMonitor.getState() == ProgressMonitor.State.BUSY) {
            throw new ZipException("invalid operation - Zip4j is in busy state");
        }
        this.readZipInfo();
        if (this.zipModel == null) {
            throw new ZipException("internal error: zip model is null");
        }
        if (this.zipFile.exists() && this.zipModel.isSplitArchive()) {
            throw new ZipException("Zip file already exists. Zip file format does not allow updating split/spanned files");
        }
        new AddFilesToZipTask(this.zipModel, this.password, this.headerWriter, this.buildAsyncParameters()).execute(new AddFilesToZipTask.AddFilesToZipTaskParameters(list, zipParameters, this.buildConfig()));
    }

    public void addFolder(File file) {
        this.addFolder(file, new ZipParameters());
    }

    public void addFolder(File file, ZipParameters zipParameters) {
        if (file == null) {
            throw new ZipException("input path is null, cannot add folder to zip file");
        }
        if (!file.exists()) {
            throw new ZipException("folder does not exist");
        }
        if (!file.isDirectory()) {
            throw new ZipException("input folder is not a directory");
        }
        if (!file.canRead()) {
            throw new ZipException("cannot read input folder");
        }
        if (zipParameters == null) {
            throw new ZipException("input parameters are null, cannot add folder to zip file");
        }
        this.addFolder(file, zipParameters, true);
    }

    private void addFolder(File file, ZipParameters zipParameters, boolean bl2) {
        this.readZipInfo();
        if (this.zipModel == null) {
            throw new ZipException("internal error: zip model is null");
        }
        if (bl2 && this.zipModel.isSplitArchive()) {
            throw new ZipException("This is a split archive. Zip file format does not allow updating split/spanned files");
        }
        new AddFolderToZipTask(this.zipModel, this.password, this.headerWriter, this.buildAsyncParameters()).execute(new AddFolderToZipTask.AddFolderToZipTaskParameters(file, zipParameters, this.buildConfig()));
    }

    public void addStream(InputStream inputStream, ZipParameters zipParameters) {
        if (inputStream == null) {
            throw new ZipException("inputstream is null, cannot add file to zip");
        }
        if (zipParameters == null) {
            throw new ZipException("zip parameters are null");
        }
        this.setRunInThread(false);
        this.readZipInfo();
        if (this.zipModel == null) {
            throw new ZipException("internal error: zip model is null");
        }
        if (this.zipFile.exists() && this.zipModel.isSplitArchive()) {
            throw new ZipException("Zip file already exists. Zip file format does not allow updating split/spanned files");
        }
        new AddStreamToZipTask(this.zipModel, this.password, this.headerWriter, this.buildAsyncParameters()).execute(new AddStreamToZipTask.AddStreamToZipTaskParameters(inputStream, zipParameters, this.buildConfig()));
    }

    public void extractAll(String string) {
        this.extractAll(string, new UnzipParameters());
    }

    public void extractAll(String string, UnzipParameters unzipParameters) {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("output path is null or invalid");
        }
        if (!Zip4jUtil.createDirectoryIfNotExists(new File(string))) {
            throw new ZipException("invalid output path");
        }
        if (this.zipModel == null) {
            this.readZipInfo();
        }
        if (this.zipModel == null) {
            throw new ZipException("Internal error occurred when extracting zip file");
        }
        if (this.progressMonitor.getState() == ProgressMonitor.State.BUSY) {
            throw new ZipException("invalid operation - Zip4j is in busy state");
        }
        new ExtractAllFilesTask(this.zipModel, this.password, unzipParameters, this.buildAsyncParameters()).execute(new ExtractAllFilesTask.ExtractAllFilesTaskParameters(string, this.buildConfig()));
    }

    public void extractFile(FileHeader fileHeader, String string) {
        this.extractFile(fileHeader, string, null, new UnzipParameters());
    }

    public void extractFile(FileHeader fileHeader, String string, UnzipParameters unzipParameters) {
        this.extractFile(fileHeader, string, null, unzipParameters);
    }

    public void extractFile(String string, String string2) {
        this.extractFile(string, string2, null, new UnzipParameters());
    }

    public void extractFile(String string, String string2, UnzipParameters unzipParameters) {
        this.extractFile(string, string2, null, unzipParameters);
    }

    public void extractFile(String string, String string2, String string3) {
        this.extractFile(string, string2, string3, new UnzipParameters());
    }

    public void extractFile(FileHeader fileHeader, String string, String string2) {
        this.extractFile(fileHeader, string, string2, new UnzipParameters());
    }

    public void extractFile(String string, String string2, String string3, UnzipParameters unzipParameters) {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("file to extract is null or empty, cannot extract file");
        }
        this.readZipInfo();
        FileHeader fileHeader = HeaderUtil.getFileHeader(this.zipModel, string);
        if (fileHeader == null) {
            throw new ZipException("No file found with name " + string + " in zip file", ZipException.Type.FILE_NOT_FOUND);
        }
        this.extractFile(fileHeader, string2, string3, unzipParameters);
    }

    public void extractFile(FileHeader fileHeader, String string, String string2, UnzipParameters unzipParameters) {
        if (fileHeader == null) {
            throw new ZipException("input file header is null, cannot extract file");
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("destination path is empty or null, cannot extract file");
        }
        if (this.progressMonitor.getState() == ProgressMonitor.State.BUSY) {
            throw new ZipException("invalid operation - Zip4j is in busy state");
        }
        if (unzipParameters == null) {
            unzipParameters = new UnzipParameters();
        }
        this.readZipInfo();
        new ExtractFileTask(this.zipModel, this.password, unzipParameters, this.buildAsyncParameters()).execute(new ExtractFileTask.ExtractFileTaskParameters(string, fileHeader, string2, this.buildConfig()));
    }

    public List<FileHeader> getFileHeaders() {
        this.readZipInfo();
        if (this.zipModel == null || this.zipModel.getCentralDirectory() == null) {
            return Collections.emptyList();
        }
        return this.zipModel.getCentralDirectory().getFileHeaders();
    }

    public FileHeader getFileHeader(String string) {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("input file name is emtpy or null, cannot get FileHeader");
        }
        this.readZipInfo();
        if (this.zipModel == null || this.zipModel.getCentralDirectory() == null) {
            return null;
        }
        return HeaderUtil.getFileHeader(this.zipModel, string);
    }

    public boolean isEncrypted() {
        if (this.zipModel == null) {
            this.readZipInfo();
            if (this.zipModel == null) {
                throw new ZipException("Zip Model is null");
            }
        }
        if (this.zipModel.getCentralDirectory() == null || this.zipModel.getCentralDirectory().getFileHeaders() == null) {
            throw new ZipException("invalid zip file");
        }
        for (FileHeader fileHeader : this.zipModel.getCentralDirectory().getFileHeaders()) {
            if (fileHeader == null || !fileHeader.isEncrypted()) continue;
            this.isEncrypted = true;
            break;
        }
        return this.isEncrypted;
    }

    public boolean isSplitArchive() {
        if (this.zipModel == null) {
            this.readZipInfo();
            if (this.zipModel == null) {
                throw new ZipException("Zip Model is null");
            }
        }
        return this.zipModel.isSplitArchive();
    }

    public void removeFile(FileHeader fileHeader) {
        if (fileHeader == null) {
            throw new ZipException("input file header is null, cannot remove file");
        }
        this.removeFile(fileHeader.getFileName());
    }

    public void removeFile(String string) {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("file name is empty or null, cannot remove file");
        }
        this.removeFiles(Collections.singletonList(string));
    }

    public void removeFiles(List<String> list) {
        if (list == null) {
            throw new ZipException("fileNames list is null");
        }
        if (list.isEmpty()) {
            return;
        }
        if (this.zipModel == null) {
            this.readZipInfo();
        }
        if (this.zipModel.isSplitArchive()) {
            throw new ZipException("Zip file format does not allow updating split/spanned files");
        }
        new RemoveFilesFromZipTask(this.zipModel, this.headerWriter, this.buildAsyncParameters()).execute(new RemoveFilesFromZipTask.RemoveFilesFromZipTaskParameters(list, this.buildConfig()));
    }

    public void renameFile(FileHeader fileHeader, String string) {
        if (fileHeader == null) {
            throw new ZipException("File header is null");
        }
        this.renameFile(fileHeader.getFileName(), string);
    }

    public void renameFile(String string, String string2) {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("file name to be changed is null or empty");
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
            throw new ZipException("newFileName is null or empty");
        }
        this.renameFiles(Collections.singletonMap(string, string2));
    }

    public void renameFiles(Map<String, String> map) {
        if (map == null) {
            throw new ZipException("fileNamesMap is null");
        }
        if (map.size() == 0) {
            return;
        }
        this.readZipInfo();
        if (this.zipModel.isSplitArchive()) {
            throw new ZipException("Zip file format does not allow updating split/spanned files");
        }
        AsyncZipTask.AsyncTaskParameters asyncTaskParameters = this.buildAsyncParameters();
        new RenameFilesTask(this.zipModel, this.headerWriter, new RawIO(), asyncTaskParameters).execute(new RenameFilesTask.RenameFilesTaskParameters(map, this.buildConfig()));
    }

    public void mergeSplitFiles(File file) {
        if (file == null) {
            throw new ZipException("outputZipFile is null, cannot merge split files");
        }
        if (file.exists()) {
            throw new ZipException("output Zip File already exists");
        }
        this.readZipInfo();
        if (this.zipModel == null) {
            throw new ZipException("zip model is null, corrupt zip file?");
        }
        new MergeSplitZipFileTask(this.zipModel, this.buildAsyncParameters()).execute(new MergeSplitZipFileTask.MergeSplitZipFileTaskParameters(file, this.buildConfig()));
    }

    public void setComment(String string) {
        if (string == null) {
            throw new ZipException("input comment is null, cannot update zip file");
        }
        if (!this.zipFile.exists()) {
            throw new ZipException("zip file does not exist, cannot set comment for zip file");
        }
        this.readZipInfo();
        if (this.zipModel == null) {
            throw new ZipException("zipModel is null, cannot update zip file");
        }
        if (this.zipModel.getEndOfCentralDirectoryRecord() == null) {
            throw new ZipException("end of central directory is null, cannot set comment");
        }
        new SetCommentTask(this.zipModel, this.buildAsyncParameters()).execute(new SetCommentTask.SetCommentTaskTaskParameters(string, this.buildConfig()));
    }

    public String getComment() {
        if (!this.zipFile.exists()) {
            throw new ZipException("zip file does not exist, cannot read comment");
        }
        this.readZipInfo();
        if (this.zipModel == null) {
            throw new ZipException("zip model is null, cannot read comment");
        }
        if (this.zipModel.getEndOfCentralDirectoryRecord() == null) {
            throw new ZipException("end of central directory record is null, cannot read comment");
        }
        return this.zipModel.getEndOfCentralDirectoryRecord().getComment();
    }

    public ZipInputStream getInputStream(FileHeader fileHeader) {
        if (fileHeader == null) {
            throw new ZipException("FileHeader is null, cannot get InputStream");
        }
        this.readZipInfo();
        if (this.zipModel == null) {
            throw new ZipException("zip model is null, cannot get inputstream");
        }
        return UnzipUtil.createZipInputStream(this.zipModel, fileHeader, this.password);
    }

    public boolean isValidZipFile() {
        if (!this.zipFile.exists()) {
            return false;
        }
        try {
            this.readZipInfo();
            return !this.zipModel.isSplitArchive() || this.verifyAllSplitFilesOfZipExists(this.getSplitZipFiles());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public List<File> getSplitZipFiles() {
        this.readZipInfo();
        return FileUtils.getSplitZipFiles(this.zipModel);
    }

    public void setPassword(char[] cArray) {
        this.password = cArray;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n2) {
        if (n2 < 512) {
            throw new IllegalArgumentException("Buffer size cannot be less than 512 bytes");
        }
        this.bufferSize = n2;
    }

    private void readZipInfo() {
        if (this.zipModel != null) {
            return;
        }
        if (!this.zipFile.exists()) {
            this.createNewZipModel();
            return;
        }
        if (!this.zipFile.canRead()) {
            throw new ZipException("no read access for the input zip file");
        }
        try (RandomAccessFile randomAccessFile = this.initializeRandomAccessFileForHeaderReading();){
            HeaderReader headerReader = new HeaderReader();
            this.zipModel = headerReader.readAllHeaders(randomAccessFile, this.buildConfig());
            this.zipModel.setZipFile(this.zipFile);
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
    }

    private void createNewZipModel() {
        this.zipModel = new ZipModel();
        this.zipModel.setZipFile(this.zipFile);
    }

    private RandomAccessFile initializeRandomAccessFileForHeaderReading() {
        if (FileUtils.isNumberedSplitFile(this.zipFile)) {
            File[] fileArray = FileUtils.getAllSortedNumberedSplitFiles(this.zipFile);
            NumberedSplitRandomAccessFile numberedSplitRandomAccessFile = new NumberedSplitRandomAccessFile(this.zipFile, RandomAccessFileMode.READ.getValue(), fileArray);
            numberedSplitRandomAccessFile.openLastSplitFileForReading();
            return numberedSplitRandomAccessFile;
        }
        return new RandomAccessFile(this.zipFile, RandomAccessFileMode.READ.getValue());
    }

    private AsyncZipTask.AsyncTaskParameters buildAsyncParameters() {
        if (this.runInThread) {
            if (this.threadFactory == null) {
                this.threadFactory = Executors.defaultThreadFactory();
            }
            this.executorService = Executors.newSingleThreadExecutor(this.threadFactory);
        }
        return new AsyncZipTask.AsyncTaskParameters(this.executorService, this.runInThread, this.progressMonitor);
    }

    private boolean verifyAllSplitFilesOfZipExists(List<File> list) {
        for (File file : list) {
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public boolean isRunInThread() {
        return this.runInThread;
    }

    public void setRunInThread(boolean bl2) {
        this.runInThread = bl2;
    }

    public File getFile() {
        return this.zipFile;
    }

    public Charset getCharset() {
        if (this.charset == null) {
            return InternalZipConstants.CHARSET_UTF_8;
        }
        return this.charset;
    }

    public void setCharset(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset cannot be null");
        }
        this.charset = charset;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public String toString() {
        return this.zipFile.toString();
    }

    private Zip4jConfig buildConfig() {
        return new Zip4jConfig(this.charset, this.bufferSize);
    }
}

