/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.crypto;

import me.forseth11.easybackup.dependencies.zip4j.crypto.PBKDF2.MacBasedPRF;
import me.forseth11.easybackup.dependencies.zip4j.crypto.PBKDF2.PBKDF2Engine;
import me.forseth11.easybackup.dependencies.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import me.forseth11.easybackup.dependencies.zip4j.crypto.engine.AESEngine;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.AesKeyStrength;

public class AesCipherUtil {
    private static final int START_INDEX = 0;

    public static byte[] derivePasswordBasedKey(byte[] byArray, char[] cArray, AesKeyStrength aesKeyStrength) {
        int n2;
        PBKDF2Parameters pBKDF2Parameters = new PBKDF2Parameters("HmacSHA1", "ISO-8859-1", byArray, 1000);
        PBKDF2Engine pBKDF2Engine = new PBKDF2Engine(pBKDF2Parameters);
        int n3 = aesKeyStrength.getKeyLength();
        int n4 = n3 + (n2 = aesKeyStrength.getMacLength()) + 2;
        byte[] byArray2 = pBKDF2Engine.deriveKey(cArray, n4);
        if (byArray2 != null && byArray2.length == n4) {
            return byArray2;
        }
        String string = String.format("Derived Key invalid for Key Length [%d] MAC Length [%d]", n3, n2);
        throw new ZipException(string);
    }

    public static byte[] derivePasswordVerifier(byte[] byArray, AesKeyStrength aesKeyStrength) {
        byte[] byArray2 = new byte[2];
        int n2 = aesKeyStrength.getKeyLength() + aesKeyStrength.getMacLength();
        System.arraycopy(byArray, n2, byArray2, 0, 2);
        return byArray2;
    }

    public static MacBasedPRF getMacBasedPRF(byte[] byArray, AesKeyStrength aesKeyStrength) {
        int n2 = aesKeyStrength.getMacLength();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, aesKeyStrength.getKeyLength(), byArray2, 0, n2);
        MacBasedPRF macBasedPRF = new MacBasedPRF("HmacSHA1");
        macBasedPRF.init(byArray2);
        return macBasedPRF;
    }

    public static AESEngine getAESEngine(byte[] byArray, AesKeyStrength aesKeyStrength) {
        int n2 = aesKeyStrength.getKeyLength();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return new AESEngine(byArray2);
    }

    public static void prepareBuffAESIVBytes(byte[] byArray, int n2) {
        byArray[0] = (byte)n2;
        byArray[1] = (byte)(n2 >> 8);
        byArray[2] = (byte)(n2 >> 16);
        byArray[3] = (byte)(n2 >> 24);
        for (int i2 = 4; i2 <= 15; ++i2) {
            byArray[i2] = 0;
        }
    }
}

