/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.crypto.PBKDF2;

import me.forseth11.easybackup.dependencies.zip4j.crypto.PBKDF2.MacBasedPRF;
import me.forseth11.easybackup.dependencies.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import me.forseth11.easybackup.dependencies.zip4j.crypto.PBKDF2.PRF;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;

public class PBKDF2Engine {
    private PBKDF2Parameters parameters;
    private PRF prf;

    public PBKDF2Engine(PBKDF2Parameters pBKDF2Parameters) {
        this(pBKDF2Parameters, null);
    }

    public PBKDF2Engine(PBKDF2Parameters pBKDF2Parameters, PRF pRF) {
        this.parameters = pBKDF2Parameters;
        this.prf = pRF;
    }

    public byte[] deriveKey(char[] cArray) {
        return this.deriveKey(cArray, 0);
    }

    public byte[] deriveKey(char[] cArray, int n2) {
        if (cArray == null) {
            throw new NullPointerException();
        }
        byte[] byArray = Zip4jUtil.convertCharArrayToByteArray(cArray);
        this.assertPRF(byArray);
        if (n2 == 0) {
            n2 = this.prf.getHLen();
        }
        return this.PBKDF2(this.prf, this.parameters.getSalt(), this.parameters.getIterationCount(), n2);
    }

    public boolean verifyKey(char[] cArray) {
        byte[] byArray = this.getParameters().getDerivedKey();
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        byte[] byArray2 = this.deriveKey(cArray, byArray.length);
        if (byArray2 == null || byArray2.length != byArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            if (byArray2[i2] == byArray[i2]) continue;
            return false;
        }
        return true;
    }

    private void assertPRF(byte[] byArray) {
        if (this.prf == null) {
            this.prf = new MacBasedPRF(this.parameters.getHashAlgorithm());
        }
        this.prf.init(byArray);
    }

    public PRF getPseudoRandomFunction() {
        return this.prf;
    }

    private byte[] PBKDF2(PRF pRF, byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        int n4 = pRF.getHLen();
        int n5 = this.ceil(n3, n4);
        int n6 = n3 - (n5 - 1) * n4;
        byte[] byArray2 = new byte[n5 * n4];
        int n7 = 0;
        for (int i2 = 1; i2 <= n5; ++i2) {
            this._F(byArray2, n7, pRF, byArray, n2, i2);
            n7 += n4;
        }
        if (n6 < n4) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            return byArray3;
        }
        return byArray2;
    }

    private int ceil(int n2, int n3) {
        int n4 = 0;
        if (n2 % n3 > 0) {
            n4 = 1;
        }
        return n2 / n3 + n4;
    }

    private void _F(byte[] byArray, int n2, PRF pRF, byte[] byArray2, int n3, int n4) {
        int n5 = pRF.getHLen();
        byte[] byArray3 = new byte[n5];
        byte[] byArray4 = new byte[byArray2.length + 4];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        this.INT(byArray4, byArray2.length, n4);
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray4 = pRF.doFinal(byArray4);
            this.xor(byArray3, byArray4);
        }
        System.arraycopy(byArray3, 0, byArray, n2, n5);
    }

    private void xor(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = i2;
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[i2]);
        }
    }

    protected void INT(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)(n3 / 0x1000000);
        byArray[n2 + 1] = (byte)(n3 / 65536);
        byArray[n2 + 2] = (byte)(n3 / 256);
        byArray[n2 + 3] = (byte)n3;
    }

    public PBKDF2Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(PBKDF2Parameters pBKDF2Parameters) {
        this.parameters = pBKDF2Parameters;
    }

    public void setPseudoRandomFunction(PRF pRF) {
        this.prf = pRF;
    }
}

