/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.headers;

import java.nio.charset.Charset;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderSignature;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderUtil;
import me.forseth11.easybackup.dependencies.zip4j.model.AESExtraDataRecord;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.LocalFileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipParameters;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.AesKeyStrength;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.CompressionLevel;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.CompressionMethod;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.EncryptionMethod;
import me.forseth11.easybackup.dependencies.zip4j.util.BitUtils;
import me.forseth11.easybackup.dependencies.zip4j.util.FileUtils;
import me.forseth11.easybackup.dependencies.zip4j.util.InternalZipConstants;
import me.forseth11.easybackup.dependencies.zip4j.util.RawIO;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;
import me.forseth11.easybackup.dependencies.zip4j.util.ZipVersionUtils;

public class FileHeaderFactory {
    public FileHeader generateFileHeader(ZipParameters zipParameters, boolean bl2, int n2, Charset charset, RawIO rawIO) {
        FileHeader fileHeader = new FileHeader();
        fileHeader.setSignature(HeaderSignature.CENTRAL_DIRECTORY);
        fileHeader.setVersionMadeBy(ZipVersionUtils.determineVersionMadeBy(zipParameters, rawIO));
        fileHeader.setVersionNeededToExtract(ZipVersionUtils.determineVersionNeededToExtract(zipParameters).getCode());
        if (zipParameters.isEncryptFiles() && zipParameters.getEncryptionMethod() == EncryptionMethod.AES) {
            fileHeader.setCompressionMethod(CompressionMethod.AES_INTERNAL_ONLY);
            fileHeader.setAesExtraDataRecord(this.generateAESExtraDataRecord(zipParameters));
            fileHeader.setExtraFieldLength(fileHeader.getExtraFieldLength() + 11);
        } else {
            fileHeader.setCompressionMethod(zipParameters.getCompressionMethod());
        }
        if (zipParameters.isEncryptFiles()) {
            if (zipParameters.getEncryptionMethod() == null || zipParameters.getEncryptionMethod() == EncryptionMethod.NONE) {
                throw new ZipException("Encryption method has to be set when encryptFiles flag is set in zip parameters");
            }
            fileHeader.setEncrypted(true);
            fileHeader.setEncryptionMethod(zipParameters.getEncryptionMethod());
        }
        String string = this.validateAndGetFileName(zipParameters.getFileNameInZip());
        fileHeader.setFileName(string);
        fileHeader.setFileNameLength(this.determineFileNameLength(string, charset));
        fileHeader.setDiskNumberStart(bl2 ? n2 : 0);
        if (zipParameters.getLastModifiedFileTime() > 0L) {
            fileHeader.setLastModifiedTime(Zip4jUtil.epochToExtendedDosTime(zipParameters.getLastModifiedFileTime()));
        } else {
            fileHeader.setLastModifiedTime(Zip4jUtil.epochToExtendedDosTime(System.currentTimeMillis()));
        }
        boolean bl3 = FileUtils.isZipEntryDirectory(string);
        fileHeader.setDirectory(bl3);
        fileHeader.setExternalFileAttributes(FileUtils.getDefaultFileAttributes(bl3));
        if (zipParameters.isWriteExtendedLocalFileHeader() && zipParameters.getEntrySize() == -1L) {
            fileHeader.setUncompressedSize(0L);
        } else {
            fileHeader.setUncompressedSize(zipParameters.getEntrySize());
        }
        if (zipParameters.isEncryptFiles() && zipParameters.getEncryptionMethod() == EncryptionMethod.ZIP_STANDARD) {
            fileHeader.setCrc(zipParameters.getEntryCRC());
        }
        fileHeader.setGeneralPurposeFlag(this.determineGeneralPurposeBitFlag(fileHeader.isEncrypted(), zipParameters, charset));
        fileHeader.setDataDescriptorExists(zipParameters.isWriteExtendedLocalFileHeader());
        fileHeader.setFileComment(zipParameters.getFileComment());
        return fileHeader;
    }

    public LocalFileHeader generateLocalFileHeader(FileHeader fileHeader) {
        LocalFileHeader localFileHeader = new LocalFileHeader();
        localFileHeader.setSignature(HeaderSignature.LOCAL_FILE_HEADER);
        localFileHeader.setVersionNeededToExtract(fileHeader.getVersionNeededToExtract());
        localFileHeader.setCompressionMethod(fileHeader.getCompressionMethod());
        localFileHeader.setLastModifiedTime(fileHeader.getLastModifiedTime());
        localFileHeader.setUncompressedSize(fileHeader.getUncompressedSize());
        localFileHeader.setFileNameLength(fileHeader.getFileNameLength());
        localFileHeader.setFileName(fileHeader.getFileName());
        localFileHeader.setEncrypted(fileHeader.isEncrypted());
        localFileHeader.setEncryptionMethod(fileHeader.getEncryptionMethod());
        localFileHeader.setAesExtraDataRecord(fileHeader.getAesExtraDataRecord());
        localFileHeader.setCrc(fileHeader.getCrc());
        localFileHeader.setCompressedSize(fileHeader.getCompressedSize());
        localFileHeader.setGeneralPurposeFlag((byte[])fileHeader.getGeneralPurposeFlag().clone());
        localFileHeader.setDataDescriptorExists(fileHeader.isDataDescriptorExists());
        localFileHeader.setExtraFieldLength(fileHeader.getExtraFieldLength());
        return localFileHeader;
    }

    private byte[] determineGeneralPurposeBitFlag(boolean bl2, ZipParameters zipParameters, Charset charset) {
        byte[] byArray = new byte[2];
        byArray[0] = this.generateFirstGeneralPurposeByte(bl2, zipParameters);
        if (charset == null || InternalZipConstants.CHARSET_UTF_8.equals(charset)) {
            byArray[1] = BitUtils.setBit(byArray[1], 3);
        }
        return byArray;
    }

    private byte generateFirstGeneralPurposeByte(boolean bl2, ZipParameters zipParameters) {
        byte by2 = 0;
        if (bl2) {
            by2 = BitUtils.setBit(by2, 0);
        }
        if (CompressionMethod.DEFLATE.equals((Object)zipParameters.getCompressionMethod())) {
            if (CompressionLevel.NORMAL.equals((Object)zipParameters.getCompressionLevel())) {
                by2 = BitUtils.unsetBit(by2, 1);
                by2 = BitUtils.unsetBit(by2, 2);
            } else if (CompressionLevel.MAXIMUM.equals((Object)zipParameters.getCompressionLevel())) {
                by2 = BitUtils.setBit(by2, 1);
                by2 = BitUtils.unsetBit(by2, 2);
            } else if (CompressionLevel.FAST.equals((Object)zipParameters.getCompressionLevel())) {
                by2 = BitUtils.unsetBit(by2, 1);
                by2 = BitUtils.setBit(by2, 2);
            } else if (CompressionLevel.FASTEST.equals((Object)zipParameters.getCompressionLevel()) || CompressionLevel.ULTRA.equals((Object)zipParameters.getCompressionLevel())) {
                by2 = BitUtils.setBit(by2, 1);
                by2 = BitUtils.setBit(by2, 2);
            }
        }
        if (zipParameters.isWriteExtendedLocalFileHeader()) {
            by2 = BitUtils.setBit(by2, 3);
        }
        return by2;
    }

    private String validateAndGetFileName(String string) {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("fileNameInZip is null or empty");
        }
        return string;
    }

    private AESExtraDataRecord generateAESExtraDataRecord(ZipParameters zipParameters) {
        AESExtraDataRecord aESExtraDataRecord = new AESExtraDataRecord();
        if (zipParameters.getAesVersion() != null) {
            aESExtraDataRecord.setAesVersion(zipParameters.getAesVersion());
        }
        if (zipParameters.getAesKeyStrength() == AesKeyStrength.KEY_STRENGTH_128) {
            aESExtraDataRecord.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_128);
        } else if (zipParameters.getAesKeyStrength() == AesKeyStrength.KEY_STRENGTH_192) {
            aESExtraDataRecord.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_192);
        } else if (zipParameters.getAesKeyStrength() == AesKeyStrength.KEY_STRENGTH_256) {
            aESExtraDataRecord.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_256);
        } else {
            throw new ZipException("invalid AES key strength");
        }
        aESExtraDataRecord.setCompressionMethod(zipParameters.getCompressionMethod());
        return aESExtraDataRecord;
    }

    private int determineFileNameLength(String string, Charset charset) {
        return HeaderUtil.getBytesFromString(string, charset).length;
    }
}

