/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.io.inputstream;

import java.io.InputStream;
import me.forseth11.easybackup.dependencies.zip4j.crypto.Decrypter;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.ZipEntryInputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.LocalFileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.CompressionMethod;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;

abstract class CipherInputStream<T extends Decrypter>
extends InputStream {
    private ZipEntryInputStream zipEntryInputStream;
    private T decrypter;
    private byte[] lastReadRawDataCache;
    private byte[] singleByteBuffer = new byte[1];
    private LocalFileHeader localFileHeader;

    public CipherInputStream(ZipEntryInputStream zipEntryInputStream, LocalFileHeader localFileHeader, char[] cArray, int n2) {
        this.zipEntryInputStream = zipEntryInputStream;
        this.decrypter = this.initializeDecrypter(localFileHeader, cArray);
        this.localFileHeader = localFileHeader;
        if (Zip4jUtil.getCompressionMethod(localFileHeader).equals((Object)CompressionMethod.DEFLATE)) {
            this.lastReadRawDataCache = new byte[n2];
        }
    }

    @Override
    public int read() {
        int n2 = this.read(this.singleByteBuffer);
        if (n2 == -1) {
            return -1;
        }
        return this.singleByteBuffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = Zip4jUtil.readFully(this.zipEntryInputStream, byArray, n2, n3);
        if (n4 > 0) {
            this.cacheRawData(byArray, n4);
            this.decrypter.decryptData(byArray, n2, n4);
        }
        return n4;
    }

    @Override
    public void close() {
        this.zipEntryInputStream.close();
    }

    public byte[] getLastReadRawDataCache() {
        return this.lastReadRawDataCache;
    }

    protected int readRaw(byte[] byArray) {
        return this.zipEntryInputStream.readRawFully(byArray);
    }

    private void cacheRawData(byte[] byArray, int n2) {
        if (this.lastReadRawDataCache != null) {
            System.arraycopy(byArray, 0, this.lastReadRawDataCache, 0, n2);
        }
    }

    public T getDecrypter() {
        return this.decrypter;
    }

    protected void endOfEntryReached(InputStream inputStream) {
    }

    protected long getNumberOfBytesReadForThisEntry() {
        return this.zipEntryInputStream.getNumberOfBytesRead();
    }

    public LocalFileHeader getLocalFileHeader() {
        return this.localFileHeader;
    }

    protected abstract T initializeDecrypter(LocalFileHeader var1, char[] var2);
}

