/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.io.outputstream;

import java.io.OutputStream;
import me.forseth11.easybackup.dependencies.zip4j.crypto.AESEncrypter;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.CipherOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.ZipEntryOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipParameters;

class AesCipherOutputStream
extends CipherOutputStream<AESEncrypter> {
    private byte[] pendingBuffer = new byte[16];
    private int pendingBufferLength = 0;

    public AesCipherOutputStream(ZipEntryOutputStream zipEntryOutputStream, ZipParameters zipParameters, char[] cArray) {
        super(zipEntryOutputStream, zipParameters, cArray);
    }

    @Override
    protected AESEncrypter initializeEncrypter(OutputStream outputStream, ZipParameters zipParameters, char[] cArray) {
        AESEncrypter aESEncrypter = new AESEncrypter(cArray, zipParameters.getAesKeyStrength());
        this.writeAesEncryptionHeaderData(aESEncrypter);
        return aESEncrypter;
    }

    private void writeAesEncryptionHeaderData(AESEncrypter aESEncrypter) {
        this.writeHeaders(aESEncrypter.getSaltBytes());
        this.writeHeaders(aESEncrypter.getDerivedPasswordVerifier());
    }

    @Override
    public void write(int n2) {
        this.write(new byte[]{(byte)n2});
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n3 < 16 - this.pendingBufferLength) {
            System.arraycopy(byArray, n2, this.pendingBuffer, this.pendingBufferLength, n3);
            this.pendingBufferLength += n3;
            return;
        }
        System.arraycopy(byArray, n2, this.pendingBuffer, this.pendingBufferLength, 16 - this.pendingBufferLength);
        super.write(this.pendingBuffer, 0, this.pendingBuffer.length);
        n2 = 16 - this.pendingBufferLength;
        this.pendingBufferLength = 0;
        if ((n3 -= n2) != 0 && n3 % 16 != 0) {
            System.arraycopy(byArray, n3 + n2 - n3 % 16, this.pendingBuffer, 0, n3 % 16);
            this.pendingBufferLength = n3 % 16;
            n3 -= this.pendingBufferLength;
        }
        super.write(byArray, n2, n3);
    }

    @Override
    public void closeEntry() {
        if (this.pendingBufferLength != 0) {
            super.write(this.pendingBuffer, 0, this.pendingBufferLength);
            this.pendingBufferLength = 0;
        }
        this.writeHeaders(((AESEncrypter)this.getEncrypter()).getFinalMac());
        super.closeEntry();
    }
}

