/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.io.outputstream;

import java.io.OutputStream;
import me.forseth11.easybackup.dependencies.zip4j.crypto.Encrypter;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.ZipEntryOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipParameters;

abstract class CipherOutputStream<T extends Encrypter>
extends OutputStream {
    private ZipEntryOutputStream zipEntryOutputStream;
    private T encrypter;

    public CipherOutputStream(ZipEntryOutputStream zipEntryOutputStream, ZipParameters zipParameters, char[] cArray) {
        this.zipEntryOutputStream = zipEntryOutputStream;
        this.encrypter = this.initializeEncrypter(zipEntryOutputStream, zipParameters, cArray);
    }

    @Override
    public void write(int n2) {
        this.zipEntryOutputStream.write(n2);
    }

    @Override
    public void write(byte[] byArray) {
        this.zipEntryOutputStream.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.encrypter.encryptData(byArray, n2, n3);
        this.zipEntryOutputStream.write(byArray, n2, n3);
    }

    public void writeHeaders(byte[] byArray) {
        this.zipEntryOutputStream.write(byArray);
    }

    public void closeEntry() {
        this.zipEntryOutputStream.closeEntry();
    }

    @Override
    public void close() {
        this.zipEntryOutputStream.close();
    }

    public long getNumberOfBytesWrittenForThisEntry() {
        return this.zipEntryOutputStream.getNumberOfBytesWrittenForThisEntry();
    }

    protected T getEncrypter() {
        return this.encrypter;
    }

    protected abstract T initializeEncrypter(OutputStream var1, ZipParameters var2, char[] var3);
}

