/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.io.outputstream;

import java.io.OutputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.OutputStreamWithSplitZipSupport;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.SplitOutputStream;

public class CountingOutputStream
extends OutputStream
implements OutputStreamWithSplitZipSupport {
    private OutputStream outputStream;
    private long numberOfBytesWritten = 0L;

    public CountingOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void write(int n2) {
        this.write(new byte[]{(byte)n2});
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.outputStream.write(byArray, n2, n3);
        this.numberOfBytesWritten += (long)n3;
    }

    @Override
    public int getCurrentSplitFileCounter() {
        if (this.isSplitZipFile()) {
            return ((SplitOutputStream)this.outputStream).getCurrentSplitFileCounter();
        }
        return 0;
    }

    public long getOffsetForNextEntry() {
        if (this.outputStream instanceof SplitOutputStream) {
            return ((SplitOutputStream)this.outputStream).getFilePointer();
        }
        return this.numberOfBytesWritten;
    }

    public long getSplitLength() {
        if (this.isSplitZipFile()) {
            return ((SplitOutputStream)this.outputStream).getSplitLength();
        }
        return 0L;
    }

    public boolean isSplitZipFile() {
        return this.outputStream instanceof SplitOutputStream && ((SplitOutputStream)this.outputStream).isSplitZipFile();
    }

    public long getNumberOfBytesWritten() {
        if (this.outputStream instanceof SplitOutputStream) {
            return ((SplitOutputStream)this.outputStream).getFilePointer();
        }
        return this.numberOfBytesWritten;
    }

    public boolean checkBuffSizeAndStartNextSplitFile(int n2) {
        if (!this.isSplitZipFile()) {
            return false;
        }
        return ((SplitOutputStream)this.outputStream).checkBufferSizeAndStartNextSplitFile(n2);
    }

    @Override
    public long getFilePointer() {
        if (this.outputStream instanceof SplitOutputStream) {
            return ((SplitOutputStream)this.outputStream).getFilePointer();
        }
        return this.numberOfBytesWritten;
    }

    @Override
    public void close() {
        this.outputStream.close();
    }
}

