/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.io.outputstream;

import java.io.OutputStream;
import me.forseth11.easybackup.dependencies.zip4j.crypto.StandardEncrypter;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.CipherOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.ZipEntryOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipParameters;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;

class ZipStandardCipherOutputStream
extends CipherOutputStream<StandardEncrypter> {
    public ZipStandardCipherOutputStream(ZipEntryOutputStream zipEntryOutputStream, ZipParameters zipParameters, char[] cArray) {
        super(zipEntryOutputStream, zipParameters, cArray);
    }

    @Override
    protected StandardEncrypter initializeEncrypter(OutputStream outputStream, ZipParameters zipParameters, char[] cArray) {
        long l2 = this.getEncryptionKey(zipParameters);
        StandardEncrypter standardEncrypter = new StandardEncrypter(cArray, l2);
        this.writeHeaders(standardEncrypter.getHeaderBytes());
        return standardEncrypter;
    }

    @Override
    public void write(int n2) {
        this.write(new byte[]{(byte)n2});
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        super.write(byArray, n2, n3);
    }

    private long getEncryptionKey(ZipParameters zipParameters) {
        if (zipParameters.isWriteExtendedLocalFileHeader()) {
            long l2 = Zip4jUtil.epochToExtendedDosTime(zipParameters.getLastModifiedFileTime());
            return (l2 & 0xFFFFL) << 16;
        }
        return zipParameters.getEntryCRC();
    }
}

