/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.ZipInputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.LocalFileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.UnzipParameters;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipModel;
import me.forseth11.easybackup.dependencies.zip4j.progress.ProgressMonitor;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AsyncZipTask;
import me.forseth11.easybackup.dependencies.zip4j.util.BitUtils;
import me.forseth11.easybackup.dependencies.zip4j.util.InternalZipConstants;
import me.forseth11.easybackup.dependencies.zip4j.util.UnzipUtil;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;

public abstract class AbstractExtractFileTask<T>
extends AsyncZipTask<T> {
    private ZipModel zipModel;
    private UnzipParameters unzipParameters;

    public AbstractExtractFileTask(ZipModel zipModel, UnzipParameters unzipParameters, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(asyncTaskParameters);
        this.zipModel = zipModel;
        this.unzipParameters = unzipParameters;
    }

    protected void extractFile(ZipInputStream zipInputStream, FileHeader fileHeader, String string, String string2, ProgressMonitor progressMonitor, byte[] byArray) {
        boolean bl2 = this.isSymbolicLink(fileHeader);
        if (bl2 && !this.unzipParameters.isExtractSymbolicLinks()) {
            return;
        }
        if (!string.endsWith(InternalZipConstants.FILE_SEPARATOR)) {
            string = string + InternalZipConstants.FILE_SEPARATOR;
        }
        File file = this.determineOutputFile(fileHeader, string, string2);
        progressMonitor.setFileName(file.getAbsolutePath());
        String string3 = new File(string).getCanonicalPath() + File.separator;
        if (!file.getCanonicalPath().startsWith(string3)) {
            throw new ZipException("illegal file name that breaks out of the target directory: " + fileHeader.getFileName());
        }
        this.verifyNextEntry(zipInputStream, fileHeader);
        if (fileHeader.isDirectory()) {
            if (!file.exists() && !file.mkdirs()) {
                throw new ZipException("Could not create directory: " + file);
            }
        } else if (this.isSymbolicLink(fileHeader)) {
            this.createSymLink(zipInputStream, fileHeader, file, progressMonitor);
        } else {
            this.checkOutputDirectoryStructure(file);
            this.unzipFile(zipInputStream, file, progressMonitor, byArray);
        }
        UnzipUtil.applyFileAttributes(fileHeader, file);
    }

    private boolean isSymbolicLink(FileHeader fileHeader) {
        byte[] byArray = fileHeader.getExternalFileAttributes();
        if (byArray == null || byArray.length < 4) {
            return false;
        }
        return BitUtils.isBitSet(byArray[3], 5);
    }

    private void unzipFile(ZipInputStream zipInputStream, File file, ProgressMonitor progressMonitor, byte[] byArray) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n2;
            while ((n2 = zipInputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                progressMonitor.updateWorkCompleted(n2);
                this.verifyIfTaskIsCancelled();
            }
        }
        catch (Exception exception) {
            if (file.exists()) {
                file.delete();
            }
            throw exception;
        }
    }

    private void createSymLink(ZipInputStream zipInputStream, FileHeader fileHeader, File file, ProgressMonitor progressMonitor) {
        String string = new String(this.readCompleteEntry(zipInputStream, fileHeader, progressMonitor));
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new ZipException("Could not create parent directories");
        }
        try {
            Path path = Paths.get(string, new String[0]);
            Files.createSymbolicLink(file.toPath(), path, new FileAttribute[0]);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                ((OutputStream)fileOutputStream).write(string.getBytes());
            }
        }
    }

    private byte[] readCompleteEntry(ZipInputStream zipInputStream, FileHeader fileHeader, ProgressMonitor progressMonitor) {
        byte[] byArray = new byte[(int)fileHeader.getUncompressedSize()];
        int n2 = zipInputStream.read(byArray);
        if (n2 != byArray.length) {
            throw new ZipException("Could not read complete entry");
        }
        progressMonitor.updateWorkCompleted(byArray.length);
        return byArray;
    }

    private void verifyNextEntry(ZipInputStream zipInputStream, FileHeader fileHeader) {
        if (BitUtils.isBitSet(fileHeader.getGeneralPurposeFlag()[0], 6)) {
            throw new ZipException("Entry with name " + fileHeader.getFileName() + " is encrypted with Strong Encryption. Zip4j does not support Strong Encryption, as this is patented.");
        }
        LocalFileHeader localFileHeader = zipInputStream.getNextEntry(fileHeader);
        if (localFileHeader == null) {
            throw new ZipException("Could not read corresponding local file header for file header: " + fileHeader.getFileName());
        }
        if (!fileHeader.getFileName().equals(localFileHeader.getFileName())) {
            throw new ZipException("File header and local file header mismatch");
        }
    }

    private void checkOutputDirectoryStructure(File file) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new ZipException("Unable to create parent directories: " + file.getParentFile());
        }
    }

    private File determineOutputFile(FileHeader fileHeader, String string, String string2) {
        String string3 = Zip4jUtil.isStringNotNullAndNotEmpty(string2) ? string2 : this.getFileNameWithSystemFileSeparators(fileHeader.getFileName());
        return new File(string + InternalZipConstants.FILE_SEPARATOR + string3);
    }

    private String getFileNameWithSystemFileSeparators(String string) {
        return string.replaceAll("[/\\\\]", Matcher.quoteReplacement(InternalZipConstants.FILE_SEPARATOR));
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return ProgressMonitor.Task.EXTRACT_ENTRY;
    }

    public ZipModel getZipModel() {
        return this.zipModel;
    }
}

