/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.tasks;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderUtil;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.SplitInputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.ZipInputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.UnzipParameters;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip4jConfig;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipModel;
import me.forseth11.easybackup.dependencies.zip4j.progress.ProgressMonitor;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AbstractExtractFileTask;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AbstractZipTaskParameters;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AsyncZipTask;
import me.forseth11.easybackup.dependencies.zip4j.util.UnzipUtil;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;

public class ExtractFileTask
extends AbstractExtractFileTask<ExtractFileTaskParameters> {
    private char[] password;
    private SplitInputStream splitInputStream;

    public ExtractFileTask(ZipModel zipModel, char[] cArray, UnzipParameters unzipParameters, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(zipModel, unzipParameters, asyncTaskParameters);
        this.password = cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask(ExtractFileTaskParameters extractFileTaskParameters, ProgressMonitor progressMonitor) {
        try (ZipInputStream zipInputStream = this.createZipInputStream(extractFileTaskParameters.fileHeader, extractFileTaskParameters.zip4jConfig);){
            List<FileHeader> list = this.getFileHeadersToExtract(extractFileTaskParameters.fileHeader);
            byte[] byArray = new byte[extractFileTaskParameters.zip4jConfig.getBufferSize()];
            for (FileHeader fileHeader : list) {
                String string = this.determineNewFileName(extractFileTaskParameters.newFileName, extractFileTaskParameters.fileHeader, fileHeader);
                this.extractFile(zipInputStream, fileHeader, extractFileTaskParameters.outputPath, string, progressMonitor, byArray);
            }
        }
        finally {
            if (this.splitInputStream != null) {
                this.splitInputStream.close();
            }
        }
    }

    @Override
    protected long calculateTotalWork(ExtractFileTaskParameters extractFileTaskParameters) {
        List<FileHeader> list = this.getFileHeadersToExtract(extractFileTaskParameters.fileHeader);
        return HeaderUtil.getTotalUncompressedSizeOfAllFileHeaders(list);
    }

    private List<FileHeader> getFileHeadersToExtract(FileHeader fileHeader) {
        if (!fileHeader.isDirectory()) {
            return Collections.singletonList(fileHeader);
        }
        return HeaderUtil.getFileHeadersUnderDirectory(this.getZipModel().getCentralDirectory().getFileHeaders(), fileHeader);
    }

    private ZipInputStream createZipInputStream(FileHeader fileHeader, Zip4jConfig zip4jConfig) {
        this.splitInputStream = UnzipUtil.createSplitInputStream(this.getZipModel());
        this.splitInputStream.prepareExtractionForFileHeader(fileHeader);
        return new ZipInputStream((InputStream)this.splitInputStream, this.password, zip4jConfig);
    }

    private String determineNewFileName(String string, FileHeader fileHeader, FileHeader fileHeader2) {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            return string;
        }
        if (!fileHeader.isDirectory()) {
            return string;
        }
        String string2 = "/";
        if (string.endsWith("/")) {
            string2 = "";
        }
        return fileHeader2.getFileName().replaceFirst(fileHeader.getFileName(), string + string2);
    }

    public static class ExtractFileTaskParameters
    extends AbstractZipTaskParameters {
        private String outputPath;
        private FileHeader fileHeader;
        private String newFileName;

        public ExtractFileTaskParameters(String string, FileHeader fileHeader, String string2, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.outputPath = string;
            this.fileHeader = fileHeader;
            this.newFileName = string2;
        }
    }
}

